/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.TechType;
import bwapi.UnitType;
import bwapi.UpgradeType;
import bwta.BWTA;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.agents.Attack;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.requirements.ConjRequirement;
import com.tyr.requirements.CostRequirement;
import com.tyr.requirements.UnitRequirement;
import com.tyr.tasks.BuildAtLocationTask;
import com.tyr.tasks.ConstantPushTask;
import com.tyr.tasks.LocalDefenseTask;
import com.tyr.unitgroups.ScoutGroup;

public class PvArrak
extends CompositeBuildOrder {
    private ConstantPushTask constantPushTask;
    private LocalDefenseTask localDefenseTask;
    public boolean attackStarted;
    private int armySize = 25;
    private int retreatSize = 20;
    private boolean detectionNeeded = false;
    private boolean upgradeLegSpeed = false;
    private boolean useStorm = false;
    private boolean useDT = false;
    private boolean counterMutas = false;
    private boolean defensesInitialized = false;
    private Position defensivePosition;
    boolean firstAttackDone = false;

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setRequiredSize(100);
        Settings.setMaximumSize(100);
        Settings.setMaximumWorkers(60);
        Settings.setSmallInvasionDist(480);
        Settings.setLargeInvasionDist(768);
        Settings.setWorkersPerGas(2);
        Attack.dontWaitAtCannon = true;
        this.add(new ExpandPart(true));
        if (game.mapFileName().contains("Alchemist") || !ScoutGroup.enemyRaceKnown()) {
            this.add(new WorkerScoutPart(100));
        } else {
            this.add(new WorkerScoutPart(1600));
        }
        ExpandPart.maximumCcs = 2;
        this.localDefenseTask = new LocalDefenseTask(BWTA.getRegion(self.getStartLocation()), 0);
        bot.taskManager.potentialTasks.add(this.localDefenseTask);
        this.constantPushTask = new ConstantPushTask(null, 0);
        this.constantPushTask.stop = true;
        bot.taskManager.potentialTasks.add(this.constantPushTask);
        ConstantPushTask.prioritizeExpands = true;
        super.initialize(game, self, bot);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        DebugMessages.addMessage("Performing PvT build.");
        super.onFrame(game, self, bot);
        if (PvArrak.gas() >= 400) {
            Settings.setWorkersPerGas(2);
        } else if (PvArrak.gas() < 250 && PvArrak.count(GATEWAY) >= 12 || PvArrak.gas() + 400 < PvArrak.minerals()) {
            Settings.setWorkersPerGas(3);
        }
        if (this.constantPushTask != null && PvArrak.completed(ZEALOT) + PvArrak.completed(DRAGOON) <= this.retreatSize && this.firstAttackDone) {
            this.constantPushTask.stop = true;
        }
        if (!(this.constantPushTask == null || PvArrak.completed(ZEALOT) + PvArrak.completed(DRAGOON) < this.armySize || PvArrak.completed(HIGH_TEMPLAR) <= 0 && this.useStorm || !self.hasResearched(TechType.Psionic_Storm) && this.useStorm || !this.firstAttackDone)) {
            ExpandPart.maximumCcs = 100;
            this.constantPushTask.stop = false;
            this.attackStarted = true;
            this.armySize = Math.max(this.armySize, 30);
        }
        if (this.firstAttackDone && PvArrak.completed(ZEALOT) + PvArrak.completed(DRAGOON) >= 30) {
            this.detectionNeeded = true;
        }
        if (!this.firstAttackDone && PvArrak.completed(ZEALOT) + PvArrak.completed(DRAGOON) >= 5) {
            this.constantPushTask.stop = false;
        }
        if (!this.firstAttackDone && !EnemyManager.getManager().enemyDefensiveStructures.isEmpty()) {
            this.constantPushTask.remove();
            this.firstAttackDone = true;
            this.constantPushTask.stop = true;
        }
        if (EnemyManager.getManager().getAllCount(UnitType.Zerg_Mutalisk) > 0) {
            this.useStorm = false;
        }
        if (PvArrak.completed(ZEALOT) + PvArrak.completed(DRAGOON) >= 20) {
            this.upgradeLegSpeed = true;
        }
        if (self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() <= PvArrak.count(GATEWAY) * 3 + UnitTracker.getCcCount() * 3 && PvArrak.minerals() >= 100 && self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400) {
            bot.spaceManager.build(PYLON);
        }
        if (this.defensivePosition != null) {
            Tyr.drawCircle(this.defensivePosition, Color.Purple, 32);
        }
        if (!this.defensesInitialized && game.getFrameCount() >= 9000 && PvArrak.count(NEXUS) >= 2) {
            this.defensesInitialized = true;
            this.defensivePosition = SpaceManager.getNaturalDefensePos();
            BuildAtLocationTask buildTask = new BuildAtLocationTask(this.defensivePosition, true);
            buildTask.addBuilding(UnitType.Protoss_Pylon, new UnitRequirement(UnitType.Protoss_Probe, 7));
            int i = 0;
            while (i < 2) {
                ConjRequirement requirements = new ConjRequirement().addRequirement(new CostRequirement(150, 0));
                buildTask.addBuilding(UnitType.Protoss_Photon_Cannon, requirements);
                ++i;
            }
            bot.taskManager.potentialTasks.add(buildTask);
        }
        if (PvArrak.completed(FORGE) > 0 && PvArrak.minerals() >= 150 && PvArrak.count(CANNON) < 4 && (this.counterMutas || PvArrak.minerals() >= 400)) {
            PvArrak.build(CANNON);
        }
        if (PvArrak.count(NEXUS) >= 2 && PvArrak.minerals() >= 150 && PvArrak.count(GATEWAY) == 0 && PvArrak.completed(PYLON) > 0 && PvArrak.count(PYLON) > 0) {
            bot.spaceManager.build(GATEWAY);
        }
        if (PvArrak.count(NEXUS) >= 2 && PvArrak.minerals() >= 150 && PvArrak.count(GATEWAY) < 2 && PvArrak.count(CYBERNETICS_CORE) > 0) {
            bot.spaceManager.build(GATEWAY);
        }
        if (PvArrak.minerals() >= 150 && PvArrak.count(GATEWAY) < 2) {
            bot.spaceManager.build(GATEWAY);
        }
        if (!this.pauseProduction()) {
            if (PvArrak.count(NEXUS) >= 2 && PvArrak.minerals() >= 150 && PvArrak.count(GATEWAY) < 5 && PvArrak.count(CYBERNETICS_CORE) > 0) {
                bot.spaceManager.build(GATEWAY);
            }
            if (!(PvArrak.count(NEXUS) < 2 || PvArrak.minerals() < 250 || PvArrak.count(CYBERNETICS_CORE) <= 0 || PvArrak.count(GATEWAY) >= 8 || this.defensesInitialized && PvArrak.count(CANNON) <= 0)) {
                bot.spaceManager.build(GATEWAY);
            }
            if (!(PvArrak.count(NEXUS) < 2 || PvArrak.minerals() < 150 || PvArrak.completed(GATEWAY) < 8 || PvArrak.count(GATEWAY) >= 12 || this.defensesInitialized && PvArrak.count(CANNON) <= 0)) {
                bot.spaceManager.build(GATEWAY);
            }
        }
        if (PvArrak.minerals() >= 100 && UnitTracker.getGeyserCount() > 0 && PvArrak.count(GATEWAY) > 0 && PvArrak.count(NEXUS) >= 2) {
            bot.spaceManager.build(ASSIMILATOR);
        }
        if (PvArrak.minerals() >= 200 && PvArrak.count(CYBERNETICS_CORE) < 1 && PvArrak.completed(GATEWAY) > 0 && PvArrak.count(NEXUS) >= 2) {
            bot.spaceManager.build(CYBERNETICS_CORE);
        }
        if (PvArrak.minerals() >= 150 && PvArrak.count(FORGE) < 1 && PvArrak.count(DRAGOON) >= 2) {
            bot.spaceManager.build(FORGE);
        }
        if (this.upgradeLegSpeed && PvArrak.minerals() >= 150 && PvArrak.gas() >= 100 && PvArrak.count(CITADEL) == 0 && PvArrak.completed(CYBERNETICS_CORE) > 0 && PvArrak.count(NEXUS) >= 2) {
            bot.spaceManager.build(CITADEL);
        }
        if (PvArrak.minerals() >= 150 && PvArrak.gas() >= 200 && (this.useStorm || self.getUpgradeLevel(UpgradeType.Protoss_Ground_Armor) + self.getUpgradeLevel(UpgradeType.Protoss_Ground_Weapons) > 0) && PvArrak.count(TEMPLAR_ARCHIVES) < 1 && PvArrak.completed(CITADEL) > 0 && PvArrak.count(NEXUS) >= 2) {
            PvArrak.build(TEMPLAR_ARCHIVES);
        }
        if (PvArrak.gas() >= 200 && PvArrak.minerals() >= 200 && this.detectionNeeded && PvArrak.count(ROBOTICS_FACILITY) == 0 && PvArrak.count(DRAGOON) >= 5) {
            bot.spaceManager.build(ROBOTICS_FACILITY);
        }
        if (PvArrak.gas() >= 50 && PvArrak.minerals() >= 100 && PvArrak.completed(ROBOTICS_FACILITY) > 0 && PvArrak.count(OBSERVATORY) == 0 && this.detectionNeeded) {
            bot.spaceManager.build(OBSERVATORY);
        }
    }

    private boolean pauseProduction() {
        if (PvArrak.gas() > 250 && PvArrak.minerals() > 400) {
            return false;
        }
        if (this.upgradeLegSpeed && PvArrak.count(CITADEL) == 0) {
            return true;
        }
        if (PvArrak.completed(CITADEL) > 0 && !Tyr.self.isUpgrading(UpgradeType.Leg_Enhancements) && Tyr.self.getUpgradeLevel(UpgradeType.Leg_Enhancements) == 0) {
            return true;
        }
        if (PvArrak.completed(CITADEL) > 0 && PvArrak.count(TEMPLAR_ARCHIVES) == 0) {
            return true;
        }
        if (PvArrak.completed(TEMPLAR_ARCHIVES) > 0 && PvArrak.count(HIGH_TEMPLAR) > 0 && !Tyr.self.isResearching(TechType.Psionic_Storm) && !Tyr.self.hasResearched(TechType.Psionic_Storm) && this.useStorm) {
            return true;
        }
        if (this.detectionNeeded && PvArrak.count(DRAGOON) >= 5 && PvArrak.completed(ROBOTICS_FACILITY) == 1 && PvArrak.count(OBSERVATORY) == 0) {
            return true;
        }
        if (this.detectionNeeded && PvArrak.count(DRAGOON) >= 5 && PvArrak.completed(OBSERVATORY) == 1 && PvArrak.count(OBSERVER) == 0) {
            return true;
        }
        if (this.detectionNeeded && PvArrak.count(DRAGOON) >= 5 && PvArrak.count(ROBOTICS_FACILITY) == 0) {
            return true;
        }
        return this.attackStarted && PvArrak.count(NEXUS) < 3;
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (agent.unit.getType() == GATEWAY && !agent.unit.isTraining()) {
            boolean pause = this.pauseProduction();
            if (PvArrak.count(ZEALOT) < 5 && PvArrak.minerals() >= 100 && game.getFrameCount() <= 8000) {
                agent.unit.build(ZEALOT);
            }
            if (pause && PvArrak.minerals() >= 600) {
                agent.unit.build(ZEALOT);
            } else if (PvArrak.count(ZEALOT) + PvArrak.count(DRAGOON) >= 10 * PvArrak.count(HIGH_TEMPLAR) && PvArrak.count(HIGH_TEMPLAR) < 6 && PvArrak.completed(TEMPLAR_ARCHIVES) > 0 && !pause && this.useStorm) {
                if (PvArrak.minerals() >= 50 && PvArrak.gas() >= 150) {
                    agent.unit.build(HIGH_TEMPLAR);
                }
            } else if (self.completedUnitCount(UnitType.Protoss_Templar_Archives) > 0 && PvArrak.count(DARK_TEMPLAR) == 0 && PvArrak.minerals() >= 125 && PvArrak.gas() >= 100 && this.useDT) {
                agent.unit.train(UnitType.Protoss_Dark_Templar);
            } else if (!(PvArrak.count(ZEALOT) >= PvArrak.count(DRAGOON) - 3 || PvArrak.minerals() < 100 || PvArrak.minerals() < 400 && pause)) {
                agent.unit.build(ZEALOT);
            } else if (PvArrak.minerals() >= 125 && PvArrak.gas() >= 50 && (PvArrak.minerals() >= 400 && PvArrak.gas() > 200 || !pause)) {
                agent.unit.build(DRAGOON);
            }
            return true;
        }
        if (agent.unit.getType() == FORGE && !agent.unit.isUpgrading()) {
            if (PvArrak.minerals() >= UpgradeType.Protoss_Ground_Weapons.mineralPrice() && PvArrak.gas() >= UpgradeType.Protoss_Ground_Weapons.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Protoss_Ground_Weapons);
            }
            if (PvArrak.minerals() >= UpgradeType.Protoss_Ground_Armor.mineralPrice() && PvArrak.gas() >= UpgradeType.Protoss_Ground_Armor.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Protoss_Ground_Armor);
            }
        } else if (agent.unit.getType() == CYBERNETICS_CORE && !agent.unit.isUpgrading()) {
            if (PvArrak.minerals() >= UpgradeType.Singularity_Charge.mineralPrice() && PvArrak.gas() >= UpgradeType.Singularity_Charge.gasPrice() && PvArrak.count(DRAGOON) > 5) {
                agent.unit.upgrade(UpgradeType.Singularity_Charge);
            }
        } else {
            if (agent.unit.getType() == ROBOTICS_FACILITY) {
                if (PvArrak.count(OBSERVER) < 2 && PvArrak.completed(OBSERVATORY) > 0 && PvArrak.minerals() >= 25 && PvArrak.gas() >= 75 && !agent.unit.isTraining()) {
                    agent.unit.build(OBSERVER);
                }
                return true;
            }
            if (agent.unit.getType() == CITADEL && !agent.unit.isUpgrading()) {
                if (PvArrak.gas() >= UpgradeType.Leg_Enhancements.gasPrice() && PvArrak.minerals() >= UpgradeType.Leg_Enhancements.mineralPrice()) {
                    agent.unit.upgrade(UpgradeType.Leg_Enhancements);
                }
            } else if (agent.unit.getType() == TEMPLAR_ARCHIVES && !agent.unit.isResearching()) {
                if (this.useStorm && PvArrak.gas() >= TechType.Psionic_Storm.gasPrice() && PvArrak.minerals() >= TechType.Psionic_Storm.mineralPrice() && !self.hasResearched(TechType.Psionic_Storm)) {
                    agent.unit.research(TechType.Psionic_Storm);
                }
            } else if (agent.unit.getType() == STARGATE) {
                if (PvArrak.completed(ARBITER_TRIBUNAL) > 0 && PvArrak.minerals() >= 100 && PvArrak.gas() >= 350 && !agent.unit.isTraining()) {
                    agent.unit.train(ARBITER);
                }
                return true;
            }
        }
        return false;
    }
}

