/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.UnitType;
import bwapi.UpgradeType;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.agents.Attack;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.requirements.ConjRequirement;
import com.tyr.requirements.CostRequirement;
import com.tyr.requirements.UnitRequirement;
import com.tyr.tasks.AirDefenseTask;
import com.tyr.tasks.BuildAtLocationTask;
import com.tyr.tasks.ClearExpandsTask;
import com.tyr.tasks.ConstantPushTask;
import com.tyr.tasks.CorsairHarassTask;
import java.util.ArrayList;

public class ProtossFE
extends CompositeBuildOrder {
    private ConstantPushTask constantPushTask;
    private ClearExpandsTask clearExpandsTask;
    public static final int STANDARD = 0;
    public static final int DRAGOON_ONLY = 1;
    public static final int ZEALOT_ONLY = 2;
    public static final int FAST_REAVER = 3;
    public static final int NO_REAVER = 4;
    private boolean detectionNeeded = false;
    private boolean attackStarted = false;
    private boolean zealotOnly;
    private boolean fastReaver;
    private boolean dragoonOnly;
    private boolean buildReaver;
    boolean defensesInitialized = false;
    private int armySize = 15;
    private int retreatSize = 10;
    boolean attackNatural;

    public ProtossFE(int mode, boolean attackNatural) {
        this.zealotOnly = mode == 2;
        this.dragoonOnly = mode == 1;
        this.fastReaver = mode == 3;
        this.buildReaver = mode != 4;
        this.attackNatural = attackNatural;
    }

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setRequiredSize(100);
        Settings.setMaximumSize(100);
        Settings.setMaximumWorkers(40);
        Settings.setSmallInvasionDist(480);
        Settings.setLargeInvasionDist(768);
        Settings.setWorkersPerGas(2);
        Attack.dontWaitAtCannon = true;
        this.add(new ExpandPart(true));
        this.add(new WorkerScoutPart(1600));
        bot.taskManager.potentialTasks.add(new AirDefenseTask());
        bot.taskManager.potentialTasks.add(new CorsairHarassTask());
        this.clearExpandsTask = new ClearExpandsTask();
        bot.taskManager.potentialTasks.add(this.clearExpandsTask);
        super.initialize(game, self, bot);
    }

    private Position getDefensivePosition() {
        Position location = SpaceManager.getNatural();
        ArrayList<Position> minerals = new ArrayList<Position>();
        for (EnemyPosition neutralUnit : EnemyManager.getManager().neutralBuildingMemory) {
            if (!neutralUnit.type.isMineralField() || !(neutralUnit.pos.getDistance(location) <= 270.0)) continue;
            minerals.add(neutralUnit.pos);
        }
        return SpaceManager.getDefensePosPositions(location, minerals);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        super.onFrame(game, self, bot);
        if (UnitTracker.count(UnitType.Protoss_Robotics_Support_Bay) > 0 || this.dragoonOnly && UnitTracker.count(UnitType.Protoss_Gateway) > 4) {
            Settings.setWorkersPerGas(3);
        }
        if (EnemyManager.getManager().getEnemyTypes().contains(UnitType.Protoss_Dark_Templar) || EnemyManager.getManager().getEnemyTypes().contains(UnitType.Zerg_Lurker)) {
            this.detectionNeeded = true;
        }
        if (!this.attackStarted && bot.homeGroup.units.size() >= this.armySize) {
            this.attackStarted = true;
            Settings.setMaximumWorkers(60);
            this.constantPushTask = new ConstantPushTask(null, this.attackNatural ? 2 : 0);
            bot.taskManager.potentialTasks.add(this.constantPushTask);
        }
        if (self.completedUnitCount(UnitType.Protoss_Zealot) + self.completedUnitCount(UnitType.Protoss_Dragoon) >= 16) {
            this.clearExpandsTask.setActive(true);
        }
        if (self.completedUnitCount(UnitType.Protoss_Zealot) + self.completedUnitCount(UnitType.Protoss_Dragoon) <= 15) {
            this.clearExpandsTask.setActive(false);
        }
        if (this.constantPushTask != null && self.completedUnitCount(UnitType.Protoss_Zealot) + self.completedUnitCount(UnitType.Protoss_Dragoon) <= this.retreatSize) {
            this.constantPushTask.stop = true;
        }
        if (this.constantPushTask != null && self.completedUnitCount(UnitType.Protoss_Zealot) + self.completedUnitCount(UnitType.Protoss_Dragoon) >= this.armySize) {
            this.constantPushTask.stop = false;
        }
        if (!(this.zealotOnly || this.dragoonOnly || this.defensesInitialized || game.getFrameCount() < 100)) {
            this.defensesInitialized = true;
            Position defensivePosition = this.getDefensivePosition();
            BuildAtLocationTask buildTask = new BuildAtLocationTask(defensivePosition, true);
            buildTask.addBuilding(UnitType.Protoss_Pylon, new UnitRequirement(UnitType.Protoss_Probe, 7));
            buildTask.addBuilding(UnitType.Protoss_Forge, new ConjRequirement().addRequirement(new UnitRequirement(UnitType.Protoss_Pylon, 1, true)).addRequirement(new CostRequirement(100, 0)));
            buildTask.addBuilding(UnitType.Protoss_Photon_Cannon, new ConjRequirement().addRequirement(new UnitRequirement(UnitType.Protoss_Forge, 1, true)).addRequirement(new CostRequirement(150, 0)));
            buildTask.addBuilding(UnitType.Protoss_Gateway, new ConjRequirement().addRequirement(new CostRequirement(150, 0)));
            bot.taskManager.potentialTasks.add(buildTask);
        }
        if (self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() <= UnitTracker.count(UnitType.Protoss_Gateway) * 3 + UnitTracker.getCcCount() * 3 && bot.getAvailableMinerals() >= 100 && self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400 && (this.zealotOnly || this.dragoonOnly || UnitTracker.count(UnitType.Protoss_Pylon) > 0)) {
            bot.spaceManager.build(UnitType.Protoss_Pylon);
        }
        if (bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Protoss_Gateway) == 0 && self.completedUnitCount(UnitType.Protoss_Pylon) > 0 && UnitTracker.count(UnitType.Protoss_Pylon) > 0) {
            bot.spaceManager.build(UnitType.Protoss_Gateway);
        }
        if ((UnitTracker.count(UnitType.Protoss_Nexus) >= 2 || bot.getAvailableMinerals() >= 500) && bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Protoss_Gateway) < 2 && UnitTracker.count(UnitType.Protoss_Cybernetics_Core) > 0) {
            bot.spaceManager.build(UnitType.Protoss_Gateway);
        }
        if (UnitTracker.count(UnitType.Protoss_Nexus) >= 2 && bot.getAvailableMinerals() >= 250 && UnitTracker.count(UnitType.Protoss_Gateway) < 4) {
            bot.spaceManager.build(UnitType.Protoss_Gateway);
        }
        if (!(UnitTracker.count(UnitType.Protoss_Nexus) < 3 || bot.getAvailableMinerals() < 150 || UnitTracker.count(UnitType.Protoss_Reaver) <= 0 && this.fastReaver || UnitTracker.count(UnitType.Protoss_Cybernetics_Core) <= 0 && !this.zealotOnly || bot.getAvailableMinerals() < 500 && UnitTracker.count(UnitType.Protoss_Gateway) >= 7 && UnitTracker.count(UnitType.Protoss_Robotics_Support_Bay) <= 0 || UnitTracker.count(UnitType.Protoss_Gateway) >= 8)) {
            bot.spaceManager.build(UnitType.Protoss_Gateway);
        }
        if (UnitTracker.count(UnitType.Protoss_Nexus) >= 3 && bot.getAvailableMinerals() >= 400 && UnitTracker.count(UnitType.Protoss_Gateway) >= 8 && UnitTracker.count(UnitType.Protoss_Templar_Archives) > 0 && UnitTracker.count(UnitType.Protoss_Gateway) < 12) {
            bot.spaceManager.build(UnitType.Protoss_Gateway);
        }
        if ((UnitTracker.count(UnitType.Protoss_Assimilator) < 4 || this.dragoonOnly) && bot.getAvailableMinerals() >= 100 && UnitTracker.getGeyserCount() > 0 && UnitTracker.count(UnitType.Protoss_Gateway) > 0 && UnitTracker.count(UnitType.Protoss_Nexus) > 1 && !this.zealotOnly) {
            bot.spaceManager.build(UnitType.Protoss_Assimilator);
        }
        if (bot.getAvailableMinerals() >= 200 && UnitTracker.count(UnitType.Protoss_Cybernetics_Core) < 1 && self.completedUnitCount(UnitType.Protoss_Gateway) > 0 && UnitTracker.count(UnitType.Protoss_Nexus) > 1 && !this.zealotOnly) {
            bot.spaceManager.build(UnitType.Protoss_Cybernetics_Core);
        }
        if (!(bot.getAvailableMinerals() < 150 || bot.getAvailableGas() < 150 || UnitTracker.count(UnitType.Protoss_Cybernetics_Core) <= 0 || this.dragoonOnly || UnitTracker.count(UnitType.Protoss_Stargate) != 0 || UnitTracker.count(UnitType.Protoss_Nexus) < 3 || self.completedUnitCount(UnitType.Protoss_Robotics_Facility) <= 0 && this.fastReaver)) {
            bot.spaceManager.build(UnitType.Protoss_Stargate);
        }
        if (bot.getAvailableGas() >= 200 && bot.getAvailableMinerals() >= 200 && UnitTracker.count(UnitType.Protoss_Cybernetics_Core) > 0 && !this.dragoonOnly && UnitTracker.count(UnitType.Protoss_Gateway) >= (this.fastReaver ? 4 : 5) && (UnitTracker.count(UnitType.Protoss_Scout) >= 1 || this.fastReaver) && UnitTracker.count(UnitType.Protoss_Robotics_Facility) == 0 && UnitTracker.count(UnitType.Protoss_Dragoon) >= 5) {
            bot.spaceManager.build(UnitType.Protoss_Robotics_Facility);
        }
        if (bot.getAvailableGas() >= 50 && bot.getAvailableMinerals() >= 100 && self.completedUnitCount(UnitType.Protoss_Robotics_Facility) > 0 && UnitTracker.count(UnitType.Protoss_Observatory) == 0) {
            bot.spaceManager.build(UnitType.Protoss_Observatory);
        }
        if (bot.getAvailableGas() >= 100 && bot.getAvailableMinerals() >= 150 && self.completedUnitCount(UnitType.Protoss_Robotics_Facility) > 0 && UnitTracker.count(UnitType.Protoss_Robotics_Support_Bay) == 0 && UnitTracker.count(UnitType.Protoss_Observer) > 0) {
            bot.spaceManager.build(UnitType.Protoss_Robotics_Support_Bay);
        }
        if (bot.getAvailableMinerals() >= 150 && self.completedUnitCount(UnitType.Protoss_Forge) == 0 && !this.zealotOnly && !this.dragoonOnly) {
            bot.spaceManager.build(UnitType.Protoss_Forge);
        }
        if (bot.getAvailableMinerals() >= 150 && self.completedUnitCount(UnitType.Protoss_Forge) == 0 && this.dragoonOnly && this.attackStarted) {
            bot.spaceManager.build(UnitType.Protoss_Forge);
        }
        if (bot.getAvailableMinerals() >= 400 && bot.getAvailableGas() >= 400 && UnitTracker.count(UnitType.Protoss_Citadel_of_Adun) < 1 && self.completedUnitCount(UnitType.Protoss_Cybernetics_Core) > 0 && UnitTracker.count(UnitType.Protoss_Nexus) >= 3) {
            bot.spaceManager.build(UnitType.Protoss_Citadel_of_Adun);
        }
        if (bot.getAvailableMinerals() >= 400 && bot.getAvailableGas() >= 400 && UnitTracker.count(UnitType.Protoss_Templar_Archives) < 1 && self.completedUnitCount(UnitType.Protoss_Citadel_of_Adun) > 0 && UnitTracker.count(UnitType.Protoss_Nexus) >= 3) {
            bot.spaceManager.build(UnitType.Protoss_Templar_Archives);
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (agent.unit.getType() == UnitType.Protoss_Gateway && !agent.unit.isTraining()) {
            if (UnitTracker.count(UnitType.Protoss_Nexus) < 3 && this.attackStarted && bot.getAvailableMinerals() <= 400) {
                return true;
            }
            if (self.completedUnitCount(UnitType.Protoss_Stargate) > 0 && UnitTracker.count(UnitType.Protoss_Scout) == 0) {
                return true;
            }
            if (this.dragoonOnly) {
                if (bot.getAvailableMinerals() >= 125 && bot.getAvailableGas() >= 50) {
                    agent.unit.build(UnitType.Protoss_Dragoon);
                }
                return true;
            }
            if (this.detectionNeeded && UnitTracker.count(UnitType.Protoss_Observer) == 0 && (bot.getAvailableMinerals() <= 325 || bot.getAvailableGas() <= 150)) {
                return true;
            }
            if (!(UnitTracker.count(UnitType.Protoss_Zealot) > UnitTracker.count(UnitType.Protoss_Dragoon) && self.completedUnitCount(UnitType.Protoss_Cybernetics_Core) != 0 || bot.getAvailableMinerals() < 100 || UnitTracker.count(UnitType.Protoss_Zealot) != 0 && UnitTracker.count(UnitType.Protoss_Nexus) <= 1)) {
                agent.unit.build(UnitType.Protoss_Zealot);
            } else if (UnitTracker.count(UnitType.Protoss_Zealot) > UnitTracker.count(UnitType.Protoss_Dragoon) && bot.getAvailableMinerals() >= 125 && bot.getAvailableGas() >= 50) {
                agent.unit.build(UnitType.Protoss_Dragoon);
            }
            return true;
        }
        if (agent.unit.getType() == UnitType.Protoss_Forge && !agent.unit.isUpgrading()) {
            if (bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Weapons.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Weapons.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Protoss_Ground_Weapons);
            }
            if (bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Armor.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Armor.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Protoss_Ground_Armor);
            }
        } else if (agent.unit.getType() == UnitType.Protoss_Cybernetics_Core && !agent.unit.isUpgrading()) {
            if (bot.getAvailableMinerals() >= UpgradeType.Singularity_Charge.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Singularity_Charge.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Singularity_Charge);
            }
        } else {
            if (agent.unit.getType() == UnitType.Protoss_Robotics_Facility) {
                if (!agent.unit.isTraining() && bot.getAvailableMinerals() >= 200 && bot.getAvailableGas() >= 100 && UnitTracker.count(UnitType.Protoss_Observer) >= 2 && this.buildReaver) {
                    agent.unit.build(UnitType.Protoss_Reaver);
                } else if (UnitTracker.count(UnitType.Protoss_Observer) < 2 && bot.getAvailableMinerals() >= 25 && bot.getAvailableGas() >= 75 && !agent.unit.isTraining()) {
                    agent.unit.build(UnitType.Protoss_Observer);
                }
                return true;
            }
            if (agent.unit.getType() == UnitType.Protoss_Stargate) {
                if (bot.getAvailableMinerals() >= 275 && bot.getAvailableGas() >= 125 && !agent.unit.isTraining() && UnitTracker.count(UnitType.Protoss_Scout) == 0) {
                    agent.unit.build(UnitType.Protoss_Scout);
                }
                return true;
            }
            if (agent.unit.getType() == UnitType.Protoss_Citadel_of_Adun && !agent.unit.isUpgrading() && bot.getAvailableGas() >= UpgradeType.Leg_Enhancements.gasPrice() && bot.getAvailableMinerals() >= UpgradeType.Leg_Enhancements.mineralPrice()) {
                agent.unit.upgrade(UpgradeType.Leg_Enhancements);
            }
        }
        return false;
    }
}

