/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.UnitType;
import com.tyr.builds.GenericPart;
import com.tyr.requirements.ConjRequirement;
import com.tyr.requirements.Requirement;

public class GenericPartFactory {
    private UnitType building;
    private int max = 1;
    private int minerals;
    private int gas;
    private ConjRequirement requirements = new ConjRequirement();

    public GenericPartFactory(UnitType building) {
        this.building = building;
        this.minerals = building.mineralPrice();
        this.gas = building.gasPrice();
    }

    public GenericPartFactory setMax(int max) {
        this.max = max;
        return this;
    }

    public GenericPartFactory setCost(int minerals, int gas) {
        this.minerals = minerals;
        this.gas = gas;
        return this;
    }

    public GenericPartFactory additionalCost(int minerals, int gas) {
        this.minerals = minerals + this.building.mineralPrice();
        this.gas = gas + this.building.gasPrice();
        return this;
    }

    public GenericPartFactory add(Requirement req) {
        this.requirements.addRequirement(req);
        return this;
    }

    public GenericPart create() {
        GenericPart result = new GenericPart(this.building, this.max, this.minerals, this.gas, this.requirements);
        return result;
    }
}

