/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.DefensiveStructures;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.GreedyBC;
import com.tyr.builds.SupplyDepotPart;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.unitgroups.ScoutGroup;

public class DefensiveBC
extends CompositeBuildOrder {
    GreedyBC greedy = new GreedyBC();
    int desiredBunkers = 1;
    boolean zealots = false;

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setWorkersPerGas(3);
        this.greedy.initialize(game, self, bot);
        this.add(new SupplyDepotPart());
        this.add(new WorkerScoutPart(1600));
        super.initialize(game, self, bot);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        super.onFrame(game, self, bot);
        if (UnitTracker.count(UnitType.Terran_Bunker) >= this.desiredBunkers && UnitTracker.count(UnitType.Terran_Factory) >= 1) {
            this.greedy.onFrame(game, self, bot);
        }
        if (!this.zealots && bot.scout.opponentStrategy == ScoutGroup.zealotPush) {
            this.zealots = true;
            this.desiredBunkers = 2;
        }
        if (this.zealots) {
            Tyr.drawCircle(Tyr.tileToPosition(self.getStartLocation()), Color.Red);
        }
        if (bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Terran_Barracks) < this.desiredBunkers) {
            bot.spaceManager.build(UnitType.Terran_Barracks);
        }
        if (UnitTracker.getGeyserCount() > 0 && bot.getAvailableMinerals() >= 100 && UnitTracker.count(UnitType.Terran_Refinery) == 0 && UnitTracker.count(UnitType.Terran_Barracks) >= 1 && UnitTracker.count(UnitType.Terran_Bunker) >= this.desiredBunkers) {
            bot.spaceManager.build(UnitType.Terran_Refinery);
        }
        if (bot.getAvailableMinerals() >= 200 && bot.getAvailableGas() >= 100 && UnitTracker.count(UnitType.Terran_Barracks) >= 1 && UnitTracker.count(UnitType.Terran_Factory) < 1) {
            bot.spaceManager.build(UnitType.Terran_Factory);
        }
        if (bot.getAvailableMinerals() >= 100 && UnitTracker.count(UnitType.Terran_Barracks) >= 1) {
            for (DefensiveStructures structures : bot.defensiveStructures) {
                int count = structures.getUnitCount(UnitType.Terran_Bunker);
                if (count >= (!structures.tooFar ? this.desiredBunkers : 0)) continue;
                bot.spaceManager.buildDefensive(UnitType.Terran_Bunker, structures);
                break;
            }
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (super.overrideStructureOrder(game, self, bot, agent)) {
            return true;
        }
        return this.greedy.overrideStructureOrder(game, self, bot, agent);
    }
}

