/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.UpgradeType;
import com.tyr.EnemyManager;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.agents.Attack;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.tasks.ConstantPushTask;

public class DTPush
extends CompositeBuildOrder {
    private boolean hasTurrets = false;
    private ConstantPushTask constantPushTask;
    private boolean cannonsDetected;
    private boolean transition;
    boolean dragoonDefense = false;
    boolean detectionNeeded = false;
    boolean groupDTs;

    public DTPush() {
        this(true);
    }

    public DTPush(boolean groupDTs) {
        this.groupDTs = groupDTs;
    }

    public DTPush(boolean groupDTs, boolean dragoonDefense) {
        this.groupDTs = groupDTs;
        this.dragoonDefense = dragoonDefense;
    }

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setRequiredSize(100);
        Settings.setMaximumSize(100);
        Settings.setMaximumWorkers(20);
        this.add(new WorkerScoutPart(1600));
        this.add(new ExpandPart(true));
        this.constantPushTask = new ConstantPushTask(UnitType.Protoss_Dark_Templar, 1);
        bot.taskManager.potentialTasks.add(this.constantPushTask);
        Attack.dontWaitAtCannon = true;
        super.initialize(game, self, bot);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        boolean baseDestroyed;
        super.onFrame(game, self, bot);
        Settings.setWorkersPerGas(3);
        if (!this.cannonsDetected && EnemyManager.getManager().getEnemyTypes().contains(UnitType.Protoss_Photon_Cannon)) {
            this.cannonsDetected = true;
        }
        if (!this.detectionNeeded) {
            for (Unit unit : EnemyManager.getEnemyUnits()) {
                if (!unit.isLifted() || unit.getType() != UnitType.Terran_Command_Center) continue;
                this.detectionNeeded = true;
                break;
            }
        }
        boolean bl = baseDestroyed = EnemyManager.getManager().enemyBuildingMemory.isEmpty() && UnitTracker.count(UnitType.Protoss_Dark_Templar) > 8;
        if (!this.transition && (this.cannonsDetected || baseDestroyed)) {
            this.transition = true;
            this.constantPushTask.stop = true;
            Settings.setMaximumWorkers(40);
            this.constantPushTask = new ConstantPushTask(null);
            this.constantPushTask.stop = true;
            bot.taskManager.potentialTasks.add(this.constantPushTask);
        }
        if (this.transition) {
            int dragoons;
            int zealots = self.completedUnitCount(UnitType.Protoss_Zealot);
            if (zealots + (dragoons = self.completedUnitCount(UnitType.Protoss_Dragoon)) <= 10) {
                this.constantPushTask.stop = true;
            }
            if (zealots + dragoons >= 20) {
                this.constantPushTask.stop = false;
            }
        }
        if (!this.hasTurrets) {
            this.hasTurrets = EnemyManager.getManager().getEnemyTypes().contains(UnitType.Terran_Missile_Turret);
        }
        if (this.constantPushTask != null && !this.cannonsDetected) {
            boolean bl2 = this.constantPushTask.stop = this.groupDTs && this.hasTurrets && UnitTracker.count(UnitType.Protoss_Dark_Templar) <= 8;
        }
        if (self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() <= UnitTracker.count(UnitType.Protoss_Gateway) * 3 + UnitTracker.getCcCount() * 3 && bot.getAvailableMinerals() >= 100 && self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400) {
            bot.spaceManager.build(UnitType.Protoss_Pylon);
        }
        if (!(bot.getAvailableMinerals() < 150 || UnitTracker.count(UnitType.Protoss_Gateway) >= 1 && bot.getAvailableMinerals() < 300 || UnitTracker.count(UnitType.Protoss_Gateway) >= 2 && UnitTracker.count(UnitType.Protoss_Nexus) < 2 || UnitTracker.count(UnitType.Protoss_Gateway) >= 4)) {
            bot.spaceManager.build(UnitType.Protoss_Gateway);
        }
        if (bot.getAvailableMinerals() >= 250 && this.transition && UnitTracker.count(UnitType.Protoss_Nexus) >= 2 && UnitTracker.count(UnitType.Protoss_Gateway) >= 4 && UnitTracker.count(UnitType.Protoss_Gateway) < 7) {
            bot.spaceManager.build(UnitType.Protoss_Gateway);
        }
        if (bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Protoss_Forge) == 0 && this.transition && UnitTracker.count(UnitType.Protoss_Nexus) >= 2) {
            bot.spaceManager.build(UnitType.Protoss_Forge);
        }
        if (UnitTracker.count(UnitType.Protoss_Assimilator) < 2 && bot.getAvailableMinerals() >= 100 && UnitTracker.getGeyserCount() > 0 && UnitTracker.count(UnitType.Protoss_Gateway) > 0) {
            bot.spaceManager.build(UnitType.Protoss_Assimilator);
        }
        if (bot.getAvailableMinerals() >= 200 && UnitTracker.count(UnitType.Protoss_Cybernetics_Core) < 1 && self.completedUnitCount(UnitType.Protoss_Gateway) > 0) {
            bot.spaceManager.build(UnitType.Protoss_Cybernetics_Core);
        }
        if (bot.getAvailableMinerals() >= 150 && bot.getAvailableGas() >= 100 && UnitTracker.count(UnitType.Protoss_Citadel_of_Adun) < 1 && self.completedUnitCount(UnitType.Protoss_Cybernetics_Core) > 0) {
            bot.spaceManager.build(UnitType.Protoss_Citadel_of_Adun);
        }
        if (bot.getAvailableMinerals() >= 150 && bot.getAvailableGas() >= 200 && UnitTracker.count(UnitType.Protoss_Templar_Archives) < 1 && self.completedUnitCount(UnitType.Protoss_Citadel_of_Adun) > 0) {
            bot.spaceManager.build(UnitType.Protoss_Templar_Archives);
        }
        if (DTPush.gas() >= 200 && DTPush.minerals() >= 200 && this.detectionNeeded && DTPush.count(ROBOTICS_FACILITY) < 1 && DTPush.count(GATEWAY) >= 2) {
            bot.spaceManager.build(ROBOTICS_FACILITY);
        }
        if (DTPush.gas() >= 50 && DTPush.minerals() >= 100 && DTPush.completed(ROBOTICS_FACILITY) > 0 && DTPush.count(OBSERVATORY) == 0) {
            bot.spaceManager.build(OBSERVATORY);
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (agent.unit.getType() == UnitType.Protoss_Gateway) {
            if (!agent.unit.isTraining()) {
                if (!this.transition) {
                    if (self.completedUnitCount(UnitType.Protoss_Templar_Archives) > 0) {
                        agent.unit.train(UnitType.Protoss_Dark_Templar);
                    } else if (bot.getAvailableMinerals() >= 250 && !this.dragoonDefense) {
                        agent.unit.train(UnitType.Protoss_Zealot);
                    } else if (bot.getAvailableMinerals() >= 250 && DTPush.gas() >= 50 && (DTPush.gas() >= 150 || DTPush.count(DRAGOON) < 2) && this.dragoonDefense) {
                        agent.unit.train(DRAGOON);
                    }
                } else if (self.completedUnitCount(UnitType.Protoss_Templar_Archives) > 0 && UnitTracker.count(UnitType.Protoss_Dark_Templar) == 0) {
                    agent.unit.train(UnitType.Protoss_Dark_Templar);
                } else if ((UnitTracker.count(UnitType.Protoss_Zealot) <= UnitTracker.count(UnitType.Protoss_Dragoon) || self.completedUnitCount(UnitType.Protoss_Cybernetics_Core) == 0) && bot.getAvailableMinerals() >= 100) {
                    agent.unit.build(UnitType.Protoss_Zealot);
                } else if (UnitTracker.count(UnitType.Protoss_Zealot) > UnitTracker.count(UnitType.Protoss_Dragoon) && bot.getAvailableMinerals() >= 125 && bot.getAvailableGas() >= 50) {
                    agent.unit.build(UnitType.Protoss_Dragoon);
                }
            }
            return true;
        }
        if (agent.unit.getType() == UnitType.Protoss_Forge && !agent.unit.isUpgrading()) {
            if (bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Weapons.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Weapons.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Protoss_Ground_Weapons);
            }
            if (bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Armor.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Armor.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Protoss_Ground_Armor);
            }
        } else if (agent.unit.getType() == UnitType.Protoss_Citadel_of_Adun && !agent.unit.isUpgrading()) {
            if (bot.getAvailableGas() >= UpgradeType.Leg_Enhancements.gasPrice() && bot.getAvailableMinerals() >= UpgradeType.Leg_Enhancements.mineralPrice()) {
                agent.unit.upgrade(UpgradeType.Leg_Enhancements);
            }
        } else if (agent.unit.getType() == ROBOTICS_FACILITY) {
            if (DTPush.count(OBSERVER) < 3 && DTPush.minerals() >= 25 && DTPush.gas() >= 75 && !agent.unit.isTraining()) {
                agent.unit.build(OBSERVER);
            }
            return true;
        }
        return super.overrideStructureOrder(game, self, bot, agent);
    }
}

