/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;
import bwapi.UpgradeType;
import com.tyr.EnemyManager;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.agents.Attack;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.tasks.ConstantPushTask;
import com.tyr.tasks.CorsairHarassTask;
import com.tyr.unitgroups.PrioritizedAttackGroup;

public class CorsairHarass
extends CompositeBuildOrder {
    private boolean hasAntiAir = false;

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setRequiredSize(100);
        Settings.setMaximumSize(100);
        Settings.setMaximumWorkers(7);
        Settings.setWorkersPerGas(3);
        this.add(new WorkerScoutPart(1600));
        this.add(new ExpandPart(true));
        PrioritizedAttackGroup.allowRetreat = true;
        Attack.requiredAtCannon = 0;
        bot.taskManager.potentialTasks.add(new CorsairHarassTask());
        bot.taskManager.potentialTasks.add(new ConstantPushTask(null, 1));
        super.initialize(game, self, bot);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        super.onFrame(game, self, bot);
        if (UnitTracker.count(UnitType.Protoss_Forge) > 0) {
            Settings.setMaximumWorkers(40);
        } else if (UnitTracker.count(UnitType.Protoss_Cybernetics_Core) > 0) {
            Settings.setMaximumWorkers(30);
        } else if (UnitTracker.count(UnitType.Protoss_Gateway) >= 4) {
            Settings.setMaximumWorkers(25);
        } else if (UnitTracker.count(UnitType.Protoss_Zealot) >= 2) {
            Settings.setMaximumWorkers(20);
        } else if (UnitTracker.count(UnitType.Protoss_Gateway) >= 2) {
            Settings.setMaximumWorkers(9);
        }
        if (EnemyManager.getManager().getEnemyTypes().contains(UnitType.Zerg_Scourge)) {
            this.hasAntiAir = true;
        }
        if (EnemyManager.getManager().getAllCount(UnitType.Zerg_Hydralisk) >= 2) {
            this.hasAntiAir = true;
        }
        if (UnitTracker.count(UnitType.Protoss_Probe) >= 7 && UnitTracker.count(UnitType.Protoss_Pylon) == 0 && bot.getAvailableMinerals() >= 100) {
            bot.spaceManager.build(UnitType.Protoss_Pylon);
        }
        if (self.completedUnitCount(UnitType.Protoss_Pylon) > 0 && bot.getAvailableMinerals() >= 250 && UnitTracker.count(UnitType.Protoss_Gateway) == 0) {
            bot.spaceManager.build(UnitType.Protoss_Gateway);
        }
        if (UnitTracker.count(UnitType.Protoss_Gateway) == 1 && bot.getAvailableMinerals() >= 100) {
            bot.spaceManager.build(UnitType.Protoss_Gateway);
        }
        if (self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() <= UnitTracker.count(UnitType.Protoss_Gateway) * 3 + UnitTracker.getCcCount() * 3 && bot.getAvailableMinerals() >= 100 && self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400 && UnitTracker.count(UnitType.Protoss_Pylon) >= 1 && (UnitTracker.count(UnitType.Protoss_Zealot) >= 2 || self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() < 4)) {
            bot.spaceManager.build(UnitType.Protoss_Pylon);
        }
        if (UnitTracker.count(UnitType.Protoss_Assimilator) < 2 && bot.getAvailableMinerals() >= 100 && UnitTracker.getGeyserCount() > 0 && UnitTracker.count(UnitType.Protoss_Gateway) >= 2 && UnitTracker.count(UnitType.Protoss_Cybernetics_Core) > 0) {
            bot.spaceManager.build(UnitType.Protoss_Assimilator);
        }
        if (bot.getAvailableMinerals() >= 200 && UnitTracker.count(UnitType.Protoss_Cybernetics_Core) < 1 && UnitTracker.count(UnitType.Protoss_Zealot) >= 2) {
            bot.spaceManager.build(UnitType.Protoss_Cybernetics_Core);
        }
        if (bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Protoss_Nexus) >= 2 && UnitTracker.count(UnitType.Protoss_Cybernetics_Core) > 0 && UnitTracker.count(UnitType.Protoss_Forge) == 0) {
            bot.spaceManager.build(UnitType.Protoss_Forge);
        }
        if (bot.getAvailableMinerals() >= 150 && bot.getAvailableGas() >= 150 && UnitTracker.count(UnitType.Protoss_Cybernetics_Core) > 0 && UnitTracker.count(UnitType.Protoss_Stargate) == 0 && !this.hasAntiAir) {
            bot.spaceManager.build(UnitType.Protoss_Stargate);
        }
        if (bot.getAvailableMinerals() >= 300 && UnitTracker.count(UnitType.Protoss_Gateway) < 7 && (UnitTracker.count(UnitType.Protoss_Gateway) < 3 || UnitTracker.count(UnitType.Protoss_Forge) > 0)) {
            bot.spaceManager.build(UnitType.Protoss_Gateway);
        }
        if (bot.getAvailableGas() >= 200 && bot.getAvailableMinerals() >= 200 && UnitTracker.count(UnitType.Protoss_Cybernetics_Core) > 0 && UnitTracker.count(UnitType.Protoss_Gateway) >= 3 && UnitTracker.count(UnitType.Protoss_Robotics_Facility) == 0 && this.hasAntiAir) {
            bot.spaceManager.build(UnitType.Protoss_Robotics_Facility);
        }
        if (bot.getAvailableGas() >= 100 && bot.getAvailableMinerals() >= 150 && self.completedUnitCount(UnitType.Protoss_Robotics_Facility) > 0 && UnitTracker.count(UnitType.Protoss_Robotics_Support_Bay) == 0) {
            bot.spaceManager.build(UnitType.Protoss_Robotics_Support_Bay);
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (agent.unit.getType() == UnitType.Protoss_Gateway && !agent.unit.isTraining()) {
            if (!this.hasAntiAir && self.completedUnitCount(UnitType.Protoss_Stargate) > 0 && UnitTracker.count(UnitType.Protoss_Corsair) == 0) {
                return true;
            }
            if (UnitTracker.count(UnitType.Protoss_Nexus) < 2 && UnitTracker.count(UnitType.Protoss_Zealot) > 5 && UnitTracker.count(UnitType.Protoss_Corsair) >= 3) {
                return true;
            }
            if ((UnitTracker.count(UnitType.Protoss_Zealot) <= UnitTracker.count(UnitType.Protoss_Dragoon) || self.completedUnitCount(UnitType.Protoss_Corsair) == 0) && bot.getAvailableMinerals() >= 100) {
                agent.unit.build(UnitType.Protoss_Zealot);
            } else if (UnitTracker.count(UnitType.Protoss_Zealot) > UnitTracker.count(UnitType.Protoss_Dragoon) && bot.getAvailableMinerals() >= 125 && bot.getAvailableGas() >= 50) {
                agent.unit.build(UnitType.Protoss_Dragoon);
            }
            return true;
        }
        if (agent.unit.getType() == UnitType.Protoss_Cybernetics_Core && !agent.unit.isUpgrading()) {
            if (bot.getAvailableMinerals() >= UpgradeType.Singularity_Charge.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Singularity_Charge.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Singularity_Charge);
            }
        } else if (agent.unit.getType() == UnitType.Protoss_Forge && !agent.unit.isUpgrading()) {
            if (bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Weapons.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Weapons.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Protoss_Ground_Weapons);
            }
            if (bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Armor.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Armor.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Protoss_Ground_Armor);
            }
        } else {
            if (agent.unit.getType() == UnitType.Protoss_Stargate && !agent.unit.isTraining()) {
                if (!this.hasAntiAir && bot.getAvailableMinerals() >= 150 && bot.getAvailableGas() >= 100) {
                    agent.unit.build(UnitType.Protoss_Corsair);
                }
                return true;
            }
            if (agent.unit.getType() == UnitType.Protoss_Robotics_Facility && bot.getAvailableMinerals() >= 200 && bot.getAvailableGas() >= 100 && !agent.unit.isTraining()) {
                agent.unit.build(UnitType.Protoss_Reaver);
            }
        }
        return false;
    }
}

