/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.buildingplacement;

import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwta.BaseLocation;
import com.tyr.BWTAProxy;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.BuildCommand;
import com.tyr.buildingplacement.BuildSiteLocator;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.unitgroups.MineralWorkers;

public class DefaultBuildSite
extends BuildSiteLocator {
    private int stopDist = 40;
    private boolean keepExpandsFree = true;
    private boolean checkMap = true;
    private boolean checkUnits = true;

    public DefaultBuildSite() {
    }

    public DefaultBuildSite(boolean checkMap, boolean keepExpandsFree, boolean checkUnits) {
        this.checkMap = checkMap;
        this.keepExpandsFree = keepExpandsFree;
        this.checkUnits = checkUnits;
    }

    public DefaultBuildSite(boolean checkMap, boolean keepExpandsFree, boolean checkUnits, int stopDist) {
        this.checkMap = checkMap;
        this.keepExpandsFree = keepExpandsFree;
        this.checkUnits = checkUnits;
        this.stopDist = stopDist;
    }

    @Override
    public TilePosition findPlacement(UnitType building, TilePosition preferredTile, Agent worker) {
        if (preferredTile == null) {
            preferredTile = Tyr.game.isVisible(Tyr.self.getStartLocation()) ? Tyr.self.getStartLocation() : (Tyr.bot.workForce.mineralWorkers.size() > 0 ? Tyr.bot.workForce.mineralWorkers.get((int)0).resourceDepot.getTilePosition() : worker.unit.getTilePosition());
        }
        TilePosition buildTile = !Tyr.game.isVisible(preferredTile) ? this.getBuildTileNoVision(worker.unit, building, preferredTile) : this.getBuildTile(worker.unit, building, preferredTile);
        return buildTile;
    }

    public TilePosition getBuildTileNoVision(Unit builder, UnitType buildingType, TilePosition aroundTile) {
        int maxDist = 1;
        while (maxDist < this.stopDist) {
            int i = aroundTile.getX() - maxDist;
            while (i <= aroundTile.getX() + maxDist) {
                if (buildingType != UnitType.Protoss_Pylon || i > 3 && i < Tyr.game.mapWidth() - 3) {
                    int j = aroundTile.getY() - maxDist;
                    while (j <= aroundTile.getY() + maxDist) {
                        if ((buildingType != UnitType.Protoss_Pylon || j > 3 && j < Tyr.game.mapHeight() - 3) && SpaceManager.canBuildHere(builder, i, j, buildingType, this.checkMap, this.keepExpandsFree, this.checkUnits)) {
                            return new TilePosition(i, j);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            maxDist += 2;
        }
        DebugMessages.addMessage("No placement found for " + buildingType + ".");
        return null;
    }

    public TilePosition getBuildTile(Unit builder, UnitType buildingType, TilePosition aroundTile) {
        if (buildingType.isRefinery()) {
            for (Unit n : Tyr.game.neutral().getUnits()) {
                if (n.getType() != UnitType.Resource_Vespene_Geyser || !this.canConstruct(n)) continue;
                return n.getTilePosition();
            }
            return null;
        }
        if (buildingType.isResourceDepot()) {
            BaseLocation loc = null;
            for (BaseLocation b : Tyr.bot.expands) {
                if (!Tyr.game.canBuildHere(b.getTilePosition(), buildingType, builder, false)) continue;
                boolean enemyBase = false;
                for (EnemyPosition p : EnemyManager.getManager().enemyBuildingMemory) {
                    boolean bl = enemyBase = b.getPosition().getDistance(p.pos.getX(), p.pos.getY()) < 256.0;
                    if (enemyBase) break;
                }
                if (enemyBase) continue;
                boolean unitsInWay = false;
                for (BuildCommand cmd : Tyr.bot.buildCommands) {
                    if (!(cmd.position.getDistance(b.getTilePosition()) <= 1.0)) continue;
                    unitsInWay = true;
                    break;
                }
                if (unitsInWay) continue;
                if (BWTAProxy.initialized) {
                    if (loc != null && !(BWTAProxy.getGroundDistance(aroundTile, b.getTilePosition()) < BWTAProxy.getGroundDistance(aroundTile, loc.getTilePosition()))) continue;
                    loc = b;
                    continue;
                }
                if (loc != null && !(aroundTile.getDistance(b.getTilePosition()) < aroundTile.getDistance(loc.getTilePosition()))) continue;
                loc = b;
            }
            return loc == null ? null : loc.getTilePosition();
        }
        if (!Tyr.game.isVisible(aroundTile)) {
            return aroundTile;
        }
        return this.getBuildTileNoVision(builder, buildingType, aroundTile);
    }

    private boolean canConstruct(Unit geyser) {
        boolean alreadyConstructing = false;
        for (BuildCommand com : Tyr.bot.buildCommands) {
            if (!com.building.isRefinery() || com.position.getX() != geyser.getTilePosition().getX() || com.position.getY() != geyser.getTilePosition().getY()) continue;
            alreadyConstructing = true;
            break;
        }
        if (alreadyConstructing) {
            return false;
        }
        boolean hasBase = false;
        for (MineralWorkers base : Tyr.bot.workForce.mineralWorkers) {
            if (base.gasWorkers == null || Math.abs(base.gasWorkers.geyser.getX() - geyser.getX()) > 10 || Math.abs(base.gasWorkers.geyser.getY() - geyser.getY()) > 10 || base.resourceDepot.isBeingConstructed()) continue;
            hasBase = true;
            break;
        }
        return hasBase;
    }
}

