/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.buildingplacement;

import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.BuildSiteLocator;
import com.tyr.buildingplacement.SpaceManager;

public class CompactBuildSite
extends BuildSiteLocator {
    private static final int stopDist = 40;

    @Override
    public TilePosition findPlacement(UnitType building, TilePosition preferredTile, Agent worker) {
        if (preferredTile == null) {
            preferredTile = Tyr.self.getStartLocation();
        }
        return this.getBuildTile(worker.unit, building, preferredTile);
    }

    public TilePosition getBuildTile(Unit builder, UnitType buildingType, TilePosition aroundTile) {
        int maxDist = 3;
        while (maxDist < 40) {
            int i = aroundTile.getX() - maxDist;
            while (i <= aroundTile.getX() + maxDist) {
                int j = aroundTile.getY() - maxDist;
                while (j <= aroundTile.getY() + maxDist) {
                    if (SpaceManager.canBuildHere(builder, i, j, buildingType)) {
                        return new TilePosition(i, j);
                    }
                    ++j;
                }
                ++i;
            }
            ++maxDist;
        }
        return null;
    }
}

