/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.buildingplacement;

import bwapi.Position;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwta.BaseLocation;
import com.tyr.BWTAProxy;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.PositionUtil;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.BuildSiteLocator;
import java.util.ArrayList;
import java.util.Comparator;

public class BaseBuildSite
extends BuildSiteLocator {
    private boolean gasOnly;

    public BaseBuildSite(boolean gasOnly) {
        this.gasOnly = gasOnly;
    }

    @Override
    public TilePosition findPlacement(UnitType building, TilePosition preferredTile, Agent worker) {
        if (preferredTile == null) {
            preferredTile = Tyr.game.isVisible(Tyr.self.getStartLocation()) ? Tyr.self.getStartLocation() : (Tyr.bot.workForce.mineralWorkers.size() > 0 ? Tyr.bot.workForce.mineralWorkers.get((int)0).resourceDepot.getTilePosition() : worker.unit.getTilePosition());
        }
        return this.getBuildTile(worker.unit, building, preferredTile);
    }

    public TilePosition getBuildTile(Unit builder, UnitType buildingType, TilePosition aroundTile) {
        if (!buildingType.isResourceDepot()) {
            return null;
        }
        BaseLocation loc = null;
        double bestDist = 2.147483647E9;
        double enemyDist = 0.0;
        if (Tyr.game.mapFileName().contains("Alchemist") && UnitTracker.getCcCount() <= 1 && Tyr.bot.suspectedEnemy.size() == 1) {
            Position enemyMain = Tyr.bot.suspectedEnemy.get(0).getPosition();
            final Position main = Tyr.getStartLocation();
            ArrayList<TilePosition> bases = new ArrayList<TilePosition>();
            for (BaseLocation base : Tyr.bot.expands) {
                if (PositionUtil.distanceSq(base.getPosition(), main) < 10000) continue;
                bases.add(base.getTilePosition());
            }
            bases.sort(new Comparator<TilePosition>(){

                @Override
                public int compare(TilePosition p1, TilePosition p2) {
                    return PositionUtil.distanceSq(main, Tyr.tileToPosition(p1)) - PositionUtil.distanceSq(main, Tyr.tileToPosition(p2));
                }
            });
            if (PositionUtil.distanceSq(Tyr.tileToPosition((TilePosition)bases.get(0)), enemyMain) <= PositionUtil.distanceSq(Tyr.tileToPosition((TilePosition)bases.get(1)), enemyMain)) {
                return (TilePosition)bases.get(0);
            }
            return (TilePosition)bases.get(1);
        }
        for (BaseLocation b : Tyr.bot.expands) {
            if (this.gasOnly && b.isMineralOnly() || b.isIsland() || b.minerals() < 8000 || !Tyr.game.canBuildHere(b.getTilePosition(), buildingType, builder, false)) continue;
            boolean enemyBase = false;
            for (EnemyPosition p : EnemyManager.getManager().enemyBuildingMemory) {
                boolean bl = enemyBase = b.getPosition().getDistance(p.pos.getX(), p.pos.getY()) < 256.0;
                if (enemyBase) break;
            }
            if (enemyBase || enemyDist > 0.0 && (double)PositionUtil.distanceSq(b.getPosition(), Tyr.bot.suspectedEnemy.get(0).getPosition()) > enemyDist) continue;
            if (BWTAProxy.initialized) {
                double dist = this.dist(b.getTilePosition(), aroundTile);
                if (!(dist >= 0.0)) continue;
                if (PositionUtil.distanceSq(b.getPosition(), Tyr.getStartLocation()) <= 160000) {
                    bestDist += 1.0E9;
                }
                if (loc != null && !(dist < bestDist)) continue;
                loc = b;
                bestDist = dist;
                continue;
            }
            if (loc != null && !(aroundTile.getDistance(b.getTilePosition()) < aroundTile.getDistance(loc.getTilePosition()))) continue;
            loc = b;
        }
        return loc == null ? null : loc.getTilePosition();
    }

    private double dist(TilePosition pos, TilePosition aroundTile) {
        if (Tyr.game.mapFileName().contains("Plasma")) {
            return PositionUtil.distanceSq(Tyr.tileToPosition(pos), Tyr.tileToPosition(aroundTile));
        }
        return BWTAProxy.getGroundDistance(aroundTile, pos);
    }
}

