/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.agents;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Unit;
import bwapi.UnitType;
import com.tyr.EnemyManager;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.Command;
import java.util.List;

public class RepairBunker
extends Command {
    private Agent bunker;
    private Unit repairTarget;

    public RepairBunker(Agent agent, Agent bunker) {
        super(agent);
        this.bunker = bunker;
    }

    @Override
    public void execute(Game game, Player self, Tyr bot) {
        this.agent.drawCircle(Color.Purple);
        if (this.bunker.unit.getHitPoints() < UnitType.Terran_Bunker.maxHitPoints()) {
            if (!this.agent.unit.isRepairing()) {
                this.agent.unit.repair(this.bunker.unit);
            }
            return;
        }
        if (EnemyManager.getManager().getInvader() == null) {
            if (this.repairTarget != null) {
                if (!this.repairTarget.exists() || this.repairTarget.getHitPoints() <= 0 || this.repairTarget.getRemoveTimer() != 0 || this.bunker.distanceSquared(this.repairTarget) > 129600 || this.repairTarget.getHitPoints() >= this.repairTarget.getType().maxHitPoints() || this.repairTarget.getPlayer() != self) {
                    this.repairTarget = null;
                } else {
                    return;
                }
            }
            List<Unit> inRange = game.getUnitsInRadius(this.bunker.unit.getPosition(), 360);
            for (Unit unit : inRange) {
                if (unit.getPlayer() != self || !unit.getType().isBuilding() && !unit.getType().isMechanical() || unit.getHitPoints() >= unit.getType().maxHitPoints() || !unit.isCompleted()) continue;
                this.repairTarget = unit;
                this.agent.unit.repair(unit);
                return;
            }
        }
        if (this.agent.distanceSquared(this.bunker) >= 4096) {
            this.agent.unit.move(this.bunker.unit.getPosition());
        }
    }

    @Override
    public boolean replace(Command command) {
        if (command.getClass() != RepairBunker.class) {
            return true;
        }
        return ((RepairBunker)command).bunker != this.bunker;
    }
}

