/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.agents;

import bwapi.Color;
import bwapi.Game;
import bwapi.Order;
import bwapi.Position;
import bwapi.TechType;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.WeaponType;
import com.tyr.EnemyManager;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.agents.BunkerAgent;
import com.tyr.agents.Command;
import com.tyr.agents.None;
import com.tyr.agents.VultureAgent;
import com.tyr.agents.WorkerAgent;
import com.tyr.agents.WraithAgent;
import java.util.List;

public class Agent {
    public Unit unit;
    protected Command command;
    protected int lastOrderFrame;
    public boolean mark = false;
    private Unit closeEnemy = null;
    private static int previousFrame = 0;

    public Agent(Unit unit) {
        this.unit = unit;
        this.command = new None(this);
    }

    public boolean isDead() {
        return this.unit.getHitPoints() <= 0 || this.unit.getRemoveTimer() != 0 || !this.unit.exists() || this.unit.getPlayer() != Tyr.game.self();
    }

    public void drawCircle(Color color) {
        Tyr.drawCircle(this.unit.getPosition(), color);
    }

    public void drawCircle(Color color, int r) {
        Tyr.drawCircle(this.unit.getPosition(), color, r);
    }

    public int distanceSquared(Agent agent) {
        return this.distanceSquared(agent.unit);
    }

    public int distanceSquared(Unit unit) {
        return this.distanceSquared(unit.getPosition());
    }

    public int distanceSquared(Position pos) {
        int dx = this.unit.getPosition().getX() - pos.getX();
        int dy = this.unit.getPosition().getY() - pos.getY();
        return dx * dx + dy * dy;
    }

    public static Agent createAgent(Unit unit) {
        if (unit.getType() == UnitType.Terran_Wraith) {
            return new WraithAgent(unit);
        }
        if (unit.getType() == UnitType.Terran_Vulture) {
            return new VultureAgent(unit);
        }
        if (unit.getType() == UnitType.Terran_Bunker) {
            return new BunkerAgent(unit);
        }
        if (unit.getType().isWorker()) {
            return new WorkerAgent(unit);
        }
        return new Agent(unit);
    }

    public Position retreatTarget(Position other, double dist) {
        double fleeDY;
        double fleeDX = this.unit.getPosition().getX() - other.getX();
        double length = Math.sqrt(fleeDX * fleeDX + (fleeDY = (double)(this.unit.getPosition().getY() - other.getY())) * fleeDY);
        if (length == 0.0) {
            fleeDX = 1.0;
            fleeDY = 0.0;
        } else {
            fleeDX /= length;
            fleeDY /= length;
        }
        return new Position((int)((double)this.unit.getPosition().getX() + fleeDX * dist), (int)((double)this.unit.getPosition().getY() + fleeDY * dist));
    }

    public void order(Command command) {
        if (command.replace(this.command)) {
            this.command = command;
        }
    }

    public Command getCommand() {
        return this.command;
    }

    public void attack(Position target) {
        int currentFrame = Tyr.game.getFrameCount();
        if (currentFrame - this.lastOrderFrame > (this.unit.getType() == UnitType.Protoss_Reaver ? 256 : 32)) {
            this.unit.attack(target);
            this.lastOrderFrame = currentFrame;
        }
    }

    public void move(Position target) {
        int currentFrame = Tyr.game.getFrameCount();
        if (currentFrame - this.lastOrderFrame > 32) {
            this.unit.move(target);
            this.lastOrderFrame = currentFrame;
        }
    }

    public void attack(Unit target) {
        int currentFrame = Tyr.game.getFrameCount();
        if (currentFrame - this.lastOrderFrame > 32) {
            this.unit.attack(target);
            this.lastOrderFrame = currentFrame;
            this.drawCircle(Color.Red, 12);
        } else {
            this.drawCircle(Color.Green, 12);
        }
    }

    public static boolean isRanged(Unit unit) {
        if (unit.getType() == UnitType.Terran_Bunker || unit.getType() == UnitType.Protoss_Reaver) {
            return true;
        }
        return !unit.getType().isWorker() && unit.getType().groundWeapon().maxRange() >= 32;
    }

    public Unit getYamatoTarget() {
        Game game = Tyr.game;
        if (!game.self().hasResearched(TechType.Yamato_Gun)) {
            Tyr.drawCircle(this.unit.getPosition(), Color.Yellow, 6);
            return null;
        }
        if (this.unit.getEnergy() < TechType.Yamato_Gun.energyCost()) {
            Tyr.drawCircle(this.unit.getPosition(), Color.Blue, 6);
            return null;
        }
        boolean first = false;
        if (previousFrame != game.getFrameCount()) {
            previousFrame = game.getFrameCount();
            first = true;
            Tyr.drawCircle(this.unit.getPosition(), Color.Red, WeaponType.Yamato_Gun.maxRange());
        }
        Unit target = null;
        int preference = 0;
        List<Unit> inRange = game.getUnitsInRadius(this.unit.getPosition(), WeaponType.Yamato_Gun.maxRange() + 32);
        for (Unit unit : inRange) {
            if (!unit.getPlayer().isEnemy(game.self())) continue;
            UnitType enemyType = unit.getType();
            int newPreference = 0;
            if (enemyType == UnitType.Protoss_Carrier || enemyType == UnitType.Terran_Battlecruiser) {
                newPreference = 5;
            } else if (enemyType == UnitType.Protoss_Photon_Cannon) {
                newPreference = 4;
            } else if (enemyType == UnitType.Protoss_High_Templar || enemyType == UnitType.Protoss_Dark_Archon || enemyType == UnitType.Terran_Goliath) {
                newPreference = 3;
            } else if (enemyType == UnitType.Protoss_Archon || enemyType == UnitType.Terran_Missile_Turret) {
                newPreference = 2;
            } else if (enemyType == UnitType.Protoss_Dragoon || enemyType == UnitType.Terran_Bunker) {
                newPreference = 1;
            }
            if (first) {
                if (preference == 0) {
                    Tyr.drawCircle(unit.getPosition(), Color.Red, 6);
                } else {
                    Tyr.drawCircle(unit.getPosition(), Color.Green, 6);
                }
            }
            if (newPreference <= preference) continue;
            preference = newPreference;
            target = unit;
        }
        if (target == null) {
            Tyr.drawCircle(this.unit.getPosition(), Color.Red, 6);
            return null;
        }
        Tyr.drawCircle(this.unit.getPosition(), Color.Green, 6);
        Tyr.drawCircle(target.getPosition(), Color.Yellow);
        game.drawLineMap(this.unit.getPosition().getX(), this.unit.getPosition().getY(), target.getPosition().getX(), target.getPosition().getY(), Color.Yellow);
        return target;
    }

    public boolean isTank() {
        return this.unit.getType() == UnitType.Terran_Siege_Tank_Siege_Mode || this.unit.getType() == UnitType.Terran_Siege_Tank_Tank_Mode;
    }

    public static void clean(List<Agent> agents) {
        int i = agents.size() - 1;
        while (i >= 0) {
            if (agents.get(i) == null || agents.get(i).isDead()) {
                agents.remove(i);
            }
            --i;
        }
    }

    public static boolean isDead(Unit unit) {
        return unit.getHitPoints() <= 0 || unit.getRemoveTimer() != 0 || !unit.exists() || unit.getPlayer() != Tyr.game.self();
    }

    public static boolean isTank(Unit unit) {
        return unit.getType() == UnitType.Terran_Siege_Tank_Siege_Mode || unit.getType() == UnitType.Terran_Siege_Tank_Tank_Mode;
    }

    public void stutterstep(Position target, boolean moveCloser) {
        int distSq;
        boolean enemyInRange = false;
        if (this.closeEnemy != null && this.closeEnemy.getHitPoints() > 0 && this.closeEnemy.getRemoveTimer() == 0 && this.closeEnemy.exists() && this.closeEnemy.getPlayer() != Tyr.game.self() && ((distSq = this.distanceSquared(this.closeEnemy)) < 40000 || this.closeEnemy.getType() != UnitType.Zerg_Overlord && distSq < 1000000)) {
            enemyInRange = true;
        }
        if (!enemyInRange) {
            for (Unit unit : EnemyManager.getEnemyUnits()) {
                int distSq2 = this.distanceSquared(unit);
                if (distSq2 >= 40000 && (unit.getType() == UnitType.Zerg_Overlord || distSq2 >= 1000000)) continue;
                enemyInRange = true;
                this.closeEnemy = unit;
                break;
            }
        }
        if (Settings.attackNeutralStructures() && !enemyInRange) {
            for (Unit unit : Tyr.game.neutral().getUnits()) {
                if (this.distanceSquared(unit) >= 40000 || !unit.getType().isBuilding() || unit.getType().isResourceContainer() || unit.getDistance(Tyr.tileToPosition(Tyr.self.getStartLocation())) >= 1536) continue;
                Tyr.drawCircle(unit.getPosition(), Color.Blue);
                Tyr.game.drawLineMap(unit.getX(), unit.getY(), unit.getX(), unit.getY(), Color.Red);
                this.attack(unit);
                return;
            }
        }
        if (this.distanceSquared(target) <= 16384) {
            return;
        }
        if (this.unit.getGroundWeaponCooldown() > 1 && this.unit.getAirWeaponCooldown() > 1 && Agent.isRanged(this.unit)) {
            int distSq3;
            int minRadius = Math.max(32, this.unit.getType().groundWeapon().maxRange() - 64);
            int maxRadius = this.unit.getType().groundWeapon().maxRange();
            int level = 2;
            if (!moveCloser) {
                level = 1;
            }
            if (this.closeEnemy != null && this.closeEnemy.getHitPoints() > 0 && this.closeEnemy.getRemoveTimer() == 0 && this.closeEnemy.exists() && this.closeEnemy.getPlayer() != Tyr.game.self()) {
                distSq3 = this.distanceSquared(this.closeEnemy);
                if (!this.closeEnemy.getType().isBuilding() && !Agent.isRanged(this.closeEnemy) && distSq3 <= maxRadius * maxRadius) {
                    level = 0;
                } else if (!this.closeEnemy.getType().isBuilding() && distSq3 <= minRadius * minRadius) {
                    level = 0;
                } else if (distSq3 <= maxRadius) {
                    level = 1;
                }
            }
            if (level > 0) {
                for (Unit unit : EnemyManager.getEnemyUnits()) {
                    distSq3 = this.distanceSquared(unit);
                    if (!unit.getType().isBuilding() && !Agent.isRanged(unit) && distSq3 <= maxRadius * maxRadius) {
                        this.closeEnemy = unit;
                        level = 0;
                        break;
                    }
                    if (!unit.getType().isBuilding() && distSq3 <= minRadius * minRadius) {
                        this.closeEnemy = unit;
                        level = 0;
                        break;
                    }
                    if (distSq3 > maxRadius) continue;
                    this.closeEnemy = unit;
                    level = 1;
                }
            }
            if (level == 0) {
                this.unit.move(Tyr.tileToPosition(Tyr.game.self().getStartLocation()));
                this.drawCircle(Color.Green, 4);
            } else if (level == 1) {
                this.drawCircle(Color.Yellow, 4);
            } else if (level == 2) {
                this.unit.move(target);
                this.drawCircle(Color.Red, 4);
            }
        } else if (this.unit.isHoldingPosition() || this.unit.isIdle() || this.unit.getGroundWeaponCooldown() == 1 || this.unit.getAirWeaponCooldown() == 1) {
            Tyr.drawCircle(this.unit.getPosition(), Color.Green, 6);
            this.attack(target);
        } else {
            this.orderAttack(target);
        }
    }

    public void orderAttack(Position target) {
        Order order = this.unit.getOrder();
        Position orderTarget = this.unit.getOrderTargetPosition();
        double dist = target.getDistance(orderTarget);
        if (!(order != Order.AttackMove && order != Order.Move && !this.unit.isIdle() || this.unit.getTarget() != null || !Agent.isRanged(this.unit) && this.unit.getGroundWeaponCooldown() != 0 || Math.abs(target.getX() - orderTarget.getX()) < 10 && Math.abs(target.getY() - orderTarget.getY()) < 10 && !(dist >= 10.0) && order != Order.Move)) {
            Tyr.drawCircle(this.unit.getPosition(), Color.White, 6);
            this.attack(target);
        }
    }
}

