/*
 * Decompiled with CFR 0.152.
 */
package com.tyr;

import bwapi.Game;
import bwapi.Player;
import bwapi.TilePosition;
import bwapi.UnitType;
import com.tyr.BWTAProxy;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.agents.None;
import com.tyr.unitgroups.OutOfJob;
import java.util.ArrayList;

public class Scanner {
    private int[][] state;
    private int scans = 0;
    private int row = 0;
    private int unseen = 0;
    private final int rowsPerStep = 2;
    public static final int Initializing = 0;
    public static final int Scanning = 1;
    public static final int Eliminating = 2;
    public int action = 0;
    private int width;
    private int height;
    private ArrayList<Agent> groundUnits = new ArrayList();
    private ArrayList<Agent> airUnits = new ArrayList();
    public static boolean restart = false;

    public Scanner() {
        this.state = new int[Tyr.game.mapWidth()][];
        this.width = Tyr.game.mapWidth();
        this.height = Tyr.game.mapHeight();
    }

    public void onFrame(Game game, Player self, Tyr bot) {
        DebugMessages.addMessage("Scanner units: " + (this.groundUnits.size() + this.airUnits.size()));
        if (!restart && !BWTAProxy.initialized) {
            return;
        }
        int i = 0;
        while (i < 2) {
            if (this.action == 0) {
                this.initialize(game, self, bot);
            } else if (this.action == 1 && !restart) {
                this.scan(game, self, bot);
            } else if (this.action == 2 || restart) {
                this.eliminate(game, self, bot);
            }
            if (this.incrementRow()) {
                if (this.unseen == 0) {
                    ++this.scans;
                }
                this.unseen = 0;
            }
            ++i;
        }
    }

    private boolean incrementRow() {
        ++this.row;
        if (this.row >= this.width) {
            this.row = 0;
        }
        return this.row == 0;
    }

    private void initialize(Game game, Player self, Tyr bot) {
        this.state[this.row] = new int[this.height];
        if (this.row >= this.width - 1) {
            this.action = 1;
        }
    }

    private void scan(Game game, Player self, Tyr bot) {
        int y = 0;
        while (y < this.height) {
            if (this.state[this.row][y] != this.scans) {
                if (game.isVisible(new TilePosition(this.row, y))) {
                    this.state[this.row][y] = this.scans;
                } else {
                    ++this.unseen;
                }
            }
            ++y;
        }
    }

    private void eliminate(Game game, Player self, Tyr bot) {
        this.scan(game, self, bot);
        if (EnemyManager.getManager().getInvader() != null || EnemyManager.getManager().enemyBuildingMemory.size() > 0) {
            return;
        }
        for (Agent agent : this.groundUnits) {
            if (agent.unit.getType() != UnitType.Terran_Siege_Tank_Siege_Mode) continue;
            agent.unit.unsiege();
        }
        int groundPos = this.nextGroundPos(-1);
        int airPos = this.nextAirPos(-1);
        int y = 0;
        while (y < this.height) {
            if (this.state[this.row][y] != this.scans) {
                boolean walkable = false;
                int dx = 0;
                while (!walkable && dx < 4) {
                    int dy = 0;
                    while (!walkable && dy < 4) {
                        if (game.isWalkable(this.row * 4 + dx, y * 4 + dy)) {
                            walkable = true;
                            break;
                        }
                        ++dy;
                    }
                    ++dx;
                }
                if (walkable) {
                    if (groundPos < this.groundUnits.size()) {
                        Agent agent = this.groundUnits.get(groundPos);
                        agent.order(new None(agent));
                        agent.unit.attack(Tyr.tileToPosition(new TilePosition(this.row, Math.min(y + 2, game.mapHeight()))));
                        groundPos = this.nextGroundPos(groundPos);
                        y += 5;
                    }
                } else if (airPos < this.airUnits.size()) {
                    Agent agent = this.airUnits.get(airPos);
                    agent.order(new None(agent));
                    agent.unit.attack(Tyr.tileToPosition(new TilePosition(this.row, Math.min(y + 2, game.mapHeight()))));
                    airPos = this.nextAirPos(airPos);
                    y += 5;
                }
            }
            ++y;
        }
    }

    private int nextGroundPos(int i) {
        ++i;
        while (i < this.groundUnits.size() && !this.groundUnits.get((int)i).unit.isIdle()) {
            ++i;
        }
        return i;
    }

    private int nextAirPos(int i) {
        ++i;
        while (i < this.airUnits.size() && !this.airUnits.get((int)i).unit.isIdle()) {
            ++i;
        }
        return i;
    }

    public void startElimination() {
        if (this.action != 2) {
            this.action = 2;
            Settings.scannerEliminating();
            if (UnitTracker.count(UnitType.Terran_Factory) == 0) {
                Tyr.bot.spaceManager.build(UnitType.Terran_Factory);
            }
            if (UnitTracker.count(UnitType.Terran_Refinery) == 0) {
                Tyr.bot.spaceManager.build(UnitType.Terran_Refinery);
            }
            if (UnitTracker.count(UnitType.Terran_Starport) == 0) {
                Tyr.bot.spaceManager.build(UnitType.Terran_Starport);
            }
        }
    }

    public void addAir(Agent agent) {
        if (agent != null) {
            this.airUnits.add(agent);
            agent.order(new None(agent));
        }
    }

    public void addGround(Agent agent) {
        if (agent != null) {
            this.groundUnits.add(agent);
            agent.order(new None(agent));
        }
    }

    public void add(Agent agent) {
        if (agent.unit.getType().isFlyer()) {
            this.addAir(agent);
        } else {
            this.addGround(agent);
        }
    }

    public void clear(OutOfJob rejects) {
        for (Agent agent : this.groundUnits) {
            rejects.add(agent);
        }
        this.groundUnits = new ArrayList();
        for (Agent agent : this.airUnits) {
            rejects.add(agent);
        }
        this.airUnits = new ArrayList();
    }

    public int getGroundUnitCount() {
        return this.groundUnits.size();
    }
}

