/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.threadpool.locks;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import scala.actors.threadpool.TimeUnit;
import scala.actors.threadpool.helpers.FIFOWaitQueue;
import scala.actors.threadpool.helpers.WaitQueue;
import scala.actors.threadpool.locks.CondVar;
import scala.actors.threadpool.locks.Condition;

class FIFOCondVar
extends CondVar
implements Condition,
Serializable {
    private static final long serialVersionUID = -497497271881010475L;
    private static final WaitQueue.QueuedSync sync = new WaitQueue.QueuedSync(){

        @Override
        public boolean recheck(WaitQueue.WaitNode node) {
            return false;
        }

        @Override
        public void takeOver(WaitQueue.WaitNode node) {
        }
    };
    private final WaitQueue wq = new FIFOWaitQueue();

    FIFOCondVar(CondVar.ExclusiveLock lock) {
        super(lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitUninterruptibly() {
        int i;
        int holdCount = this.lock.getHoldCount();
        if (holdCount == 0) {
            throw new IllegalMonitorStateException();
        }
        WaitQueue.WaitNode n = new WaitQueue.WaitNode();
        this.wq.insert(n);
        for (i = holdCount; i > 0; --i) {
            this.lock.unlock();
        }
        try {
            n.doWaitUninterruptibly(sync);
        }
        finally {
            for (i = holdCount; i > 0; --i) {
                this.lock.lock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void await() throws InterruptedException {
        int i;
        int holdCount = this.lock.getHoldCount();
        if (holdCount == 0) {
            throw new IllegalMonitorStateException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        WaitQueue.WaitNode n = new WaitQueue.WaitNode();
        this.wq.insert(n);
        for (i = holdCount; i > 0; --i) {
            this.lock.unlock();
        }
        try {
            n.doWait(sync);
        }
        finally {
            for (i = holdCount; i > 0; --i) {
                this.lock.lock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        int i;
        int holdCount = this.lock.getHoldCount();
        if (holdCount == 0) {
            throw new IllegalMonitorStateException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long nanos = unit.toNanos(timeout);
        WaitQueue.WaitNode n = new WaitQueue.WaitNode();
        this.wq.insert(n);
        boolean success2 = false;
        for (i = holdCount; i > 0; --i) {
            this.lock.unlock();
        }
        try {
            success2 = n.doTimedWait(sync, nanos);
        }
        finally {
            for (i = holdCount; i > 0; --i) {
                this.lock.lock();
            }
        }
        return success2;
    }

    @Override
    public boolean awaitUntil(Date deadline) throws InterruptedException {
        if (deadline == null) {
            throw new NullPointerException();
        }
        long abstime = deadline.getTime();
        long start = System.currentTimeMillis();
        long msecs = abstime - start;
        return this.await(msecs, TimeUnit.MILLISECONDS);
    }

    @Override
    public void signal() {
        WaitQueue.WaitNode w;
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        do {
            if ((w = this.wq.extract()) != null) continue;
            return;
        } while (!w.signal(sync));
    }

    @Override
    public void signalAll() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        WaitQueue.WaitNode w;
        while ((w = this.wq.extract()) != null) {
            w.signal(sync);
        }
        return;
    }

    @Override
    protected boolean hasWaiters() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        return this.wq.hasNodes();
    }

    @Override
    protected int getWaitQueueLength() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        return this.wq.getLength();
    }

    @Override
    protected Collection getWaitingThreads() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        return this.wq.getWaitingThreads();
    }
}

