/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.threadpool;

import scala.actors.threadpool.AbstractExecutorService;
import scala.actors.threadpool.BlockingQueue;
import scala.actors.threadpool.Callable;
import scala.actors.threadpool.CompletionService;
import scala.actors.threadpool.Executor;
import scala.actors.threadpool.Future;
import scala.actors.threadpool.FutureTask;
import scala.actors.threadpool.LinkedBlockingQueue;
import scala.actors.threadpool.RunnableFuture;
import scala.actors.threadpool.TimeUnit;

public class ExecutorCompletionService
implements CompletionService {
    private final Executor executor;
    private final AbstractExecutorService aes;
    private final BlockingQueue completionQueue;

    private RunnableFuture newTaskFor(Callable task) {
        if (this.aes == null) {
            return new FutureTask(task);
        }
        return this.aes.newTaskFor(task);
    }

    private RunnableFuture newTaskFor(Runnable task, Object result2) {
        if (this.aes == null) {
            return new FutureTask(task, result2);
        }
        return this.aes.newTaskFor(task, result2);
    }

    public ExecutorCompletionService(Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.aes = executor instanceof AbstractExecutorService ? (AbstractExecutorService)executor : null;
        this.completionQueue = new LinkedBlockingQueue();
    }

    public ExecutorCompletionService(Executor executor, BlockingQueue completionQueue) {
        if (executor == null || completionQueue == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.aes = executor instanceof AbstractExecutorService ? (AbstractExecutorService)executor : null;
        this.completionQueue = completionQueue;
    }

    @Override
    public Future submit(Callable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture f = this.newTaskFor(task);
        this.executor.execute(new QueueingFuture(f));
        return f;
    }

    @Override
    public Future submit(Runnable task, Object result2) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture f = this.newTaskFor(task, result2);
        this.executor.execute(new QueueingFuture(f));
        return f;
    }

    @Override
    public Future take() throws InterruptedException {
        return (Future)this.completionQueue.take();
    }

    @Override
    public Future poll() {
        return (Future)this.completionQueue.poll();
    }

    @Override
    public Future poll(long timeout, TimeUnit unit) throws InterruptedException {
        return (Future)this.completionQueue.poll(timeout, unit);
    }

    private class QueueingFuture
    extends FutureTask {
        private final Future task;

        QueueingFuture(RunnableFuture task) {
            super(task, null);
            this.task = task;
        }

        @Override
        protected void done() {
            ExecutorCompletionService.this.completionQueue.add(this.task);
        }
    }
}

