/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.threadpool;

import java.io.Serializable;

public class AtomicInteger
extends Number
implements Serializable {
    private static final long serialVersionUID = 6214790243416807050L;
    private volatile int value;

    public AtomicInteger(int initialValue) {
        this.value = initialValue;
    }

    public AtomicInteger() {
    }

    public final int get() {
        return this.value;
    }

    public final synchronized void set(int newValue) {
        this.value = newValue;
    }

    public final synchronized void lazySet(int newValue) {
        this.value = newValue;
    }

    public final synchronized int getAndSet(int newValue) {
        int old = this.value;
        this.value = newValue;
        return old;
    }

    public final synchronized boolean compareAndSet(int expect, int update2) {
        if (this.value == expect) {
            this.value = update2;
            return true;
        }
        return false;
    }

    public final synchronized boolean weakCompareAndSet(int expect, int update2) {
        if (this.value == expect) {
            this.value = update2;
            return true;
        }
        return false;
    }

    public final synchronized int getAndIncrement() {
        return this.value++;
    }

    public final synchronized int getAndDecrement() {
        return this.value--;
    }

    public final synchronized int getAndAdd(int delta) {
        int old = this.value;
        this.value += delta;
        return old;
    }

    public final synchronized int incrementAndGet() {
        return ++this.value;
    }

    public final synchronized int decrementAndGet() {
        return --this.value;
    }

    public final synchronized int addAndGet(int delta) {
        return this.value += delta;
    }

    public String toString() {
        return Integer.toString(this.get());
    }

    @Override
    public int intValue() {
        return this.get();
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }
}

