/*
 * Decompiled with CFR 0.152.
 */
package Strategery.History;

import Lifecycle.With$;
import Strategery.History.HistoricalGame;
import bwapi.Race;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$Long$;
import scala.runtime.BoxesRunTime;

public final class HistorySerializer$ {
    public static final HistorySerializer$ MODULE$;
    private final int formatVersion;
    private final String separator;

    static {
        new HistorySerializer$();
    }

    public int formatVersion() {
        return this.formatVersion;
    }

    public String separator() {
        return this.separator;
    }

    public Vector<HistoricalGame> readGames(Iterable<String> serializedHistory) {
        return ((TraversableOnce)serializedHistory.flatMap(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<HistoricalGame> apply(String serializedGame) {
                return Option$.MODULE$.option2Iterable(HistorySerializer$.MODULE$.Strategery$History$HistorySerializer$$readGame(serializedGame));
            }
        }, Iterable$.MODULE$.canBuildFrom())).toVector();
    }

    public Option<HistoricalGame> Strategery$History$HistorySerializer$$readGame(String serializedGame) {
        Option option;
        try {
            option = new Some<HistoricalGame>(this.readGameFromColumns(serializedGame.split(this.separator())));
        }
        catch (Exception exception) {
            With$.MODULE$.logger().warn(new StringBuilder().append((Object)"Failed to deserialize game: ").append((Object)serializedGame).toString());
            With$.MODULE$.logger().onException(exception);
            option = None$.MODULE$;
        }
        return option;
    }

    private HistoricalGame readGameFromColumns(String[] columns) {
        long id = new StringOps(Predef$.MODULE$.augmentString(columns[0])).toLong();
        int startLocations2 = new StringOps(Predef$.MODULE$.augmentString(columns[1])).toInt();
        String mapName = columns[2];
        String opponentName = columns[3];
        String ourRace = columns[4];
        String enemyRace = columns[5];
        boolean won = new StringOps(Predef$.MODULE$.augmentString(columns[6])).toBoolean();
        Set<String> strategies = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])columns).drop(7)).toSet();
        Race[] allRaces = (Race[])((Object[])new Race[]{Race.Terran, Race.Protoss, Race.Zerg, Race.Random, Race.None, Race.Unknown});
        return new HistoricalGame(id, startLocations2, mapName, opponentName, Predef$.MODULE$.refArrayOps((Object[])allRaces).find(new Serializable(ourRace){
            public static final long serialVersionUID = 0L;
            private final String ourRace$1;

            public final boolean apply(Race x$1) {
                String string2 = x$1.toString();
                String string3 = this.ourRace$1;
                return !(string2 != null ? !string2.equals(string3) : string3 != null);
            }
            {
                this.ourRace$1 = ourRace$1;
            }
        }).getOrElse(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Race apply() {
                return Race.Unknown;
            }
        }), Predef$.MODULE$.refArrayOps((Object[])allRaces).find(new Serializable(enemyRace){
            public static final long serialVersionUID = 0L;
            private final String enemyRace$1;

            public final boolean apply(Race x$2) {
                String string2 = x$2.toString();
                String string3 = this.enemyRace$1;
                return !(string2 != null ? !string2.equals(string3) : string3 != null);
            }
            {
                this.enemyRace$1 = enemyRace$1;
            }
        }).getOrElse(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Race apply() {
                return Race.Unknown;
            }
        }), won, strategies);
    }

    public Iterable<String> writeGames(Iterable<HistoricalGame> games) {
        return ((TraversableLike)games.toVector().sortBy((Function1)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(HistoricalGame x$3) {
                return -x$3.timestamp();
            }
        }), (Ordering)Ordering$Long$.MODULE$)).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(HistoricalGame game) {
                return HistorySerializer$.MODULE$.Strategery$History$HistorySerializer$$writeGame(game);
            }
        }, Vector$.MODULE$.canBuildFrom());
    }

    public String Strategery$History$HistorySerializer$$writeGame(HistoricalGame game) {
        List columns = ((List)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToLong(game.timestamp())).toString(), ((Object)BoxesRunTime.boxToInteger(game.startLocations())).toString(), game.mapName().toString(), game.enemyName().toString(), game.ourRace().toString(), game.enemyRace().toString(), ((Object)BoxesRunTime.boxToBoolean(game.won())).toString()}))).$plus$plus(game.strategies(), List$.MODULE$.canBuildFrom());
        return columns.mkString(this.separator());
    }

    private HistorySerializer$() {
        MODULE$ = this;
        this.formatVersion = 2;
        this.separator = ",,,";
    }
}

