/*
 * Decompiled with CFR 0.152.
 */
package Lifecycle;

import Debugging.Camera;
import Debugging.Configuration;
import Debugging.Logger;
import Debugging.Visualizations.Viewport;
import Debugging.Visualizations.Visualization;
import Information.Battles.BattleClassifier;
import Information.DamageCredit;
import Information.Economy;
import Information.Geography.Geography;
import Information.Geography.Pathfinding.Paths;
import Information.Grids.Grids;
import Information.Intelligence;
import Macro.Allocation.Bank;
import Macro.Allocation.Groundskeeper;
import Macro.Allocation.Prioritizer;
import Macro.Allocation.Recruiter;
import Macro.Architecture.Architecture;
import Macro.Architecture.PlacementScheduler;
import Macro.Scheduling.Scheduler;
import Micro.Agency.Agency;
import Micro.Agency.Commander;
import Micro.Matchups.MatchupGraph;
import Micro.Squads.Squads;
import Performance.Latency;
import Performance.PerformanceMonitor;
import Performance.TaskQueue.AbstractTaskQueue;
import Performance.TaskQueue.TaskQueueGlobal;
import Planning.Blackboard;
import ProxyBwapi.Players.PlayerInfo;
import ProxyBwapi.Players.Players$;
import ProxyBwapi.ProxyBWMirror;
import ProxyBwapi.UnitTracking.UnitTracker;
import Strategery.History.History;
import Strategery.Strategist;
import bwapi.Game;
import bwapi.Player;
import bwta.BWTA;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;

public final class With$ {
    public static final With$ MODULE$;
    private Game game;
    private Agency agents;
    private Architecture architecture;
    private Bank bank;
    private Blackboard blackboard;
    private BattleClassifier battles;
    private Camera camera;
    private Commander commander;
    private Configuration configuration;
    private DamageCredit damageCredit;
    private Economy economy;
    private Geography geography;
    private Grids grids;
    private Groundskeeper groundskeeper;
    private History history;
    private Intelligence intelligence;
    private Latency latency;
    private Logger logger;
    private MatchupGraph matchups;
    private Paths paths;
    private PerformanceMonitor performance;
    private PlacementScheduler placement;
    private ProxyBWMirror proxy;
    private Prioritizer prioritizer;
    private Recruiter recruiter;
    private Scheduler scheduler;
    private Strategist strategy;
    private Squads squads;
    private AbstractTaskQueue tasks;
    private UnitTracker units;
    private Viewport viewport;
    private Visualization visualization;
    private PlayerInfo self;
    private PlayerInfo neutral;
    private Vector<PlayerInfo> enemies;
    private int frame;
    private int mapTileWidth;
    private int mapTileHeight;
    private String mapFileName;

    static {
        new With$();
    }

    public Game game() {
        return this.game;
    }

    public void game_$eq(Game x$1) {
        this.game = x$1;
    }

    public Agency agents() {
        return this.agents;
    }

    public void agents_$eq(Agency x$1) {
        this.agents = x$1;
    }

    public Architecture architecture() {
        return this.architecture;
    }

    public void architecture_$eq(Architecture x$1) {
        this.architecture = x$1;
    }

    public Bank bank() {
        return this.bank;
    }

    public void bank_$eq(Bank x$1) {
        this.bank = x$1;
    }

    public Blackboard blackboard() {
        return this.blackboard;
    }

    public void blackboard_$eq(Blackboard x$1) {
        this.blackboard = x$1;
    }

    public BattleClassifier battles() {
        return this.battles;
    }

    public void battles_$eq(BattleClassifier x$1) {
        this.battles = x$1;
    }

    public Camera camera() {
        return this.camera;
    }

    public void camera_$eq(Camera x$1) {
        this.camera = x$1;
    }

    public Commander commander() {
        return this.commander;
    }

    public void commander_$eq(Commander x$1) {
        this.commander = x$1;
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public void configuration_$eq(Configuration x$1) {
        this.configuration = x$1;
    }

    public DamageCredit damageCredit() {
        return this.damageCredit;
    }

    public void damageCredit_$eq(DamageCredit x$1) {
        this.damageCredit = x$1;
    }

    public Economy economy() {
        return this.economy;
    }

    public void economy_$eq(Economy x$1) {
        this.economy = x$1;
    }

    public Geography geography() {
        return this.geography;
    }

    public void geography_$eq(Geography x$1) {
        this.geography = x$1;
    }

    public Grids grids() {
        return this.grids;
    }

    public void grids_$eq(Grids x$1) {
        this.grids = x$1;
    }

    public Groundskeeper groundskeeper() {
        return this.groundskeeper;
    }

    public void groundskeeper_$eq(Groundskeeper x$1) {
        this.groundskeeper = x$1;
    }

    public History history() {
        return this.history;
    }

    public void history_$eq(History x$1) {
        this.history = x$1;
    }

    public Intelligence intelligence() {
        return this.intelligence;
    }

    public void intelligence_$eq(Intelligence x$1) {
        this.intelligence = x$1;
    }

    public Latency latency() {
        return this.latency;
    }

    public void latency_$eq(Latency x$1) {
        this.latency = x$1;
    }

    public Logger logger() {
        return this.logger;
    }

    public void logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public MatchupGraph matchups() {
        return this.matchups;
    }

    public void matchups_$eq(MatchupGraph x$1) {
        this.matchups = x$1;
    }

    public Paths paths() {
        return this.paths;
    }

    public void paths_$eq(Paths x$1) {
        this.paths = x$1;
    }

    public PerformanceMonitor performance() {
        return this.performance;
    }

    public void performance_$eq(PerformanceMonitor x$1) {
        this.performance = x$1;
    }

    public PlacementScheduler placement() {
        return this.placement;
    }

    public void placement_$eq(PlacementScheduler x$1) {
        this.placement = x$1;
    }

    public ProxyBWMirror proxy() {
        return this.proxy;
    }

    public void proxy_$eq(ProxyBWMirror x$1) {
        this.proxy = x$1;
    }

    public Prioritizer prioritizer() {
        return this.prioritizer;
    }

    public void prioritizer_$eq(Prioritizer x$1) {
        this.prioritizer = x$1;
    }

    public Recruiter recruiter() {
        return this.recruiter;
    }

    public void recruiter_$eq(Recruiter x$1) {
        this.recruiter = x$1;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public void scheduler_$eq(Scheduler x$1) {
        this.scheduler = x$1;
    }

    public Strategist strategy() {
        return this.strategy;
    }

    public void strategy_$eq(Strategist x$1) {
        this.strategy = x$1;
    }

    public Squads squads() {
        return this.squads;
    }

    public void squads_$eq(Squads x$1) {
        this.squads = x$1;
    }

    public AbstractTaskQueue tasks() {
        return this.tasks;
    }

    public void tasks_$eq(AbstractTaskQueue x$1) {
        this.tasks = x$1;
    }

    public UnitTracker units() {
        return this.units;
    }

    public void units_$eq(UnitTracker x$1) {
        this.units = x$1;
    }

    public Viewport viewport() {
        return this.viewport;
    }

    public void viewport_$eq(Viewport x$1) {
        this.viewport = x$1;
    }

    public Visualization visualization() {
        return this.visualization;
    }

    public void visualization_$eq(Visualization x$1) {
        this.visualization = x$1;
    }

    public PlayerInfo self() {
        return this.self;
    }

    public void self_$eq(PlayerInfo x$1) {
        this.self = x$1;
    }

    public PlayerInfo neutral() {
        return this.neutral;
    }

    public void neutral_$eq(PlayerInfo x$1) {
        this.neutral = x$1;
    }

    public Vector<PlayerInfo> enemies() {
        return this.enemies;
    }

    public void enemies_$eq(Vector<PlayerInfo> x$1) {
        this.enemies = x$1;
    }

    public PlayerInfo enemy() {
        return this.enemies().head();
    }

    public int frame() {
        return this.frame;
    }

    public void frame_$eq(int x$1) {
        this.frame = x$1;
    }

    public int mapTileWidth() {
        return this.mapTileWidth;
    }

    public void mapTileWidth_$eq(int x$1) {
        this.mapTileWidth = x$1;
    }

    public int mapTileHeight() {
        return this.mapTileHeight;
    }

    public void mapTileHeight_$eq(int x$1) {
        this.mapTileHeight = x$1;
    }

    public String mapFileName() {
        return this.mapFileName;
    }

    public void mapFileName_$eq(String x$1) {
        this.mapFileName = x$1;
    }

    public int mapPixelWidth() {
        return this.mapTileWidth() * 32;
    }

    public int mapPixelHeight() {
        return this.mapTileHeight() * 32;
    }

    public int framesSince(int previousFrame) {
        return Math.max(0, this.frame() - previousFrame);
    }

    public void onFrame() {
        this.frame_$eq(this.game().getFrameCount());
    }

    public void onStart() {
        this.game().setLatCom(false);
        this.game().enableFlag(1);
        this.game().setLocalSpeed(0);
        this.proxy_$eq(new ProxyBWMirror());
        this.self_$eq(Players$.MODULE$.get(this.game().self()));
        this.neutral_$eq(Players$.MODULE$.get(this.game().neutral()));
        this.enemies_$eq(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.game().enemies()).asScala()).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final PlayerInfo apply(Player player) {
                return Players$.MODULE$.get(player);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toVector());
        this.mapTileWidth_$eq(this.game().mapWidth());
        this.mapTileHeight_$eq(this.game().mapHeight());
        this.mapFileName_$eq(this.game().mapFileName());
        this.configuration_$eq(new Configuration());
        this.logger_$eq(new Logger());
        this.initializeBWTA();
        this.agents_$eq(new Agency());
        this.architecture_$eq(new Architecture());
        this.bank_$eq(new Bank());
        this.blackboard_$eq(new Blackboard());
        this.battles_$eq(new BattleClassifier());
        this.camera_$eq(new Camera());
        this.commander_$eq(new Commander());
        this.damageCredit_$eq(new DamageCredit());
        this.economy_$eq(new Economy());
        this.groundskeeper_$eq(new Groundskeeper());
        this.geography_$eq(new Geography());
        this.grids_$eq(new Grids());
        this.history_$eq(new History());
        this.intelligence_$eq(new Intelligence());
        this.latency_$eq(new Latency());
        this.matchups_$eq(new MatchupGraph());
        this.paths_$eq(new Paths());
        this.performance_$eq(new PerformanceMonitor());
        this.placement_$eq(new PlacementScheduler());
        this.prioritizer_$eq(new Prioritizer());
        this.recruiter_$eq(new Recruiter());
        this.scheduler_$eq(new Scheduler());
        this.strategy_$eq(new Strategist());
        this.squads_$eq(new Squads());
        this.tasks_$eq(new TaskQueueGlobal());
        this.units_$eq(new UnitTracker());
        this.viewport_$eq(new Viewport());
        this.visualization_$eq(new Visualization());
        this.game().setLocalSpeed(this.configuration().gameSpeed());
    }

    public void onEnd() {
        this.logger().flush();
        BWTA.cleanMemory();
    }

    private void initializeBWTA() {
        this.logger().debug(new StringBuilder().append((Object)"Loading BWTA for ").append((Object)this.game().mapName()).append((Object)" at ").append((Object)this.game().mapFileName()).toString());
        BWTA.readMap();
        BWTA.analyze();
        BWTA.computeDistanceTransform();
        BWTA.buildChokeNodes();
    }

    private With$() {
        MODULE$ = this;
        this.frame = 0;
        this.mapTileWidth = 0;
        this.mapTileHeight = 0;
    }
}

