/*
 * Decompiled with CFR 0.152.
 */
package Debugging.Visualizations.Views.Micro;

import Debugging.Visualizations.Colors$;
import Debugging.Visualizations.ForceColors$;
import Debugging.Visualizations.Rendering.DrawMap$;
import Debugging.Visualizations.Views.View;
import Lifecycle.With$;
import Mathematics.Physics.Force;
import Mathematics.Points.Pixel;
import Mathematics.Points.PixelRay;
import Mathematics.Points.Tile;
import Micro.Actions.Action;
import Micro.Agency.Agent;
import Micro.Agency.Explosion;
import Planning.Plan;
import ProxyBwapi.UnitInfo.UnitInfo;
import ProxyBwapi.UnitInfo.UnitProxy;
import Utilities.ByOption$;
import bwapi.Color;
import bwapi.UnitCommand;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.math.Ordering$Double$;
import scala.runtime.BoxesRunTime;

public final class ShowUnitsFriendly$
extends View {
    public static final ShowUnitsFriendly$ MODULE$;
    private boolean showClient;
    private boolean showAction;
    private boolean showCommand;
    private boolean showOrder;
    private boolean showTargets;
    private boolean showFormation;
    private boolean showKiting;
    private boolean showForces;
    private boolean showDesire;
    private boolean showExplosions;

    static {
        new ShowUnitsFriendly$();
    }

    public boolean showClient() {
        return this.showClient;
    }

    public void showClient_$eq(boolean x$1) {
        this.showClient = x$1;
    }

    public boolean showAction() {
        return this.showAction;
    }

    public void showAction_$eq(boolean x$1) {
        this.showAction = x$1;
    }

    public boolean showCommand() {
        return this.showCommand;
    }

    public void showCommand_$eq(boolean x$1) {
        this.showCommand = x$1;
    }

    public boolean showOrder() {
        return this.showOrder;
    }

    public void showOrder_$eq(boolean x$1) {
        this.showOrder = x$1;
    }

    public boolean showTargets() {
        return this.showTargets;
    }

    public void showTargets_$eq(boolean x$1) {
        this.showTargets = x$1;
    }

    public boolean showFormation() {
        return this.showFormation;
    }

    public void showFormation_$eq(boolean x$1) {
        this.showFormation = x$1;
    }

    public boolean showKiting() {
        return this.showKiting;
    }

    public void showKiting_$eq(boolean x$1) {
        this.showKiting = x$1;
    }

    public boolean showForces() {
        return this.showForces;
    }

    public void showForces_$eq(boolean x$1) {
        this.showForces = x$1;
    }

    public boolean showDesire() {
        return this.showDesire;
    }

    public void showDesire_$eq(boolean x$1) {
        this.showDesire = x$1;
    }

    public boolean showExplosions() {
        return this.showExplosions;
    }

    public void showExplosions_$eq(boolean x$1) {
        this.showExplosions = x$1;
    }

    @Override
    public void renderMap() {
        With$.MODULE$.agents().all().foreach(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Agent agent) {
                ShowUnitsFriendly$.MODULE$.renderUnitState(agent);
            }
        });
    }

    public void renderUnitState(Agent agent) {
        if (With$.MODULE$.viewport().contains(agent.unit().pixelCenter())) {
            if (agent.unit().unitClass().orderable()) {
                if (agent.unit().transport().isDefined()) {
                    return;
                }
                if (this.showClient()) {
                    agent.lastClient().foreach(new Serializable(agent){
                        public static final long serialVersionUID = 0L;
                        private final Agent agent$1;

                        public final void apply(Plan plan) {
                            DrawMap$.MODULE$.label(plan.toString(), this.agent$1.unit().pixelCenter().add(0, -21), false, DrawMap$.MODULE$.label$default$4(), DrawMap$.MODULE$.label$default$5(), DrawMap$.MODULE$.label$default$6());
                        }
                        {
                            this.agent$1 = agent$1;
                        }
                    });
                }
                if (this.showAction()) {
                    DrawMap$.MODULE$.label(agent.lastAction().map(new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Action x$1) {
                            return x$1.name();
                        }
                    }).getOrElse(new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    }), agent.unit().pixelCenter().add(0, -14), false, DrawMap$.MODULE$.label$default$4(), DrawMap$.MODULE$.label$default$5(), DrawMap$.MODULE$.label$default$6());
                }
                if (this.showCommand()) {
                    DrawMap$.MODULE$.label(agent.unit().command().map(new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(UnitCommand x$2) {
                            return x$2.getUnitCommandType().toString();
                        }
                    }).getOrElse(new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    }), agent.unit().pixelCenter().add(0, -7), false, DrawMap$.MODULE$.label$default$4(), DrawMap$.MODULE$.label$default$5(), DrawMap$.MODULE$.label$default$6());
                }
                if (this.showOrder()) {
                    DrawMap$.MODULE$.label(agent.unit().order().toString(), agent.unit().pixelCenter().add(0, 0), false, DrawMap$.MODULE$.label$default$4(), DrawMap$.MODULE$.label$default$5(), DrawMap$.MODULE$.label$default$6());
                }
                if (this.showTargets()) {
                    Option<Pixel> targetPosition;
                    Option<UnitInfo> targetUnit = agent.unit().target().orElse(new Serializable(agent){
                        public static final long serialVersionUID = 0L;
                        private final Agent agent$1;

                        public final Option<UnitInfo> apply() {
                            return this.agent$1.unit().orderTarget();
                        }
                        {
                            this.agent$1 = agent$1;
                        }
                    });
                    if (targetUnit.nonEmpty()) {
                        DrawMap$.MODULE$.line(agent.unit().pixelCenter(), ((UnitProxy)targetUnit.get()).pixelCenter(), agent.unit().player().colorNeon());
                    }
                    if ((targetPosition = agent.unit().targetPixel().orElse(new Serializable(agent){
                        public static final long serialVersionUID = 0L;
                        private final Agent agent$1;

                        public final Option<Pixel> apply() {
                            return this.agent$1.unit().orderTargetPixel();
                        }
                        {
                            this.agent$1 = agent$1;
                        }
                    })).nonEmpty() && agent.unit().target().isEmpty()) {
                        DrawMap$.MODULE$.arrow(agent.unit().pixelCenter(), targetPosition.get(), agent.unit().player().colorDark());
                    }
                    if (agent.movingTo().isDefined()) {
                        DrawMap$.MODULE$.arrow(agent.unit().pixelCenter(), agent.movingTo().get(), Colors$.MODULE$.MediumGray());
                    }
                    if (agent.toAttack().isDefined()) {
                        DrawMap$.MODULE$.arrow(agent.unit().pixelCenter(), ((UnitProxy)agent.toAttack().get()).pixelCenter(), Colors$.MODULE$.BrightRed());
                    }
                    if (agent.toGather().isDefined()) {
                        DrawMap$.MODULE$.arrow(agent.unit().pixelCenter(), ((UnitProxy)agent.toGather().get()).pixelCenter(), Colors$.MODULE$.DarkGreen());
                    }
                }
                if (this.showFormation() && agent.toForm().isDefined()) {
                    DrawMap$.MODULE$.circle(agent.toForm().get(), (int)agent.unit().unitClass().radialHypotenuse(), Colors$.MODULE$.MediumTeal(), DrawMap$.MODULE$.circle$default$4());
                }
                if (this.showKiting()) {
                    agent.pathsAll().foreach(new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final void apply(PixelRay ray) {
                            Predef$.MODULE$.refArrayOps((Object[])ray.tilesIntersected()).foreach(new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final void apply(Tile tile) {
                                    DrawMap$.MODULE$.box(tile.topLeftPixel().add(1, 1), tile.bottomRightPixel().subtract(1, 1), BoxesRunTime.unboxToBoolean(With$.MODULE$.grids().walkable().get(tile)) ? Colors$.MODULE$.BrightBlue() : Colors$.MODULE$.BrightRed(), DrawMap$.MODULE$.box$default$4());
                                }
                            });
                        }
                    });
                    agent.pathsAll().foreach(new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final void apply(PixelRay ray) {
                            DrawMap$.MODULE$.line(ray.from(), ray.to(), Colors$.MODULE$.MediumGray());
                        }
                    });
                    agent.pathsTruncated().foreach(new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final void apply(PixelRay ray) {
                            DrawMap$.MODULE$.line(ray.from(), ray.to(), Colors$.MODULE$.MediumGreen());
                        }
                    });
                    agent.pathsAcceptable().foreach(new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final void apply(PixelRay ray) {
                            DrawMap$.MODULE$.line(ray.from(), ray.to(), Colors$.MODULE$.BrightGreen());
                        }
                    });
                    agent.pathAccepted().foreach(new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final void apply(PixelRay ray) {
                            DrawMap$.MODULE$.line(ray.from(), ray.to(), Colors$.MODULE$.NeonGreen());
                            DrawMap$.MODULE$.circle(ray.to(), 4, Colors$.MODULE$.NeonGreen(), true);
                        }
                    });
                }
                if (this.showForces()) {
                    double length2 = 96.0;
                    double maxForce = BoxesRunTime.unboxToDouble(ByOption$.MODULE$.max(agent.forces().values().map(new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final double apply(Force x$3) {
                            return x$3.lengthSlow();
                        }
                    }, Iterable$.MODULE$.canBuildFrom()), Ordering$Double$.MODULE$).getOrElse(new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final double apply() {
                            return this.apply$mcD$sp();
                        }

                        public double apply$mcD$sp() {
                            return 0.0;
                        }
                    }));
                    if (maxForce > 0.0) {
                        agent.forces().foreach(new Serializable(agent, length2, maxForce){
                            public static final long serialVersionUID = 0L;
                            private final Agent agent$1;
                            private final double length$1;
                            private final double maxForce$1;

                            public final void apply(Tuple2<Color, Force> pair) {
                                Force force = pair._2();
                                Force forceNormalized = force.normalize(this.length$1 * force.lengthSlow() / this.maxForce$1);
                                DrawMap$.MODULE$.arrow(this.agent$1.unit().pixelCenter(), this.agent$1.unit().pixelCenter().add((int)forceNormalized.x(), (int)forceNormalized.y()), pair._1());
                            }
                            {
                                this.agent$1 = agent$1;
                                this.length$1 = length$1;
                                this.maxForce$1 = maxForce$1;
                            }
                        });
                        if (agent.movingTo().isDefined()) {
                            DrawMap$.MODULE$.arrow(agent.unit().pixelCenter(), agent.movingTo().get(), ForceColors$.MODULE$.sum());
                        }
                    }
                }
                if (this.showDesire()) {
                    Color color = agent.shouldEngage() ? Colors$.MODULE$.NeonGreen() : Colors$.MODULE$.NeonRed();
                    DrawMap$.MODULE$.circle(agent.unit().pixelCenter(), 8, color, DrawMap$.MODULE$.circle$default$4());
                }
                if (this.showExplosions()) {
                    agent.explosions().foreach(new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final void apply(Explosion explosion) {
                            DrawMap$.MODULE$.circle(explosion.pixelCenter(), (int)explosion.safetyRadius(), Colors$.MODULE$.NeonYellow(), DrawMap$.MODULE$.circle$default$4());
                        }
                    });
                }
                return;
            }
            return;
        }
    }

    private ShowUnitsFriendly$() {
        MODULE$ = this;
        this.showClient = true;
        this.showAction = true;
        this.showCommand = false;
        this.showOrder = false;
        this.showTargets = true;
        this.showFormation = true;
        this.showKiting = false;
        this.showForces = true;
        this.showDesire = true;
        this.showExplosions = true;
    }
}

