/*
 * Decompiled with CFR 0.152.
 */
package Debugging.Visualizations.Views.Micro;

import Debugging.Visualizations.Colors$;
import Debugging.Visualizations.Rendering.DrawMap$;
import Debugging.Visualizations.Views.View;
import Lifecycle.With$;
import Mathematics.Points.Pixel;
import ProxyBwapi.Races.Protoss$;
import ProxyBwapi.UnitClass.UnitClass;
import ProxyBwapi.UnitInfo.UnitInfo;
import bwapi.Color;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class ShowUnitsAll$
extends View {
    public static final ShowUnitsAll$ MODULE$;
    private boolean showHitPoints;
    private boolean showResources;
    private boolean showViolence;
    private boolean showBattleIgnorance;

    static {
        new ShowUnitsAll$();
    }

    public boolean showHitPoints() {
        return this.showHitPoints;
    }

    public void showHitPoints_$eq(boolean x$1) {
        this.showHitPoints = x$1;
    }

    public boolean showResources() {
        return this.showResources;
    }

    public void showResources_$eq(boolean x$1) {
        this.showResources = x$1;
    }

    public boolean showViolence() {
        return this.showViolence;
    }

    public void showViolence_$eq(boolean x$1) {
        this.showViolence = x$1;
    }

    public boolean showBattleIgnorance() {
        return this.showBattleIgnorance;
    }

    public void showBattleIgnorance_$eq(boolean x$1) {
        this.showBattleIgnorance = x$1;
    }

    @Override
    public void renderMap() {
        With$.MODULE$.units().all().foreach(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(UnitInfo unit) {
                ShowUnitsAll$.MODULE$.renderUnit(unit);
            }
        });
    }

    public void renderUnit(UnitInfo unit) {
        if (With$.MODULE$.viewport().contains(unit.pixelCenter())) {
            Color color = unit.color();
            if (this.showHitPoints()) {
                this.showHitPointsAndCooldown(unit);
            }
            if (this.showViolence()) {
                if (unit.isBeingViolent()) {
                    DrawMap$.MODULE$.circle(new Pixel(unit.pixelCenter().x(), unit.top() - 7), 5, unit.player().colorMedium(), true);
                    DrawMap$.MODULE$.text(new Pixel(unit.pixelCenter().x() - 2, unit.top() - 12), "!!");
                }
                if (unit.is(Predef$.MODULE$.wrapRefArray((Object[])new UnitClass[]{Protoss$.MODULE$.Scarab()}))) {
                    unit.target().foreach(new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final void apply(UnitInfo scarabTarget) {
                            package$.MODULE$.Range().apply(1, 6).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(this, scarabTarget){
                                public static final long serialVersionUID = 0L;
                                private final UnitInfo scarabTarget$1;

                                public final void apply(int r) {
                                    this.apply$mcVI$sp(r);
                                }

                                public void apply$mcVI$sp(int r) {
                                    DrawMap$.MODULE$.circle(this.scarabTarget$1.pixelCenter(), 4 * r, DrawMap$.MODULE$.circle$default$3(), DrawMap$.MODULE$.circle$default$4());
                                }
                                {
                                    this.scarabTarget$1 = scarabTarget$1;
                                }
                            }));
                        }
                    });
                }
            }
            if (this.showResources()) {
                if (unit.initialResources() > 0) {
                    DrawMap$.MODULE$.label(new StringBuilder().append(unit.resourcesLeft()).append((Object)"/").append(BoxesRunTime.boxToInteger(unit.initialResources())).toString(), unit.pixelCenter().add(0, With$.MODULE$.visualization().lineHeightSmall()), true, color, DrawMap$.MODULE$.label$default$5(), DrawMap$.MODULE$.label$default$6());
                }
                if (unit.isMineralBlocker()) {
                    DrawMap$.MODULE$.label("(Blocker)", unit.pixelCenter().add(0, 2 * With$.MODULE$.visualization().lineHeightSmall()), true, color, DrawMap$.MODULE$.label$default$5(), DrawMap$.MODULE$.label$default$6());
                }
            }
            if (this.showBattleIgnorance() && unit.battle().isEmpty()) {
                DrawMap$.MODULE$.circle(unit.pixelCenter(), 5, Color.Black, true);
            }
            return;
        }
    }

    private void showHitPointsAndCooldown(UnitInfo unit) {
        if (unit.invincible()) {
            return;
        }
        if (unit.possiblyStillThere()) {
            int width = Math.min(48, Math.max(18, (unit.unitClass().maxTotalHealth() + unit.defensiveMatrixPoints()) / 5));
            int marginTopHp = 3;
            int denominator = unit.unitClass().maxTotalHealth() + (unit.defensiveMatrixPoints() > 0 ? width * 250 : 0);
            if (denominator == 0) {
                return;
            }
            int widthHpMax = width * unit.unitClass().maxHitPoints() / denominator;
            int widthShMax = width * unit.unitClass().maxShields() / denominator;
            int widthDmMax = unit.defensiveMatrixPoints() > 0 ? width * 250 / denominator : 0;
            int widthHpNow = width * unit.hitPoints() / denominator;
            int widthShNow = width * unit.shieldPoints() / denominator;
            int widthDmNow = width * unit.defensiveMatrixPoints() / denominator;
            int widthEnergyNow = unit.energyMax() == 0 ? 0 : Math.min(width, width * unit.energy() / unit.energyMax());
            int widthCooldownButton = 3;
            int widthCooldown = width - 2 * widthCooldownButton - 2;
            int widthCooldownNow = widthCooldown * Math.max(unit.cooldownLeft(), unit.spellCooldownLeft()) / Math.max(1, unit.cooldownMaxAirGround());
            int yStartHp = unit.pixelCenter().y() + unit.unitClass().height() / 2 - marginTopHp;
            int yEndHp = yStartHp + 4;
            int yStartEnergy = yEndHp + 2;
            int yEndEnergy = yStartEnergy + 4;
            int yStartCooldown = unit.energyMax() > 0 ? yEndEnergy + 3 : yEndHp + 3;
            int yEndCooldown = yStartCooldown + 3;
            int xStart = unit.pixelCenter().x() - width / 2;
            int xStartSh = xStart + widthHpMax;
            int xStartDm = xStartSh + widthShMax;
            int xStartCooldown = xStart;
            int xStartCooldownButton0 = xStart + widthCooldown + 1;
            int xStartCooldownButton1 = xStart + widthCooldown + 2 + widthCooldownButton;
            Color colorHp = Colors$.MODULE$.NeonGreen();
            Color colorSh = Colors$.MODULE$.NeonBlue();
            Color colorDm = Colors$.MODULE$.NeonViolet();
            DrawMap$.MODULE$.box(new Pixel(xStart - 1, yStartHp - 1), new Pixel(xStart + width + 2, yEndHp + 1), Color.Black, true);
            DrawMap$.MODULE$.box(new Pixel(xStartDm, yStartHp), new Pixel(xStartDm + widthDmMax, yEndHp), colorDm, false);
            DrawMap$.MODULE$.box(new Pixel(xStartSh, yStartHp), new Pixel(xStartSh + widthShMax, yEndHp), colorSh, false);
            DrawMap$.MODULE$.box(new Pixel(xStart, yStartHp), new Pixel(xStart + widthHpMax, yEndHp), colorHp, false);
            DrawMap$.MODULE$.box(new Pixel(xStartDm, yStartHp), new Pixel(xStartDm + widthDmNow, yEndHp), colorDm, true);
            DrawMap$.MODULE$.box(new Pixel(xStartSh, yStartHp), new Pixel(xStartSh + widthShNow, yEndHp), colorSh, true);
            DrawMap$.MODULE$.box(new Pixel(xStart, yStartHp), new Pixel(xStart + widthHpNow, yEndHp), colorHp, true);
            int healthBarEvery = Math.max(3, width * 25 / (unit.unitClass().maxTotalHealth() + unit.defensiveMatrixPoints()));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), width).by(healthBarEvery).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(yStartHp, yEndHp, xStart){
                public static final long serialVersionUID = 0L;
                private final int yStartHp$1;
                private final int yEndHp$1;
                private final int xStart$1;

                public final void apply(int healthX) {
                    this.apply$mcVI$sp(healthX);
                }

                public void apply$mcVI$sp(int healthX) {
                    int x = this.xStart$1 + healthX - 1;
                    DrawMap$.MODULE$.line(new Pixel(x, this.yStartHp$1), new Pixel(x, this.yEndHp$1), Color.Black);
                }
                {
                    this.yStartHp$1 = yStartHp$1;
                    this.yEndHp$1 = yEndHp$1;
                    this.xStart$1 = xStart$1;
                }
            }));
            if (unit.energyMax() > 0) {
                DrawMap$.MODULE$.box(new Pixel(xStart - 1, yStartEnergy - 1), new Pixel(xStart + width + 2, yEndEnergy + 1), Color.Black, true);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(25), unit.energyMax()).by(25).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(unit, width, yStartEnergy, yEndEnergy, xStart){
                    public static final long serialVersionUID = 0L;
                    private final UnitInfo unit$1;
                    private final int width$1;
                    private final int yStartEnergy$1;
                    private final int yEndEnergy$1;
                    private final int xStart$1;

                    public final void apply(int energy) {
                        this.apply$mcVI$sp(energy);
                    }

                    public void apply$mcVI$sp(int energy) {
                        int x = this.xStart$1 + this.width$1 * energy / this.unit$1.energyMax();
                        DrawMap$.MODULE$.line(new Pixel(x, this.yStartEnergy$1), new Pixel(x, this.yEndEnergy$1), Color.Black);
                    }
                    {
                        this.unit$1 = unit$1;
                        this.width$1 = width$1;
                        this.yStartEnergy$1 = yStartEnergy$1;
                        this.yEndEnergy$1 = yEndEnergy$1;
                        this.xStart$1 = xStart$1;
                    }
                }));
                DrawMap$.MODULE$.box(new Pixel(xStart, yStartEnergy), new Pixel(xStart + widthEnergyNow, yEndEnergy), Colors$.MODULE$.BrightTeal(), true);
            }
            if (widthCooldownNow > 0) {
                DrawMap$.MODULE$.box(new Pixel(xStart - 1, yStartCooldown - 1), new Pixel(xStart + width + 2, yEndCooldown + 1), Color.Black, true);
                if (unit.cooldownLeft() > 0) {
                    DrawMap$.MODULE$.box(new Pixel(xStartCooldown, yStartCooldown), new Pixel(xStartCooldown + widthCooldownNow, yEndCooldown), unit.color(), true);
                }
                if (unit.attackStarting()) {
                    DrawMap$.MODULE$.box(new Pixel(xStartCooldownButton1, yStartCooldown), new Pixel(xStartCooldownButton1 + widthCooldownButton, yEndCooldown), Colors$.MODULE$.BrightGreen(), true);
                }
                if (unit.attackAnimationHappening()) {
                    DrawMap$.MODULE$.box(new Pixel(xStartCooldownButton0, yStartCooldown), new Pixel(xStartCooldownButton0 + widthCooldownButton, yEndCooldown), Colors$.MODULE$.BrightOrange(), true);
                }
            }
            if (unit.wounded()) {
                DrawMap$.MODULE$.box(new Pixel(xStart - 3, yStartHp - 3), new Pixel(xStart + width + 4, yEndHp + 3), unit.color(), false);
                DrawMap$.MODULE$.label(":(", new Pixel(unit.pixelCenter().x(), unit.top() + 4), true, unit.color(), DrawMap$.MODULE$.label$default$5(), DrawMap$.MODULE$.label$default$6());
            }
            return;
        }
    }

    private ShowUnitsAll$() {
        MODULE$ = this;
        this.showHitPoints = true;
        this.showResources = true;
        this.showViolence = true;
        this.showBattleIgnorance = true;
    }
}

