/*
 * Decompiled with CFR 0.152.
 */
package Debugging.Visualizations.Views.Battles;

import Debugging.Visualizations.Colors$;
import Debugging.Visualizations.Rendering.DrawMap$;
import Debugging.Visualizations.Views.View;
import Information.Battles.Estimations.Estimation;
import Information.Battles.Types.Battle;
import Lifecycle.With$;
import Mathematics.Points.Pixel;
import Planning.Yolo$;
import ProxyBwapi.UnitInfo.FriendlyUnitInfo;
import ProxyBwapi.UnitInfo.UnitInfo;
import bwapi.Color;
import bwapi.Text.Size.Enum;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$Double$;
import scala.math.Ordering$Int$;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class ShowBattles$
extends View {
    public static final ShowBattles$ MODULE$;
    private final Pixel tableHeader0;
    private final Pixel tableHeader1;
    private final Pixel tableStart0;
    private final Pixel tableStart1;
    private final Pixel army0;
    private final Pixel army1;
    private final Pixel army2;
    private final Pixel yolo;
    private final Pixel tacticsRanks;

    static {
        new ShowBattles$();
    }

    private Pixel tableHeader0() {
        return this.tableHeader0;
    }

    private Pixel tableHeader1() {
        return this.tableHeader1;
    }

    private Pixel tableStart0() {
        return this.tableStart0;
    }

    private Pixel tableStart1() {
        return this.tableStart1;
    }

    private Pixel army0() {
        return this.army0;
    }

    private Pixel army1() {
        return this.army1;
    }

    private Pixel army2() {
        return this.army2;
    }

    private Pixel yolo() {
        return this.yolo;
    }

    private Pixel tacticsRanks() {
        return this.tacticsRanks;
    }

    @Override
    public void renderScreen() {
        With$.MODULE$.game().drawTextScreen(this.army0().bwapi(), "Offense:");
        With$.MODULE$.game().drawTextScreen(this.army1().bwapi(), new StringBuilder().append((Object)"+").append(BoxesRunTime.boxToInteger((int)With$.MODULE$.battles().global().estimationAbstractOffense().costToEnemy())).toString());
        With$.MODULE$.game().drawTextScreen(this.army2().bwapi(), new StringBuilder().append((Object)"-").append(BoxesRunTime.boxToInteger((int)With$.MODULE$.battles().global().estimationAbstractOffense().costToUs())).toString());
        With$.MODULE$.game().drawTextScreen(this.army0().add(0, 13).bwapi(), new StringBuilder().append((Object)"Frames since estimation: ").append(BoxesRunTime.boxToInteger(With$.MODULE$.framesSince(With$.MODULE$.battles().clustering().lastClusterCompletion()))).toString());
        this.localBattle().foreach(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Battle battle) {
                ShowBattles$.MODULE$.Debugging$Visualizations$Views$Battles$ShowBattles$$drawEstimationReport(battle.estimationSimulationAttack());
            }
        });
        if (Yolo$.MODULE$.active() && With$.MODULE$.frame() / 24 % 2 == 0) {
            With$.MODULE$.game().drawTextScreen(this.yolo().bwapi(), "YOLO");
        }
    }

    @Override
    public void renderMap() {
        this.localBattle().foreach(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Battle battle) {
                ShowBattles$.MODULE$.Debugging$Visualizations$Views$Battles$ShowBattles$$drawBattleMap(battle, battle.estimationSimulationAttack());
            }
        });
    }

    public Option<Battle> localBattle() {
        Set selectedUnits = (Set)With$.MODULE$.units().ours().filter((Function1<FriendlyUnitInfo, Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FriendlyUnitInfo x$1) {
                return x$1.selected();
            }
        }));
        Vector<Battle> localBattles = selectedUnits.nonEmpty() ? (scala.collection.immutable.Iterable)selectedUnits.flatMap(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<Battle> apply(FriendlyUnitInfo x$2) {
                return Option$.MODULE$.option2Iterable(x$2.battle());
            }
        }, Set$.MODULE$.canBuildFrom()) : With$.MODULE$.battles().local();
        return localBattles.isEmpty() ? None$.MODULE$ : new Some<Battle>(localBattles.minBy(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Battle battle) {
                return battle.focus().pixelDistanceSquared(With$.MODULE$.viewport().center());
            }
        }, Ordering$Int$.MODULE$));
    }

    public void Debugging$Visualizations$Views$Battles$ShowBattles$$drawBattleMap(Battle battle, Estimation estimation) {
        Color ourColor = With$.MODULE$.self().colorDark();
        Color enemyColor = With$.MODULE$.enemy().colorDark();
        Color neutralColor = Colors$.MODULE$.White();
        Color winnerStrengthColor = estimation.costToEnemy() >= estimation.costToUs() ? ourColor : enemyColor;
        DrawMap$.MODULE$.circle(battle.focus(), 8, neutralColor, DrawMap$.MODULE$.circle$default$4());
        DrawMap$.MODULE$.circle(battle.us().vanguard(), 8, ourColor, DrawMap$.MODULE$.circle$default$4());
        DrawMap$.MODULE$.circle(battle.enemy().vanguard(), 8, enemyColor, DrawMap$.MODULE$.circle$default$4());
        DrawMap$.MODULE$.line(battle.focus(), battle.us().vanguard(), ourColor);
        DrawMap$.MODULE$.line(battle.focus(), battle.enemy().vanguard(), enemyColor);
        With$.MODULE$.game().drawCircleMap(battle.focus().bwapi(), (int)BoxesRunTime.unboxToDouble(((TraversableOnce)((TraversableLike)battle.us().units().$plus$plus(battle.enemy().units(), Vector$.MODULE$.canBuildFrom())).map(new Serializable(battle){
            public static final long serialVersionUID = 0L;
            private final Battle battle$1;

            public final double apply(UnitInfo x$3) {
                return x$3.pixelDistanceFast(this.battle$1.focus());
            }
            {
                this.battle$1 = battle$1;
            }
        }, Vector$.MODULE$.canBuildFrom())).max(Ordering$Double$.MODULE$)), neutralColor);
        DrawMap$.MODULE$.labelBox((Iterable)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)estimation.netValue())).toString()})), battle.focus().add(24, 0), true, winnerStrengthColor, DrawMap$.MODULE$.labelBox$default$5(), DrawMap$.MODULE$.labelBox$default$6());
    }

    public void Debugging$Visualizations$Views$Battles$ShowBattles$$drawEstimationReport(Estimation estimation) {
        With$.MODULE$.game().setTextSize(Enum.Large);
        With$.MODULE$.game().drawTextScreen(this.tableHeader0().bwapi(), With$.MODULE$.self().name());
        With$.MODULE$.game().drawTextScreen(this.tableHeader1().bwapi(), With$.MODULE$.enemy().name());
        With$.MODULE$.game().drawTextScreen(this.tableStart0().bwapi(), new StringBuilder().append((Object)"+").append(BoxesRunTime.boxToInteger((int)estimation.costToEnemy())).toString());
        With$.MODULE$.game().drawTextScreen(this.tableStart1().bwapi(), new StringBuilder().append((Object)"-").append(BoxesRunTime.boxToInteger((int)estimation.costToUs())).toString());
        With$.MODULE$.game().setTextSize(Enum.Small);
    }

    private ShowBattles$() {
        MODULE$ = this;
        this.tableHeader0 = new Pixel(220, 320);
        this.tableHeader1 = this.tableHeader0().add(125, 0);
        this.tableStart0 = this.tableHeader0().add(0, 25);
        this.tableStart1 = this.tableHeader1().add(0, 25);
        this.army0 = new Pixel(438, 18);
        this.army1 = new Pixel(521, 18);
        this.army2 = new Pixel(589, 18);
        this.yolo = new Pixel(310, 230);
        this.tacticsRanks = new Pixel(235, 18);
    }
}

