/*
 * Decompiled with CFR 0.152.
 */
package Debugging.Visualizations.Views.Battles;

import Debugging.Visualizations.Colors$;
import Debugging.Visualizations.Rendering.DrawMap$;
import Debugging.Visualizations.Rendering.DrawScreen$;
import Debugging.Visualizations.Views.Battles.ShowBattles$;
import Debugging.Visualizations.Views.View;
import Information.Battles.Estimations.Estimation;
import Information.Battles.Estimations.ReportCard;
import Information.Battles.Estimations.Simulation.BattleSimulation;
import Information.Battles.Estimations.Simulation.Simulacrum;
import Information.Battles.Types.Battle;
import Lifecycle.With$;
import Mathematics.Points.Pixel;
import ProxyBwapi.UnitClass.UnitClass;
import ProxyBwapi.UnitInfo.UnitInfo;
import bwapi.Color;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.MapLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Ordering;
import scala.math.Ordering$Int$;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class ShowBattleDetails$
extends View {
    public static final ShowBattleDetails$ MODULE$;

    static {
        new ShowBattleDetails$();
    }

    @Override
    public void renderScreen() {
        ShowBattles$.MODULE$.localBattle().foreach(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Battle battle) {
                ShowBattleDetails$.MODULE$.renderBattleScreen(battle, battle.estimationSimulationAttack());
            }
        });
    }

    public void renderBattleScreen(Battle battle, Estimation estimation) {
        int x = 5;
        int y = 7 * With$.MODULE$.visualization().lineHeightSmall();
        Vector table2 = (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{(Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", With$.MODULE$.self().name(), With$.MODULE$.enemy().name()})), (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", estimation.weSurvive() ? "Survives" : "", estimation.enemySurvives() ? "Survives" : ""})), (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Seconds", String.valueOf(BoxesRunTime.boxToInteger(estimation.frames() / 24)), ""})), (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Value", String.valueOf(BoxesRunTime.boxToInteger((int)estimation.costToEnemy())), String.valueOf(BoxesRunTime.boxToInteger((int)estimation.costToUs()))})), (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Participants", String.valueOf(BoxesRunTime.boxToDouble(estimation.totalUnitsUs())), String.valueOf(BoxesRunTime.boxToDouble(estimation.totalUnitsEnemy()))})), (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Survivors", this.survivorPercentage(estimation.deathsUs(), estimation.totalUnitsUs()), this.survivorPercentage(estimation.deathsEnemy(), estimation.totalUnitsEnemy())})), (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Gains", new StringOps(Predef$.MODULE$.augmentString("%1.2f")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(battle.analysis().attackGains())}))})), (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Losses", new StringOps(Predef$.MODULE$.augmentString("%1.2f")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(battle.analysis().attackLosses())}))})), (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Desire", new StringOps(Predef$.MODULE$.augmentString("%1.2f")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(battle.desire())}))}))}));
        DrawScreen$.MODULE$.table(x, y, table2);
        int y2 = y + (table2.length() + 4) * With$.MODULE$.visualization().lineHeightSmall();
        DrawScreen$.MODULE$.table(5, y2, (Iterable)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{(Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "Participants"})), (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{With$.MODULE$.self().name(), this.describeTeam(battle.us().units())})), (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{With$.MODULE$.enemy().name(), this.describeTeam(battle.enemy().units())})), (Vector)package$.MODULE$.Vector().apply(Nil$.MODULE$), (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "Survivors"})), (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{With$.MODULE$.self().name(), this.describeTeam(((MapLike)estimation.reportCards().filter((Function1)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<UnitInfo, ReportCard> x$1) {
                return x$1._1().isFriendly();
            }
        }))).filterNot(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<UnitInfo, ReportCard> x$2) {
                return x$2._2().dead();
            }
        }).keys())})), (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{With$.MODULE$.enemy().name(), this.describeTeam(((MapLike)estimation.reportCards().filter((Function1)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<UnitInfo, ReportCard> x$3) {
                return x$3._1().isEnemy();
            }
        }))).filterNot(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<UnitInfo, ReportCard> x$4) {
                return x$4._2().dead();
            }
        }).keys())})), (Vector)package$.MODULE$.Vector().apply(Nil$.MODULE$), (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "Deaths"})), (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{With$.MODULE$.self().name(), this.describeTeam(((MapLike)((TraversableLike)estimation.reportCards().filter((Function1)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<UnitInfo, ReportCard> x$5) {
                return x$5._1().isFriendly();
            }
        }))).filter(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<UnitInfo, ReportCard> x$6) {
                return x$6._2().dead();
            }
        })).keys())})), (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{With$.MODULE$.enemy().name(), this.describeTeam(((MapLike)((TraversableLike)estimation.reportCards().filter((Function1)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<UnitInfo, ReportCard> x$7) {
                return x$7._1().isEnemy();
            }
        }))).filter(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<UnitInfo, ReportCard> x$8) {
                return x$8._2().dead();
            }
        })).keys())}))})));
        int x2 = 200;
        int valueUsInitial = BoxesRunTime.unboxToInt(((TraversableOnce)battle.us().units().map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(UnitInfo x$9) {
                return x$9.subjectiveValue();
            }
        }, Vector$.MODULE$.canBuildFrom())).sum(Numeric$IntIsIntegral$.MODULE$));
        int valueEnemyInitial = BoxesRunTime.unboxToInt(((TraversableOnce)battle.enemy().units().map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(UnitInfo x$10) {
                return x$10.subjectiveValue();
            }
        }, Vector$.MODULE$.canBuildFrom())).sum(Numeric$IntIsIntegral$.MODULE$));
        int valueUsLost = (int)estimation.costToUs();
        int valueEnemyLost = (int)estimation.costToEnemy();
        int valueUsKept = Math.max(0, valueUsInitial - valueUsLost);
        int valueEnemyKept = Math.max(0, valueEnemyInitial - valueEnemyLost);
        int baseWidth = 200;
        int denominator = BoxesRunTime.unboxToInt(Predef$.MODULE$.intArrayOps(new int[]{1, valueUsInitial, valueEnemyInitial}).max(Ordering$Int$.MODULE$));
        int dxUsInitial = baseWidth * valueUsInitial / denominator;
        int dxEnemyInitial = baseWidth * valueEnemyInitial / denominator;
        int dxUsLost = baseWidth * valueUsLost / denominator;
        int dxEnemyLost = baseWidth * valueEnemyLost / denominator;
        int dxUsKept = baseWidth * valueUsKept / denominator;
        int dxEnemyKept = baseWidth * valueEnemyKept / denominator;
        int nextY = y;
        int boxHeight = With$.MODULE$.visualization().lineHeightSmall() + 4;
        int margin = 2;
        String nameUs = With$.MODULE$.self().name();
        String nameEnemy = With$.MODULE$.enemy().name();
        Color colorUs = With$.MODULE$.self().colorMedium();
        Color colorEnemy = With$.MODULE$.enemy().colorMedium();
        this.drawBar(x2, nextY, dxUsInitial, boxHeight, colorUs, new StringBuilder().append((Object)"Start (").append((Object)nameUs).append((Object)")").toString());
        this.drawBar(x2, nextY += boxHeight, dxEnemyInitial, boxHeight, colorEnemy, new StringBuilder().append((Object)"Start (").append((Object)nameEnemy).append((Object)")").toString());
        this.drawBar(x2, nextY += boxHeight + margin, dxUsKept, boxHeight, colorUs, new StringBuilder().append((Object)"Kept (").append((Object)nameUs).append((Object)")").toString());
        this.drawBar(x2, nextY += boxHeight, dxEnemyKept, boxHeight, colorEnemy, new StringBuilder().append((Object)"Kept (").append((Object)nameEnemy).append((Object)")").toString());
        this.drawBar(x2, nextY += boxHeight + margin, dxUsLost, boxHeight, colorUs, new StringBuilder().append((Object)"Lost (").append((Object)nameUs).append((Object)")").toString());
        this.drawBar(x2, nextY += boxHeight, dxEnemyLost, boxHeight, colorEnemy, new StringBuilder().append((Object)"Lost (").append((Object)nameEnemy).append((Object)")").toString());
        Vector scoreTable = (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{(Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attack secs", String.valueOf(BoxesRunTime.boxToInteger(battle.estimationSimulationAttack().frames() / 24))})), (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attack gain", String.valueOf(BoxesRunTime.boxToInteger((int)battle.estimationSimulationAttack().costToEnemy()))})), (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attack loss", String.valueOf(BoxesRunTime.boxToInteger((int)battle.estimationSimulationAttack().costToUs()))})), (Vector)package$.MODULE$.Vector().apply(Nil$.MODULE$), (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retreat secs", String.valueOf(BoxesRunTime.boxToInteger(battle.estimationSimulationRetreat().frames() / 24))})), (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retreat gain", String.valueOf(BoxesRunTime.boxToInteger((int)battle.estimationSimulationRetreat().costToEnemy()))})), (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retreat loss", String.valueOf(BoxesRunTime.boxToInteger((int)battle.estimationSimulationRetreat().costToUs()))})), (Vector)package$.MODULE$.Vector().apply(Nil$.MODULE$), (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Desire", String.valueOf(new StringOps(Predef$.MODULE$.augmentString("%1.1f")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(battle.desire())})))}))}));
        DrawScreen$.MODULE$.table(450, y, scoreTable);
    }

    public void drawBar(int x, int y, int dx, int dy, Color color, String label) {
        With$.MODULE$.game().drawBoxScreen(x, y, x + dx, y + dy, color, true);
        With$.MODULE$.game().drawTextScreen(x + 2, y + 1, label);
    }

    public String describeTeam(Iterable<UnitInfo> units) {
        return ((TraversableOnce)((TraversableLike)units.groupBy(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final UnitClass apply(UnitInfo x$11) {
                return x$11.unitClass();
            }
        }).toVector().sortBy((Function1)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<UnitClass, Iterable<UnitInfo>> x$12) {
                return -((TraversableOnce)x$12._2()).size();
            }
        }), (Ordering)Ordering$Int$.MODULE$)).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<UnitClass, Iterable<UnitInfo>> p) {
                return new StringBuilder().append(((TraversableOnce)p._2()).size()).append((Object)" ").append(p._1()).toString();
            }
        }, Vector$.MODULE$.canBuildFrom())).mkString(", ");
    }

    public String survivorPercentage(double deaths, double total2) {
        return new StringBuilder().append((int)((double)100 * (total2 - deaths) / total2)).append((Object)"%%").toString();
    }

    @Override
    public void renderMap() {
        ShowBattles$.MODULE$.localBattle().foreach(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Battle battle) {
                ShowBattleDetails$.MODULE$.renderBattleMap(battle);
            }
        });
    }

    public void renderBattleMap(Battle battle) {
        BattleSimulation simulation = battle.estimationSimulationAttack().simulation().get();
        simulation.simulacra().values().foreach(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Simulacrum sim) {
                ShowBattleDetails$.MODULE$.renderSimulacrumMap(sim);
            }
        });
    }

    public void renderSimulacrumMap(Simulacrum sim) {
        boolean attacking = sim.simulation().weAttack();
        Color color = attacking ? sim.unit().player().colorNeon() : sim.unit().player().colorMidnight();
        sim.moves().foreach(new Serializable(color){
            public static final long serialVersionUID = 0L;
            private final Color color$1;

            public final void apply(Tuple2<Pixel, Pixel> move) {
                DrawMap$.MODULE$.arrow(move._1(), move._2(), this.color$1);
            }
            {
                this.color$1 = color$1;
            }
        });
        if (sim.dead()) {
            DrawMap$.MODULE$.circle(sim.pixel(), 5, attacking ? Colors$.MODULE$.NeonOrange() : Colors$.MODULE$.MidnightOrange(), true);
        }
    }

    private ShowBattleDetails$() {
        MODULE$ = this;
    }
}

