/*
 * Decompiled with CFR 0.152.
 */
package Debugging.Visualizations.Rendering;

import Debugging.Visualizations.Colors$;
import Lifecycle.With$;
import Mathematics.Points.Pixel;
import Mathematics.Points.TileRectangle;
import bwapi.Color;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.TraversableOnce;
import scala.math.Ordering$Int$;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class DrawMap$ {
    public static final DrawMap$ MODULE$;

    static {
        new DrawMap$();
    }

    public void text(Pixel origin2, String text2) {
        if (this.irrelevant(origin2)) {
            return;
        }
        With$.MODULE$.game().drawTextMap(origin2.bwapi(), text2);
    }

    public void line(Pixel start, Pixel end, Color color) {
        if (this.irrelevant((Iterable)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new Pixel[]{start, end})))) {
            return;
        }
        With$.MODULE$.game().drawLineMap(start.bwapi(), end.bwapi(), color);
    }

    public Color line$default$3() {
        return Colors$.MODULE$.DefaultGray();
    }

    public void arrow(Pixel start, Pixel end, Color color) {
        if (this.irrelevant((Iterable)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new Pixel[]{start, end})))) {
            return;
        }
        this.line(start, end, color);
        double angleBack = end.radiansTo(start);
        double angleDiff = 0.3141592653589793;
        this.triangle(end, end.radiateRadians(angleBack + angleDiff, 6.0), end.radiateRadians(angleBack - angleDiff, 6.0), color, true);
    }

    public Color arrow$default$3() {
        return Colors$.MODULE$.DefaultGray();
    }

    public void box(Pixel start, Pixel end, Color color, boolean solid) {
        if (this.irrelevant((Iterable)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new Pixel[]{start, end})))) {
            return;
        }
        With$.MODULE$.game().drawBoxMap(start.bwapi(), end.bwapi(), color, solid);
    }

    public Color box$default$3() {
        return Colors$.MODULE$.DefaultGray();
    }

    public boolean box$default$4() {
        return false;
    }

    public void circle(Pixel center2, int radius, Color color, boolean solid) {
        if (this.irrelevant((Iterable)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new Pixel[]{center2, center2.add(radius, radius), center2.add(-radius, radius), center2.add(radius, -radius), center2.add(-radius, -radius)})))) {
            return;
        }
        With$.MODULE$.game().drawCircleMap(center2.bwapi(), radius, color, solid);
    }

    public Color circle$default$3() {
        return Colors$.MODULE$.DefaultGray();
    }

    public boolean circle$default$4() {
        return false;
    }

    public void triangle(Pixel position1, Pixel position2, Pixel position3, Color color, boolean solid) {
        if (this.irrelevant((Iterable)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new Pixel[]{position1, position2, position3})))) {
            return;
        }
        With$.MODULE$.game().drawTriangleMap(position1.bwapi(), position2.bwapi(), position3.bwapi(), color, solid);
    }

    public Color triangle$default$4() {
        return Colors$.MODULE$.DefaultGray();
    }

    public boolean triangle$default$5() {
        return false;
    }

    public void label(String text2, Pixel position, boolean drawBackground, Color backgroundColor, boolean drawBorder, Color borderColor) {
        if (this.irrelevant(position)) {
            return;
        }
        this.labelBox((Iterable)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{text2})), position, drawBackground, backgroundColor, drawBorder, borderColor);
    }

    public boolean label$default$3() {
        return false;
    }

    public Color label$default$4() {
        return Colors$.MODULE$.DefaultGray();
    }

    public boolean label$default$5() {
        return false;
    }

    public Color label$default$6() {
        return Colors$.MODULE$.DefaultGray();
    }

    public void labelBox(Iterable<String> textLines, Pixel position, boolean drawBackground, Color backgroundColor, boolean drawBorder, Color borderColor) {
        int estimatedTextWidth;
        if (this.irrelevant(position)) {
            return;
        }
        int horizontalMargin = 2;
        int boxWidth = estimatedTextWidth + ((estimatedTextWidth = 9 * BoxesRunTime.unboxToInt(((TraversableOnce)textLines.map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$1) {
                return x$1.length();
            }
        }, Iterable$.MODULE$.canBuildFrom())).max(Ordering$Int$.MODULE$)) / 2) > 0 ? 2 * horizontalMargin : 0);
        int boxHeight = 11 * textLines.size();
        int textX = position.x() - boxWidth / 2;
        int textY = position.y() - boxHeight / 2;
        int boxX = textX - horizontalMargin;
        int boxY = textY;
        if (drawBackground) {
            With$.MODULE$.game().drawBoxMap(boxX, boxY, boxX + boxWidth, boxY + boxHeight, backgroundColor, true);
        }
        if (drawBorder) {
            With$.MODULE$.game().drawBoxMap(boxX - 1, boxY - 1, boxX + boxWidth + 1, boxY + boxHeight + 1, borderColor, false);
        }
        With$.MODULE$.game().drawTextMap(textX, textY, textLines.mkString("\n"));
    }

    public boolean labelBox$default$3() {
        return false;
    }

    public Color labelBox$default$4() {
        return Colors$.MODULE$.DefaultGray();
    }

    public boolean labelBox$default$5() {
        return false;
    }

    public Color labelBox$default$6() {
        return Colors$.MODULE$.DefaultGray();
    }

    public void tileRectangle(TileRectangle rectangle, Color color) {
        if (this.irrelevant((Iterable)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new Pixel[]{rectangle.startPixel(), rectangle.endPixel()})))) {
            return;
        }
        With$.MODULE$.game().drawBoxMap(rectangle.startPixel().bwapi(), rectangle.endPixel().bwapi(), color);
    }

    public void polygonPixels(Iterable<Pixel> points2, Color color) {
        points2.reduce(new Serializable(color){
            public static final long serialVersionUID = 0L;
            private final Color color$1;

            public final Pixel apply(Pixel p1, Pixel p2) {
                DrawMap$.MODULE$.line(p1, p2, this.color$1);
                return p2;
            }
            {
                this.color$1 = color$1;
            }
        });
        this.line((Pixel)points2.head(), (Pixel)points2.last(), color);
    }

    public Color polygonPixels$default$2() {
        return Colors$.MODULE$.DefaultGray();
    }

    public boolean irrelevant(Iterable<Pixel> points2) {
        return points2.forall((Function1<Pixel, Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Pixel pixel) {
                return DrawMap$.MODULE$.irrelevant(pixel);
            }
        }));
    }

    public boolean irrelevant(Pixel pixel) {
        int buffer = 128;
        return !pixel.valid() || !With$.MODULE$.viewport().contains(pixel);
    }

    private DrawMap$() {
        MODULE$ = this;
    }
}

