/*
 * Decompiled with CFR 0.152.
 */
package javabot.operators;

import java.awt.Point;
import javabot.managers.BaseManager;
import javabot.model.Unit;
import javabot.types.UnitType;

public class Operators {
    public static int iterHatchery;
    public static int iterPool;
    public static int iterExtractor;
    public static int iterHydra;
    public static int iterLair;
    public static int iterQueenNest;
    public static int iterSpire;
    public static int iterHive;
    public static int iterGreatSpire;
    public static int iterEvolutionChamber;
    public static int iterDrones;
    public static int iterOverlords;
    public static int iterZerglings;
    public static int iterHydralisks;
    public static int iterQueens;
    public static int iterMutalisks;
    public static int iterGuardians;
    public static int iterDevourers;

    public static String stringFromType(int type) {
        if (type == UnitType.UnitTypes.Zerg_Larva.ordinal()) {
            return "Larva";
        }
        if (type == UnitType.UnitTypes.Zerg_Drone.ordinal()) {
            return "Drone";
        }
        if (type == UnitType.UnitTypes.Zerg_Overlord.ordinal()) {
            return "Overlord";
        }
        if (type == UnitType.UnitTypes.Zerg_Egg.ordinal()) {
            return "Egg";
        }
        if (type == UnitType.UnitTypes.Zerg_Zergling.ordinal()) {
            return "Zergling";
        }
        if (type == UnitType.UnitTypes.Zerg_Hydralisk.ordinal()) {
            return "Hydra";
        }
        if (type == UnitType.UnitTypes.Zerg_Queen.ordinal()) {
            return "Queen";
        }
        if (type == UnitType.UnitTypes.Zerg_Broodling.ordinal()) {
            return "Broodlg";
        }
        if (type == UnitType.UnitTypes.Zerg_Mutalisk.ordinal()) {
            return "Mutalisk";
        }
        if (type == UnitType.UnitTypes.Zerg_Guardian.ordinal()) {
            return "Guardian";
        }
        if (type == UnitType.UnitTypes.Zerg_Devourer.ordinal()) {
            return "Devourer";
        }
        if (type == UnitType.UnitTypes.Zerg_Hatchery.ordinal()) {
            return "Hatchery";
        }
        if (type == UnitType.UnitTypes.Zerg_Spawning_Pool.ordinal()) {
            return "Pool";
        }
        if (type == UnitType.UnitTypes.Zerg_Evolution_Chamber.ordinal()) {
            return "Evo Chamber";
        }
        if (type == UnitType.UnitTypes.Zerg_Extractor.ordinal()) {
            return "Extractor";
        }
        if (type == UnitType.UnitTypes.Zerg_Hydralisk_Den.ordinal()) {
            return "Hydra Den";
        }
        if (type == UnitType.UnitTypes.Zerg_Creep_Colony.ordinal()) {
            return "Crp Colony";
        }
        if (type == UnitType.UnitTypes.Zerg_Sunken_Colony.ordinal()) {
            return "Snk Colony";
        }
        if (type == UnitType.UnitTypes.Zerg_Spore_Colony.ordinal()) {
            return "Spo Colony";
        }
        if (type == UnitType.UnitTypes.Zerg_Lair.ordinal()) {
            return "Lair";
        }
        if (type == UnitType.UnitTypes.Zerg_Queens_Nest.ordinal()) {
            return "Q Nest";
        }
        if (type == UnitType.UnitTypes.Zerg_Spire.ordinal()) {
            return "Spire";
        }
        if (type == UnitType.UnitTypes.Zerg_Hive.ordinal()) {
            return "Hive";
        }
        if (type == UnitType.UnitTypes.Zerg_Greater_Spire.ordinal()) {
            return "G Spire";
        }
        return "";
    }

    public static int unitTypeFromIter(int i) {
        if (i == 0) {
            return UnitType.UnitTypes.Zerg_Larva.ordinal();
        }
        if (i == 1) {
            return UnitType.UnitTypes.Zerg_Drone.ordinal();
        }
        if (i == 2) {
            return UnitType.UnitTypes.Zerg_Overlord.ordinal();
        }
        if (i == 3) {
            return UnitType.UnitTypes.Zerg_Zergling.ordinal();
        }
        if (i == 4) {
            return UnitType.UnitTypes.Zerg_Hydralisk.ordinal();
        }
        if (i == 5) {
            return UnitType.UnitTypes.Zerg_Queen.ordinal();
        }
        if (i == 6) {
            return UnitType.UnitTypes.Zerg_Broodling.ordinal();
        }
        if (i == 7) {
            return UnitType.UnitTypes.Zerg_Mutalisk.ordinal();
        }
        if (i == 8) {
            return UnitType.UnitTypes.Zerg_Guardian.ordinal();
        }
        if (i == 9) {
            return UnitType.UnitTypes.Zerg_Devourer.ordinal();
        }
        return UnitType.UnitTypes.Zerg_Drone.ordinal();
    }

    public static int buildingTypeFromIter(int i) {
        if (i == 0) {
            return UnitType.UnitTypes.Zerg_Hatchery.ordinal();
        }
        if (i == 1) {
            return UnitType.UnitTypes.Zerg_Spawning_Pool.ordinal();
        }
        if (i == 2) {
            return UnitType.UnitTypes.Zerg_Extractor.ordinal();
        }
        if (i == 3) {
            return UnitType.UnitTypes.Zerg_Hydralisk_Den.ordinal();
        }
        if (i == 4) {
            return UnitType.UnitTypes.Zerg_Creep_Colony.ordinal();
        }
        if (i == 5) {
            return UnitType.UnitTypes.Zerg_Sunken_Colony.ordinal();
        }
        if (i == 6) {
            return UnitType.UnitTypes.Zerg_Lair.ordinal();
        }
        if (i == 7) {
            return UnitType.UnitTypes.Zerg_Queens_Nest.ordinal();
        }
        if (i == 8) {
            return UnitType.UnitTypes.Zerg_Spire.ordinal();
        }
        if (i == 9) {
            return UnitType.UnitTypes.Zerg_Hive.ordinal();
        }
        if (i == 10) {
            return UnitType.UnitTypes.Zerg_Greater_Spire.ordinal();
        }
        if (i == 11) {
            return UnitType.UnitTypes.Zerg_Evolution_Chamber.ordinal();
        }
        if (i == 12) {
            return UnitType.UnitTypes.Zerg_Spore_Colony.ordinal();
        }
        return UnitType.UnitTypes.Zerg_Hatchery.ordinal();
    }

    public static int unitIterFromType(int typeID) {
        if (typeID == UnitType.UnitTypes.Zerg_Larva.ordinal()) {
            return 0;
        }
        if (typeID == UnitType.UnitTypes.Zerg_Drone.ordinal()) {
            return 1;
        }
        if (typeID == UnitType.UnitTypes.Zerg_Overlord.ordinal()) {
            return 2;
        }
        if (typeID == UnitType.UnitTypes.Zerg_Zergling.ordinal()) {
            return 3;
        }
        if (typeID == UnitType.UnitTypes.Zerg_Hydralisk.ordinal()) {
            return 4;
        }
        if (typeID == UnitType.UnitTypes.Zerg_Queen.ordinal()) {
            return 5;
        }
        if (typeID == UnitType.UnitTypes.Zerg_Broodling.ordinal()) {
            return 6;
        }
        if (typeID == UnitType.UnitTypes.Zerg_Mutalisk.ordinal()) {
            return 7;
        }
        if (typeID == UnitType.UnitTypes.Zerg_Guardian.ordinal()) {
            return 8;
        }
        if (typeID == UnitType.UnitTypes.Zerg_Devourer.ordinal()) {
            return 9;
        }
        return 0;
    }

    public static int buildingIterFromType(int typeID) {
        if (typeID == UnitType.UnitTypes.Zerg_Hatchery.ordinal()) {
            return 0;
        }
        if (typeID == UnitType.UnitTypes.Zerg_Spawning_Pool.ordinal()) {
            return 1;
        }
        if (typeID == UnitType.UnitTypes.Zerg_Extractor.ordinal()) {
            return 2;
        }
        if (typeID == UnitType.UnitTypes.Zerg_Hydralisk_Den.ordinal()) {
            return 3;
        }
        if (typeID == UnitType.UnitTypes.Zerg_Creep_Colony.ordinal()) {
            return 4;
        }
        if (typeID == UnitType.UnitTypes.Zerg_Sunken_Colony.ordinal()) {
            return 5;
        }
        if (typeID == UnitType.UnitTypes.Zerg_Lair.ordinal()) {
            return 6;
        }
        if (typeID == UnitType.UnitTypes.Zerg_Queens_Nest.ordinal()) {
            return 7;
        }
        if (typeID == UnitType.UnitTypes.Zerg_Spire.ordinal()) {
            return 8;
        }
        if (typeID == UnitType.UnitTypes.Zerg_Hive.ordinal()) {
            return 9;
        }
        if (typeID == UnitType.UnitTypes.Zerg_Greater_Spire.ordinal()) {
            return 10;
        }
        if (typeID == UnitType.UnitTypes.Zerg_Evolution_Chamber.ordinal()) {
            return 11;
        }
        if (typeID == UnitType.UnitTypes.Zerg_Spore_Colony.ordinal()) {
            return 12;
        }
        return -1;
    }

    public static boolean buildingIterFromZergType(int typeID) {
        return typeID == UnitType.UnitTypes.Zerg_Hatchery.ordinal() || typeID == UnitType.UnitTypes.Zerg_Extractor.ordinal() || typeID == UnitType.UnitTypes.Zerg_Spawning_Pool.ordinal() || typeID == UnitType.UnitTypes.Zerg_Creep_Colony.ordinal() || typeID == UnitType.UnitTypes.Zerg_Defiler_Mound.ordinal() || typeID == UnitType.UnitTypes.Zerg_Evolution_Chamber.ordinal() || typeID == UnitType.UnitTypes.Zerg_Greater_Spire.ordinal() || typeID == UnitType.UnitTypes.Zerg_Hive.ordinal() || typeID == UnitType.UnitTypes.Zerg_Hydralisk_Den.ordinal() || typeID == UnitType.UnitTypes.Zerg_Infested_Command_Center.ordinal() || typeID == UnitType.UnitTypes.Zerg_Lair.ordinal() || typeID == UnitType.UnitTypes.Zerg_Nydus_Canal.ordinal() || typeID == UnitType.UnitTypes.Zerg_Queens_Nest.ordinal() || typeID == UnitType.UnitTypes.Zerg_Spire.ordinal() || typeID == UnitType.UnitTypes.Zerg_Spore_Colony.ordinal() || typeID == UnitType.UnitTypes.Zerg_Sunken_Colony.ordinal() || typeID == UnitType.UnitTypes.Zerg_Ultralisk_Cavern.ordinal();
    }

    public static boolean buildingIterFromProtossType(int typeID) {
        return typeID == UnitType.UnitTypes.Protoss_Arbiter_Tribunal.ordinal() || typeID == UnitType.UnitTypes.Protoss_Assimilator.ordinal() || typeID == UnitType.UnitTypes.Protoss_Citadel_of_Adun.ordinal() || typeID == UnitType.UnitTypes.Protoss_Cybernetics_Core.ordinal() || typeID == UnitType.UnitTypes.Protoss_Fleet_Beacon.ordinal() || typeID == UnitType.UnitTypes.Protoss_Forge.ordinal() || typeID == UnitType.UnitTypes.Protoss_Gateway.ordinal() || typeID == UnitType.UnitTypes.Protoss_Nexus.ordinal() || typeID == UnitType.UnitTypes.Protoss_Observatory.ordinal() || typeID == UnitType.UnitTypes.Protoss_Photon_Cannon.ordinal() || typeID == UnitType.UnitTypes.Protoss_Pylon.ordinal() || typeID == UnitType.UnitTypes.Protoss_Robotics_Facility.ordinal() || typeID == UnitType.UnitTypes.Protoss_Robotics_Support_Bay.ordinal() || typeID == UnitType.UnitTypes.Protoss_Shield_Battery.ordinal() || typeID == UnitType.UnitTypes.Protoss_Stargate.ordinal() || typeID == UnitType.UnitTypes.Protoss_Templar_Archives.ordinal();
    }

    public static boolean buildingIterFromTerranType(int typeID) {
        return typeID == UnitType.UnitTypes.Terran_Academy.ordinal() || typeID == UnitType.UnitTypes.Terran_Armory.ordinal() || typeID == UnitType.UnitTypes.Terran_Barracks.ordinal() || typeID == UnitType.UnitTypes.Terran_Bunker.ordinal() || typeID == UnitType.UnitTypes.Terran_Command_Center.ordinal() || typeID == UnitType.UnitTypes.Terran_Comsat_Station.ordinal() || typeID == UnitType.UnitTypes.Terran_Control_Tower.ordinal() || typeID == UnitType.UnitTypes.Terran_Covert_Ops.ordinal() || typeID == UnitType.UnitTypes.Terran_Engineering_Bay.ordinal() || typeID == UnitType.UnitTypes.Terran_Factory.ordinal() || typeID == UnitType.UnitTypes.Terran_Machine_Shop.ordinal() || typeID == UnitType.UnitTypes.Terran_Missile_Turret.ordinal() || typeID == UnitType.UnitTypes.Terran_Nuclear_Silo.ordinal() || typeID == UnitType.UnitTypes.Terran_Physics_Lab.ordinal() || typeID == UnitType.UnitTypes.Terran_Refinery.ordinal() || typeID == UnitType.UnitTypes.Terran_Science_Facility.ordinal() || typeID == UnitType.UnitTypes.Terran_Starport.ordinal() || typeID == UnitType.UnitTypes.Terran_Supply_Depot.ordinal();
    }

    public static int requiredMinerals(int buildType) {
        if (buildType == UnitType.UnitTypes.Zerg_Overlord.ordinal() || buildType == UnitType.UnitTypes.Zerg_Hydralisk_Den.ordinal()) {
            return 100;
        }
        if (buildType == UnitType.UnitTypes.Zerg_Hydralisk.ordinal() || buildType == UnitType.UnitTypes.Zerg_Spore_Colony.ordinal()) {
            return 75;
        }
        if (buildType == UnitType.UnitTypes.Zerg_Hatchery.ordinal()) {
            return 300;
        }
        if (buildType == UnitType.UnitTypes.Zerg_Spawning_Pool.ordinal()) {
            return 200;
        }
        return 50;
    }

    public static int requiredGas(int buildType) {
        if (buildType == UnitType.UnitTypes.Zerg_Hydralisk.ordinal()) {
            return 25;
        }
        if (buildType == UnitType.UnitTypes.Zerg_Hydralisk_Den.ordinal()) {
            return 50;
        }
        return 0;
    }

    public static boolean isBroodlingable(int typeID) {
        return typeID == UnitType.UnitTypes.Terran_Marine.ordinal() || typeID == UnitType.UnitTypes.Terran_Firebat.ordinal();
    }

    public static int broodlingLevel(int typeID) {
        if (typeID == UnitType.UnitTypes.Zerg_Zergling.ordinal() || typeID == UnitType.UnitTypes.Protoss_Zealot.ordinal()) {
            return 1;
        }
        if (typeID == UnitType.UnitTypes.Terran_Marine.ordinal() || typeID == UnitType.UnitTypes.Zerg_Hydralisk.ordinal() || typeID == UnitType.UnitTypes.Protoss_Dragoon.ordinal()) {
            return 2;
        }
        if (typeID == UnitType.UnitTypes.Terran_Firebat.ordinal() || typeID == UnitType.UnitTypes.Terran_Vulture.ordinal() || typeID == UnitType.UnitTypes.Zerg_Lurker.ordinal() || typeID == UnitType.UnitTypes.Zerg_Lurker_Egg.ordinal() || typeID == UnitType.UnitTypes.Zerg_Defiler.ordinal() || typeID == UnitType.UnitTypes.Protoss_Dark_Templar.ordinal() || typeID == UnitType.UnitTypes.Protoss_High_Templar.ordinal()) {
            return 3;
        }
        if (typeID == UnitType.UnitTypes.Terran_Medic.ordinal() || typeID == UnitType.UnitTypes.Terran_Ghost.ordinal() || typeID == UnitType.UnitTypes.Terran_Goliath.ordinal() || typeID == UnitType.UnitTypes.Zerg_Ultralisk.ordinal()) {
            return 4;
        }
        if (typeID == UnitType.UnitTypes.Terran_Siege_Tank_Siege_Mode.ordinal() || typeID == UnitType.UnitTypes.Terran_Siege_Tank_Tank_Mode.ordinal()) {
            return 5;
        }
        return 0;
    }

    public static boolean isDangerousGround(int typeID) {
        return typeID == UnitType.UnitTypes.Terran_Battlecruiser.ordinal() || typeID == UnitType.UnitTypes.Terran_Bunker.ordinal() || typeID == UnitType.UnitTypes.Terran_Ghost.ordinal() || typeID == UnitType.UnitTypes.Terran_Goliath.ordinal() || typeID == UnitType.UnitTypes.Terran_Marine.ordinal() || typeID == UnitType.UnitTypes.Terran_Wraith.ordinal() || typeID == UnitType.UnitTypes.Terran_Firebat.ordinal() || typeID == UnitType.UnitTypes.Terran_Siege_Tank_Siege_Mode.ordinal() || typeID == UnitType.UnitTypes.Terran_Siege_Tank_Tank_Mode.ordinal() || typeID == UnitType.UnitTypes.Terran_Vulture.ordinal() || typeID == UnitType.UnitTypes.Zerg_Ultralisk.ordinal() || typeID == UnitType.UnitTypes.Zerg_Hydralisk.ordinal() || typeID == UnitType.UnitTypes.Zerg_Mutalisk.ordinal() || typeID == UnitType.UnitTypes.Zerg_Zergling.ordinal() || typeID == UnitType.UnitTypes.Zerg_Guardian.ordinal() || typeID == UnitType.UnitTypes.Zerg_Sunken_Colony.ordinal() || typeID == UnitType.UnitTypes.Protoss_Arbiter.ordinal() || typeID == UnitType.UnitTypes.Protoss_Archon.ordinal() || typeID == UnitType.UnitTypes.Protoss_Carrier.ordinal() || typeID == UnitType.UnitTypes.Protoss_Zealot.ordinal() || typeID == UnitType.UnitTypes.Protoss_Dark_Templar.ordinal() || typeID == UnitType.UnitTypes.Protoss_Dragoon.ordinal() || typeID == UnitType.UnitTypes.Protoss_Photon_Cannon.ordinal() || typeID == UnitType.UnitTypes.Protoss_Reaver.ordinal() || typeID == UnitType.UnitTypes.Protoss_Scout.ordinal();
    }

    public static boolean isDangerousAir(int typeID) {
        return typeID == UnitType.UnitTypes.Terran_Battlecruiser.ordinal() || typeID == UnitType.UnitTypes.Terran_Bunker.ordinal() || typeID == UnitType.UnitTypes.Terran_Ghost.ordinal() || typeID == UnitType.UnitTypes.Terran_Goliath.ordinal() || typeID == UnitType.UnitTypes.Terran_Marine.ordinal() || typeID == UnitType.UnitTypes.Terran_Missile_Turret.ordinal() || typeID == UnitType.UnitTypes.Terran_Valkyrie.ordinal() || typeID == UnitType.UnitTypes.Terran_Wraith.ordinal() || typeID == UnitType.UnitTypes.Zerg_Devourer.ordinal() || typeID == UnitType.UnitTypes.Zerg_Hydralisk.ordinal() || typeID == UnitType.UnitTypes.Zerg_Mutalisk.ordinal() || typeID == UnitType.UnitTypes.Zerg_Spore_Colony.ordinal() || typeID == UnitType.UnitTypes.Zerg_Scourge.ordinal() || typeID == UnitType.UnitTypes.Protoss_Arbiter.ordinal() || typeID == UnitType.UnitTypes.Protoss_Archon.ordinal() || typeID == UnitType.UnitTypes.Protoss_Carrier.ordinal() || typeID == UnitType.UnitTypes.Protoss_Corsair.ordinal() || typeID == UnitType.UnitTypes.Protoss_Dragoon.ordinal() || typeID == UnitType.UnitTypes.Protoss_Photon_Cannon.ordinal() || typeID == UnitType.UnitTypes.Protoss_Scout.ordinal();
    }

    public static boolean isAir(int typeID) {
        return typeID == UnitType.UnitTypes.Terran_Battlecruiser.ordinal() || typeID == UnitType.UnitTypes.Terran_Dropship.ordinal() || typeID == UnitType.UnitTypes.Terran_Science_Vessel.ordinal() || typeID == UnitType.UnitTypes.Terran_Valkyrie.ordinal() || typeID == UnitType.UnitTypes.Terran_Wraith.ordinal() || typeID == UnitType.UnitTypes.Zerg_Devourer.ordinal() || typeID == UnitType.UnitTypes.Zerg_Cocoon.ordinal() || typeID == UnitType.UnitTypes.Zerg_Mutalisk.ordinal() || typeID == UnitType.UnitTypes.Zerg_Guardian.ordinal() || typeID == UnitType.UnitTypes.Zerg_Scourge.ordinal() || typeID == UnitType.UnitTypes.Zerg_Overlord.ordinal() || typeID == UnitType.UnitTypes.Zerg_Queen.ordinal() || typeID == UnitType.UnitTypes.Protoss_Arbiter.ordinal() || typeID == UnitType.UnitTypes.Protoss_Carrier.ordinal() || typeID == UnitType.UnitTypes.Protoss_Corsair.ordinal() || typeID == UnitType.UnitTypes.Protoss_Shuttle.ordinal() || typeID == UnitType.UnitTypes.Protoss_Observer.ordinal() || typeID == UnitType.UnitTypes.Protoss_Scout.ordinal();
    }

    public static boolean isDetector(int typeID) {
        return typeID == UnitType.UnitTypes.Terran_Missile_Turret.ordinal() || typeID == UnitType.UnitTypes.Terran_Science_Vessel.ordinal() || typeID == UnitType.UnitTypes.Zerg_Overlord.ordinal() || typeID == UnitType.UnitTypes.Zerg_Spore_Colony.ordinal() || typeID == UnitType.UnitTypes.Protoss_Observer.ordinal() || typeID == UnitType.UnitTypes.Protoss_Photon_Cannon.ordinal();
    }

    public static boolean isCritter(int typeID) {
        return typeID == UnitType.UnitTypes.Critter_Bengalaas.ordinal() || typeID == UnitType.UnitTypes.Critter_Kakaru.ordinal() || typeID == UnitType.UnitTypes.Critter_Ragnasaur.ordinal() || typeID == UnitType.UnitTypes.Critter_Rhynadon.ordinal() || typeID == UnitType.UnitTypes.Critter_Scantid.ordinal() || typeID == UnitType.UnitTypes.Critter_Ursadon.ordinal();
    }

    public static int getRange(int typeID) {
        if (typeID == UnitType.UnitTypes.Terran_Siege_Tank_Siege_Mode.ordinal()) {
            return 350;
        }
        if (typeID == UnitType.UnitTypes.Terran_Marine.ordinal()) {
            return 220;
        }
        if (typeID == UnitType.UnitTypes.Terran_Firebat.ordinal()) {
            return 140;
        }
        if (typeID == UnitType.UnitTypes.Terran_Missile_Turret.ordinal()) {
            return 310;
        }
        if (typeID == UnitType.UnitTypes.Terran_Goliath.ordinal()) {
            return 285;
        }
        if (typeID == UnitType.UnitTypes.Protoss_Zealot.ordinal()) {
            return 140;
        }
        if (typeID == UnitType.UnitTypes.Protoss_Dark_Templar.ordinal()) {
            return 130;
        }
        if (typeID == UnitType.UnitTypes.Protoss_Photon_Cannon.ordinal()) {
            return 310;
        }
        if (typeID == UnitType.UnitTypes.Zerg_Zergling.ordinal()) {
            return 140;
        }
        if (typeID == UnitType.UnitTypes.Zerg_Ultralisk.ordinal()) {
            return 140;
        }
        if (typeID == UnitType.UnitTypes.Zerg_Hydralisk.ordinal()) {
            return 240;
        }
        if (typeID == UnitType.UnitTypes.Zerg_Broodling.ordinal()) {
            return 120;
        }
        if (typeID == UnitType.UnitTypes.Zerg_Overlord.ordinal()) {
            return 300;
        }
        if (typeID == UnitType.UnitTypes.Zerg_Spore_Colony.ordinal()) {
            return 310;
        }
        return 270;
    }

    public static boolean isAbuilding(int typeID) {
        return Operators.buildingIterFromZergType(typeID);
    }

    public static boolean isAbuildingAll(int typeID) {
        return Operators.buildingIterFromZergType(typeID) || Operators.buildingIterFromTerranType(typeID) || Operators.buildingIterFromProtossType(typeID);
    }

    public static void init() {
        iterHatchery = Operators.buildingIterFromType(UnitType.UnitTypes.Zerg_Hatchery.ordinal());
        iterPool = Operators.buildingIterFromType(UnitType.UnitTypes.Zerg_Spawning_Pool.ordinal());
        iterExtractor = Operators.buildingIterFromType(UnitType.UnitTypes.Zerg_Extractor.ordinal());
        iterHydra = Operators.buildingIterFromType(UnitType.UnitTypes.Zerg_Hydralisk_Den.ordinal());
        iterLair = Operators.buildingIterFromType(UnitType.UnitTypes.Zerg_Lair.ordinal());
        iterQueenNest = Operators.buildingIterFromType(UnitType.UnitTypes.Zerg_Queens_Nest.ordinal());
        iterSpire = Operators.buildingIterFromType(UnitType.UnitTypes.Zerg_Spire.ordinal());
        iterHive = Operators.buildingIterFromType(UnitType.UnitTypes.Zerg_Hive.ordinal());
        iterGreatSpire = Operators.buildingIterFromType(UnitType.UnitTypes.Zerg_Greater_Spire.ordinal());
        iterEvolutionChamber = Operators.buildingIterFromType(UnitType.UnitTypes.Zerg_Evolution_Chamber.ordinal());
        iterDrones = Operators.unitIterFromType(UnitType.UnitTypes.Zerg_Drone.ordinal());
        iterOverlords = Operators.unitIterFromType(UnitType.UnitTypes.Zerg_Overlord.ordinal());
        iterZerglings = Operators.unitIterFromType(UnitType.UnitTypes.Zerg_Zergling.ordinal());
        iterHydralisks = Operators.unitIterFromType(UnitType.UnitTypes.Zerg_Hydralisk.ordinal());
        iterQueens = Operators.unitIterFromType(UnitType.UnitTypes.Zerg_Queen.ordinal());
        iterMutalisks = Operators.unitIterFromType(UnitType.UnitTypes.Zerg_Mutalisk.ordinal());
        iterGuardians = Operators.unitIterFromType(UnitType.UnitTypes.Zerg_Guardian.ordinal());
        iterDevourers = Operators.unitIterFromType(UnitType.UnitTypes.Zerg_Devourer.ordinal());
    }

    public static int distance(BaseManager baseManager, Unit u) {
        return (int)Math.sqrt((baseManager.posX - u.getX()) * (baseManager.posX - u.getX()) + (baseManager.posY - u.getY()) * (baseManager.posY - u.getY()));
    }

    public static int distance(Unit unit, Unit u) {
        return (int)Math.sqrt((unit.getX() - u.getX()) * (unit.getX() - u.getX()) + (unit.getY() - u.getY()) * (unit.getY() - u.getY()));
    }

    public static int distance(Unit unit, int x, int y) {
        return (int)Math.sqrt((unit.getX() - x) * (unit.getX() - x) + (unit.getY() - y) * (unit.getY() - y));
    }

    public static int distance(int x1, int y1, int x, int y) {
        return (int)Math.sqrt((x1 - x) * (x1 - x) + (y1 - y) * (y1 - y));
    }

    public static Point getSize(int typeID) {
        if (typeID == UnitType.UnitTypes.Zerg_Hatchery.ordinal() || typeID == UnitType.UnitTypes.Zerg_Lair.ordinal() || typeID == UnitType.UnitTypes.Zerg_Hive.ordinal()) {
            return new Point(4, 3);
        }
        if (typeID == UnitType.UnitTypes.Zerg_Extractor.ordinal()) {
            return new Point(4, 2);
        }
        if (typeID == UnitType.UnitTypes.Zerg_Creep_Colony.ordinal() || typeID == UnitType.UnitTypes.Zerg_Sunken_Colony.ordinal() || typeID == UnitType.UnitTypes.Zerg_Spore_Colony.ordinal() || typeID == UnitType.UnitTypes.Zerg_Spire.ordinal() || typeID == UnitType.UnitTypes.Zerg_Greater_Spire.ordinal()) {
            return new Point(2, 2);
        }
        return new Point(3, 2);
    }

    public static boolean requirePsi(int typeID) {
        return typeID != UnitType.UnitTypes.Protoss_Pylon.ordinal();
    }

    public static void normalize(Point p) {
        double norme = Math.sqrt(p.x * p.x + p.y * p.y);
        p.x = (int)((double)p.x / norme);
        p.y = (int)((double)p.y / norme);
    }
}

