/*
 * Decompiled with CFR 0.152.
 */
package javabot.model;

import java.util.ArrayList;
import javabot.model.BaseLocation;
import javabot.model.ChokePoint;
import javabot.model.Region;

public class Map {
    private int width;
    private int height;
    private int walkWidth;
    private int walkHeight;
    private String name;
    private String hash;
    private int[] heightMap;
    private boolean[] buildable;
    private boolean[] walkable;
    private ArrayList<Region> regions = new ArrayList();
    private ArrayList<ChokePoint> chokePoints = new ArrayList();
    private ArrayList<BaseLocation> baseLocations = new ArrayList();

    public Map(int width, int height, String name, String hash, int[] heightMap, int[] buildable, int[] walkable) {
        this.width = width;
        this.height = height;
        this.walkWidth = 4 * width;
        this.walkHeight = 4 * height;
        this.name = name;
        this.hash = hash;
        this.heightMap = heightMap;
        this.buildable = new boolean[buildable.length];
        this.walkable = new boolean[walkable.length];
        int i = 0;
        while (i < buildable.length) {
            this.buildable[i] = buildable[i] == 1;
            ++i;
        }
        i = 0;
        while (i < walkable.length) {
            this.walkable[i] = walkable[i] == 1;
            ++i;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWalkWidth() {
        return this.walkWidth;
    }

    public int getWalkHeight() {
        return this.walkHeight;
    }

    public String getName() {
        return this.name;
    }

    public String getHash() {
        return this.hash;
    }

    public int getHeight(int tx, int ty) {
        if (tx < this.width && ty < this.height && tx >= 0 && ty >= 0) {
            return this.heightMap[tx + this.width * ty];
        }
        return 0;
    }

    public boolean isBuildable(int tx, int ty) {
        if (tx < this.width && ty < this.height && tx >= 0 && ty >= 0) {
            return this.buildable[tx + this.width * ty];
        }
        return false;
    }

    public boolean isWalkable(int wx, int wy) {
        if (wx < this.walkWidth && wy < this.walkHeight && wx >= 0 && wy >= 0) {
            return this.walkable[wx + this.walkWidth * wy];
        }
        return false;
    }

    public ArrayList<Region> getRegions() {
        return this.regions;
    }

    public ArrayList<ChokePoint> getChokePoints() {
        return this.chokePoints;
    }

    public ArrayList<BaseLocation> getBaseLocations() {
        return this.baseLocations;
    }
}

