/*
 * Decompiled with CFR 0.152.
 */
package javabot.managers;

import javabot.JavaBot;
import javabot.managers.BwapiCallsManager;
import javabot.managers.EnemyBuildingManager;
import javabot.managers.EnemyUnitManager;
import javabot.managers.NeutralUnitManager;
import javabot.managers.UnitManager;
import javabot.model.Unit;
import javabot.operators.Operators;
import javabot.types.TechType;

public class QueenManager
extends UnitManager {
    int currentEnergy = 0;
    EnemyUnitManager bestTarget = null;
    NeutralUnitManager bestParasiteTarget;
    int locationRadius = 400;
    int oldEnergy = 0;
    boolean occupied = false;
    boolean dodging = false;

    public QueenManager(Unit u) {
        super(u);
    }

    @Override
    public void update() {
        super.update();
        this.safeMarge = (120 - this.hp) * 2;
        this.currentEnergy = this.unit.getEnergy() - 1;
        this.bestTarget = null;
        this.bestParasiteTarget = null;
        int targetLevel = 0;
        if (this.countDontAct > 0 && this.currentEnergy < this.oldEnergy) {
            this.countDontAct = 1;
        }
        if (this.currentEnergy >= 150 && !this.occupied) {
            for (EnemyUnitManager enemy : JavaBot.enemyUnitsBroodlingManager) {
                if (Operators.distance(this.unit, enemy.unit) >= this.locationRadius || enemy.broodlingLevel <= 0 || enemy.isBroodlinged != 0 || enemy.broodlingLevel <= targetLevel) continue;
                this.bestTarget = enemy;
                targetLevel = enemy.broodlingLevel;
            }
        }
        if (this.bestTarget == null && this.currentEnergy >= 75 && !this.occupied) {
            for (NeutralUnitManager u : JavaBot.neutralUnitsMap.values()) {
                if (Operators.distance(this.unit, u.unit) >= this.locationRadius || u.parasited || u.timeParasite != 0) continue;
                this.bestParasiteTarget = u;
                u.timeParasite = 25;
                break;
            }
        }
        this.oldEnergy = this.currentEnergy;
        if (this.bestTarget != null && this.countDontAct == 0 && BwapiCallsManager.useTech(this.unit.getID(), TechType.TechTypes.Spawn_Broodlings.ordinal(), this.bestTarget.unit.getID())) {
            this.bestTarget.isBroodlinged = 100;
            this.countDontAct = 30;
        }
        if (this.bestParasiteTarget != null && this.countDontAct == 0 && BwapiCallsManager.useTech(this.unit.getID(), TechType.TechTypes.Parasite.ordinal(), this.bestParasiteTarget.unit.getID())) {
            this.countDontAct = 20;
            this.bestParasiteTarget.timeParasite = 35;
        }
        if (this.countDontAct <= 1) {
            this.dodgeEnemies();
        }
        if (this.countDontAct == 0 && this.unit.isIdle()) {
            Object enemy;
            if (Math.random() < (double)0.85f && JavaBot.enemyUnitsBroodlingManager.size() > 0) {
                int iterToGet = (int)(Math.random() * (double)JavaBot.enemyUnitsBroodlingManager.size());
                if (iterToGet < 0) {
                    iterToGet = 0;
                }
                if (iterToGet >= JavaBot.enemyUnitsBroodlingManager.size()) {
                    iterToGet = JavaBot.enemyUnitsBroodlingManager.size() - 1;
                }
                enemy = JavaBot.enemyUnitsBroodlingManager.get(iterToGet);
                if (BwapiCallsManager.move(this.unit.getID(), ((EnemyUnitManager)enemy).posX, ((EnemyUnitManager)enemy).posY)) {
                    this.countDontAct = 1;
                }
            } else if (Math.random() < 0.5 && JavaBot.enemyBuildingsManager.size() > 0) {
                int iterToGet = (int)(Math.random() * (double)JavaBot.enemyBuildingsManager.size());
                if (iterToGet < 0) {
                    iterToGet = 0;
                }
                if (iterToGet >= JavaBot.enemyBuildingsManager.size()) {
                    iterToGet = JavaBot.enemyBuildingsManager.size() - 1;
                }
                enemy = JavaBot.enemyBuildingsManager.get(iterToGet);
                if (BwapiCallsManager.move(this.unit.getID(), ((EnemyBuildingManager)enemy).posX, ((EnemyBuildingManager)enemy).posY)) {
                    this.countDontAct = 1;
                }
            } else {
                int randX = (int)(Math.random() * ((double)this.bwapi.getMap().getWidth() * 32.0));
                int randY = (int)(Math.random() * ((double)this.bwapi.getMap().getHeight() * 32.0));
                if (BwapiCallsManager.move(this.unit.getID(), randX, randY)) {
                    this.countDontAct = 1;
                }
            }
        }
    }

    public void dodgeEnemies() {
        int posYtoGo;
        int posXtoGo;
        int dy;
        int dx;
        for (EnemyUnitManager enemyUnitManager : JavaBot.enemyUnitsAirManager) {
            if (enemyUnitManager.broodlingLevel != 0 && this.currentEnergy >= 150 || Operators.distance(this.posX, this.posY, enemyUnitManager.posX, enemyUnitManager.posY) >= enemyUnitManager.range + this.safeMarge + 60) continue;
            dx = this.posX - enemyUnitManager.posX;
            dy = this.posY - enemyUnitManager.posY;
            if (dx > 100) {
                dx = 100;
            }
            if (dx < -100) {
                dx = -100;
            }
            if (dy > 100) {
                dy = 100;
            }
            if (dy < -100) {
                dy = -100;
            }
            posXtoGo = this.posX + dx;
            posYtoGo = this.posY + dy;
            if (!BwapiCallsManager.move(this.unit.getID(), posXtoGo, posYtoGo)) break;
            this.countDontAct = 8;
            break;
        }
        if (this.countDontAct == 0) {
            for (EnemyBuildingManager enemyBuildingManager : JavaBot.enemyBuildingsAirManager) {
                if (Operators.distance(this.posX, this.posY, enemyBuildingManager.posX, enemyBuildingManager.posY) >= enemyBuildingManager.range + this.safeMarge + 50) continue;
                dx = this.posX - enemyBuildingManager.posX;
                dy = this.posY - enemyBuildingManager.posY;
                if (dx > 80) {
                    dx = 80;
                }
                if (dx < -80) {
                    dx = -80;
                }
                if (dy > 80) {
                    dy = 80;
                }
                if (dy < -80) {
                    dy = -80;
                }
                posXtoGo = this.posX + dx;
                posYtoGo = this.posY + dy;
                if (!BwapiCallsManager.move(this.unit.getID(), posXtoGo, posYtoGo)) break;
                this.countDontAct = 8;
                break;
            }
        }
    }

    @Override
    public void drawDebug() {
        this.bwapi.drawText(this.unit.getX() - 10, this.unit.getY() - 8, "Queen:" + this.currentEnergy + ":" + this.countDontAct, false);
        if (this.bestParasiteTarget != null) {
            this.bwapi.drawLine(this.posX, this.posY, this.bestParasiteTarget.unit.getX(), this.bestParasiteTarget.unit.getY(), 135, false);
        }
        if (this.unit.isMoving()) {
            this.bwapi.drawLine(this.posX, this.posY, this.unit.getTargetX(), this.unit.getTargetY(), 117, false);
        }
    }
}

