/*
 * Decompiled with CFR 0.152.
 */
package javabot.managers;

import javabot.JavaBot;
import javabot.knowledge.Tech;
import javabot.managers.BuildingManager;
import javabot.managers.BwapiCallsManager;
import javabot.managers.UnitManager;
import javabot.model.Unit;
import javabot.types.TechType;
import javabot.types.UnitType;

public class HatcheryManager
extends BuildingManager {
    public UnitManager.UPGRADE_STATES state = UnitManager.UPGRADE_STATES.NONE;

    public HatcheryManager(Unit u) {
        super(u);
    }

    @Override
    public void update() {
        super.update();
        if (this.base != null) {
            this.base.timerRebuild = 5;
        }
        if (this.state == UnitManager.UPGRADE_STATES.NONE && this.unit.getRemainingResearchTime() > 0) {
            this.state = UnitManager.UPGRADE_STATES.EVOLVING;
            if (Tech.burrow == 0) {
                Tech.burrow = 1;
            }
        }
        if (this.state == UnitManager.UPGRADE_STATES.EVOLVING && this.unit.getRemainingResearchTime() == 0) {
            this.state = UnitManager.UPGRADE_STATES.NONE;
            Tech.burrow = 2;
        }
        if (Tech.burrow == 0) {
            if (JavaBot.knowledge.realMinerals >= 100 && JavaBot.knowledge.realGas >= 100) {
                BwapiCallsManager.research(this.unit.getID(), TechType.TechTypes.Burrowing.ordinal());
                this.countDontAct = 5;
            }
        } else if (this.base != null && this.base.requestLair && this.countDontAct == 0 && this.base.blockLair == 0 && (Tech.burrow == 2 || JavaBot.currFrame >= 3000)) {
            if (JavaBot.knowledge.realMinerals >= 150 && JavaBot.knowledge.realGas >= 100) {
                BwapiCallsManager.morph(this.unit.getID(), UnitType.UnitTypes.Zerg_Lair.ordinal());
                this.base.blockLair = 5;
            } else {
                JavaBot.requestsManager.requestRessources(150, 100);
            }
        }
    }

    @Override
    public void drawDebug() {
        this.bwapi.drawText(this.unit.getX() - 10, this.unit.getY() - 8, "Hatchery  tech = " + Tech.burrow + ", time : " + this.unit.getRemainingResearchTime(), false);
    }
}

