/*
 * Decompiled with CFR 0.152.
 */
package javabot.managers;

import java.awt.Point;
import javabot.JavaBot;
import javabot.knowledge.Tech;
import javabot.knowledge.Tile;
import javabot.knowledge.TileGraph;
import javabot.managers.BaseManager;
import javabot.managers.BwapiCallsManager;
import javabot.managers.UnitManager;
import javabot.model.Unit;
import javabot.operators.Operators;
import javabot.types.TechType;
import javabot.types.UnitType;

public class DroneManager
extends UnitManager {
    int chosenForExpand = 0;
    int chosenForRebuild;
    int chosenForPool = 0;
    int chosenForMacro = 0;
    int chosenForExtractor = 0;
    int chosenForHydraDen = 0;
    int chosenForCreep = 0;
    int chosenForQueenNest = 0;
    int chosenForSpire = 0;
    int chosenForEvo = 0;
    BaseManager oldBase = null;
    BaseManager friendlyBase;
    BaseManager bestExpand = null;
    int timeUntilInaccessible = 60;
    int radiusDetectBurrow = 210;
    int radiusDetectUnburrow = 220;
    int timerInaccessible;
    int timerAttack;
    int minDistance;
    int oldHp;
    int actFrameBurrow = 0;
    Point buildPlace = new Point(-1, 0);
    DroneState state = DroneState.NORMAL;
    int transitionStates = 0;
    public boolean isConstructing = true;

    public DroneManager(Unit u) {
        super(u);
    }

    @Override
    public void update() {
        super.update();
        if (this.unit.isGatheringGas()) {
            ++JavaBot.strategy.gasPerMinute;
        }
        if (this.unit.isGatheringMinerals()) {
            ++JavaBot.strategy.mineralsPerMinute;
        }
        this.safeMarge = (40 - this.hp) * 2;
        if (this.dead) {
            if (this.chosenForExpand != 0 && JavaBot.knowledge.timerTryExpand > 0) {
                JavaBot.knowledge.timerTryExpand = 300;
                if (this.bestExpand != null && this.bestExpand.safeExpandScore > 10) {
                    this.bestExpand.safeExpandScore = (int)((float)this.bestExpand.safeExpandScore * 0.8f);
                }
            }
            if (this.base != null) {
                this.base.dronesMap.remove(this.unit.getID());
            }
        }
        if (this.free()) {
            this.buildPlace.x = -1;
        }
        if (this.free() && JavaBot.knowledge.requestedBuildings[Operators.iterHatchery] > 0 && this.bestExpand != null && JavaBot.knowledge.timerTryExpand == 0 && JavaBot.canExpand) {
            this.chosenForExpand = 1;
            JavaBot.knowledge.timerTryExpand = 2100;
        }
        if (this.free() && this.base.state == BaseManager.BaseState.UNKNOWN && this.base.timerRebuild == 0) {
            this.chosenForRebuild = 1;
            this.base.timerRebuild = 10;
            this.bestExpand = this.base;
        }
        if (this.free() && this.base.requestExtractor && this.base.timerTryExtractor == 0) {
            this.chosenForExtractor = 1;
            this.base.timerTryExtractor = 900;
        }
        if (this.free() && this.base.requestHydraDen && this.base.timerTryHydraDen == 0 && JavaBot.knowledge.gas >= 32 && JavaBot.repartition.getTechMinerals() >= 70 && JavaBot.knowledge.timerTryHydra == 0) {
            this.chosenForHydraDen = 1;
            this.base.timerTryHydraDen = 900;
            JavaBot.knowledge.timerTryHydra = 900;
        }
        if (this.free() && this.base.requestQueenNest && this.base.timerTryQueenNest == 0 && JavaBot.knowledge.timerTryQueenNest == 0) {
            this.chosenForQueenNest = 1;
            this.base.timerTryQueenNest = 900;
            JavaBot.knowledge.timerTryQueenNest = 900;
        }
        if (this.free() && this.base.requestSpire && this.base.timerTrySpire == 0 && JavaBot.knowledge.timerTrySpire == 0) {
            this.chosenForSpire = 1;
            this.base.timerTrySpire = 900;
            JavaBot.knowledge.timerTrySpire = 900;
        }
        if (this.free() && this.base.requestCreep && this.base.timerTryCreep == 0 && JavaBot.repartition.getExpandMinerals() >= 65) {
            this.chosenForCreep = 1;
            this.base.timerTryCreep = 650;
        }
        if (this.free() && JavaBot.knowledge.requestMacro && this.base.timerTryMacro == 0 && this.base.nbDrones > 6 && this.base.nbHatcheries <= 1) {
            this.chosenForMacro = 1;
            this.base.timerTryMacro = 800;
        }
        if (this.free() && JavaBot.knowledge.requestedBuildings[Operators.iterPool] > 0 && JavaBot.knowledge.timerTryPool == 0 && JavaBot.repartition.getPoolMinerals() >= 140) {
            JavaBot.knowledge.timerTryPool = 400;
            this.chosenForPool = 1;
        }
        if (this.free() && JavaBot.knowledge.requestedBuildings[Operators.iterEvolutionChamber] > 0 && JavaBot.knowledge.timerTryEvo == 0 && JavaBot.repartition.getEvoMinerals() >= 60) {
            JavaBot.knowledge.timerTryEvo = 400;
            this.chosenForEvo = 1;
        }
        if (this.free() && this.base.extractor != null && this.base.dronesOnGas < this.base.nbDronesWantedOnGas && this.base.timerGoOnGas == 0) {
            this.bwapi.rightClick(this.unit.getID(), this.base.extractor.getID());
            this.base.timerGoOnGas = 300;
        }
        if (this.unit.isCarryingGas() && this.base.dronesOnGas > this.base.nbDronesWantedOnGas && this.base.timerGoOnMinerals == 0) {
            this.mineClosestmineral();
            this.base.timerGoOnMinerals = 300;
        }
        this.updateIsInBase();
        if (this.chosenForExpand != 0) {
            this.updateExpand();
        } else if (this.chosenForRebuild != 0) {
            this.updateRebuild();
        } else if (this.chosenForMacro != 0) {
            if (JavaBot.knowledge.minerals < 200 || this.base.nbHatcheries >= 2) {
                this.chosenForMacro = 0;
            } else if (this.buildPlace.x == -1) {
                this.buildPlace = this.base.basePlanner.potentialHatchery != null ? this.base.basePlanner.potentialHatchery : JavaBot.getBuildTile(this.unit.getID(), UnitType.UnitTypes.Zerg_Hatchery.ordinal(), this.base.posX, this.base.posY);
            } else {
                if (Operators.distance(this.posX, this.posY, this.buildPlace.x * 32, this.buildPlace.y * 32) < 50 || this.unit.isConstructing() || this.unit.isMoving()) {
                    JavaBot.requestsManager.requestRessources(300, 0);
                }
                if (JavaBot.knowledge.realMinerals >= 300) {
                    BwapiCallsManager.build(this.unit.getID(), this.buildPlace.x, this.buildPlace.y, UnitType.UnitTypes.Zerg_Hatchery.ordinal());
                } else {
                    BwapiCallsManager.move(this.unit.getID(), this.buildPlace.x * 32, this.buildPlace.y * 32);
                }
            }
        } else if (this.chosenForPool != 0) {
            if (JavaBot.knowledge.currentBuildings[Operators.iterPool] + JavaBot.knowledge.warpingBuildings[Operators.iterPool] > 0) {
                this.chosenForPool = 0;
            } else if (this.buildPlace.x == -1) {
                this.buildPlace = JavaBot.getBuildTile(this.unit.getID(), UnitType.UnitTypes.Zerg_Spawning_Pool.ordinal(), this.friendlyBase.posX, this.friendlyBase.posY);
            } else {
                if (Operators.distance(this.posX, this.posY, this.buildPlace.x * 32, this.buildPlace.y * 32) < 50 || this.unit.isConstructing()) {
                    JavaBot.requestsManager.requestRessources(200, 0);
                    JavaBot.knowledge.timerTryPool = 200;
                }
                if (JavaBot.repartition.getPoolMinerals() >= 200) {
                    BwapiCallsManager.build(this.unit.getID(), this.buildPlace.x, this.buildPlace.y, UnitType.UnitTypes.Zerg_Spawning_Pool.ordinal());
                } else {
                    BwapiCallsManager.move(this.unit.getID(), this.buildPlace.x * 32, this.buildPlace.y * 32);
                }
            }
        } else if (this.chosenForExtractor != 0) {
            if (this.base.nbExtractor > 0 || this.base.timerTryExtractor == 0) {
                this.chosenForExtractor = 0;
            } else if (this.buildPlace.x == -1) {
                this.buildPlace = JavaBot.getBuildTile(this.unit.getID(), UnitType.UnitTypes.Zerg_Extractor.ordinal(), this.base.posX, this.base.posY);
            } else {
                if (Operators.distance(this.posX, this.posY, this.buildPlace.x * 32, this.buildPlace.y * 32) < 100 || this.unit.isConstructing() || this.unit.isMoving()) {
                    JavaBot.requestsManager.requestRessources(50, 0);
                }
                if (JavaBot.repartition.getExtractMinerals() >= 50) {
                    BwapiCallsManager.build(this.unit.getID(), this.buildPlace.x, this.buildPlace.y, UnitType.UnitTypes.Zerg_Extractor.ordinal());
                } else {
                    BwapiCallsManager.move(this.unit.getID(), this.buildPlace.x * 32, this.buildPlace.y * 32);
                }
            }
        } else if (this.chosenForHydraDen != 0) {
            if (this.base.nbHydraDen > 0 || this.base.timerTryHydraDen == 0) {
                this.chosenForHydraDen = 0;
            } else if (this.buildPlace.x == -1) {
                this.buildPlace = JavaBot.getBuildTile(this.unit.getID(), UnitType.UnitTypes.Zerg_Hydralisk_Den.ordinal(), this.base.posX, this.base.posY);
            } else {
                if (Operators.distance(this.posX, this.posY, this.buildPlace.x * 32, this.buildPlace.y * 32) < 50 || this.unit.isConstructing()) {
                    this.base.timerTryHydraDen = 200;
                    JavaBot.requestsManager.requestRessources(100, 50);
                }
                if (JavaBot.repartition.getHydraDenMinerals() >= 100 && JavaBot.knowledge.realGas >= 50) {
                    BwapiCallsManager.build(this.unit.getID(), this.buildPlace.x, this.buildPlace.y, UnitType.UnitTypes.Zerg_Hydralisk_Den.ordinal());
                } else {
                    BwapiCallsManager.move(this.unit.getID(), this.buildPlace.x * 32, this.buildPlace.y * 32);
                }
            }
        } else if (this.chosenForQueenNest != 0) {
            if (this.base.nbQueenNest > 0 || this.base.timerTryQueenNest == 0 || !this.base.requestQueenNest || JavaBot.knowledge.timerTryQueenNest == 0) {
                this.chosenForQueenNest = 0;
            } else if (this.buildPlace.x == -1) {
                this.buildPlace = JavaBot.getBuildTile(this.unit.getID(), UnitType.UnitTypes.Zerg_Queens_Nest.ordinal(), this.base.posX, this.base.posY);
            } else {
                if (Operators.distance(this.posX, this.posY, this.buildPlace.x * 32, this.buildPlace.y * 32) < 100 || this.unit.isConstructing()) {
                    this.base.timerTryQueenNest = 300;
                    JavaBot.knowledge.timerTryQueenNest = 300;
                    JavaBot.requestsManager.requestRessources(150, 100);
                }
                if (JavaBot.repartition.getQueenNestMinerals() >= 150 && JavaBot.knowledge.realGas >= 100) {
                    BwapiCallsManager.build(this.unit.getID(), this.buildPlace.x, this.buildPlace.y, UnitType.UnitTypes.Zerg_Queens_Nest.ordinal());
                } else {
                    BwapiCallsManager.move(this.unit.getID(), this.buildPlace.x * 32, this.buildPlace.y * 32);
                }
            }
        } else if (this.chosenForSpire != 0) {
            if (this.base.nbSpire > 0 || this.base.nbGreatSpire > 0 || this.base.timerTrySpire == 0 || !this.base.requestSpire) {
                this.chosenForSpire = 0;
            } else if (this.buildPlace.x == -1) {
                this.buildPlace = JavaBot.getBuildTile(this.unit.getID(), UnitType.UnitTypes.Zerg_Spire.ordinal(), this.base.posX, this.base.posY);
            } else {
                if (Operators.distance(this.posX, this.posY, this.buildPlace.x * 32, this.buildPlace.y * 32) < 50 || this.unit.isConstructing()) {
                    this.base.timerTrySpire = 200;
                    JavaBot.knowledge.timerTrySpire = 200;
                    JavaBot.requestsManager.requestRessources(200, 150);
                }
                if (JavaBot.repartition.getSpireMinerals() >= 200 && JavaBot.knowledge.realGas >= 150) {
                    BwapiCallsManager.build(this.unit.getID(), this.buildPlace.x, this.buildPlace.y, UnitType.UnitTypes.Zerg_Spire.ordinal());
                } else {
                    BwapiCallsManager.move(this.unit.getID(), this.buildPlace.x * 32, this.buildPlace.y * 32);
                }
            }
        } else if (this.chosenForCreep != 0) {
            if (this.base.nbCreepColony + this.base.nbSporeColony + this.base.nbSunkenColony >= 3 || this.base.timerTryCreep == 0) {
                this.chosenForCreep = 0;
                BwapiCallsManager.stop(this.unit.getID());
            } else if (this.buildPlace.x == -1) {
                this.buildPlace = JavaBot.getBuildTile(this.unit.getID(), UnitType.UnitTypes.Zerg_Creep_Colony.ordinal(), this.base.posX, this.base.posY);
            } else {
                if (Operators.distance(this.posX, this.posY, this.buildPlace.x * 32, this.buildPlace.y * 32) < 50 || this.unit.isConstructing()) {
                    this.base.timerTryCreep = 200;
                    JavaBot.requestsManager.requestRessources(75, 0);
                }
                if (JavaBot.repartition.getCreepMinerals() >= 75) {
                    BwapiCallsManager.build(this.unit.getID(), this.buildPlace.x, this.buildPlace.y, UnitType.UnitTypes.Zerg_Creep_Colony.ordinal());
                } else {
                    BwapiCallsManager.move(this.unit.getID(), this.buildPlace.x * 32, this.buildPlace.y * 32);
                }
            }
        } else if (this.chosenForEvo != 0) {
            if (JavaBot.strategy.nbEvoChamberTotal > 0 || JavaBot.knowledge.timerTryEvo == 0) {
                this.chosenForEvo = 0;
                BwapiCallsManager.stop(this.unit.getID());
            } else if (this.buildPlace.x == -1) {
                this.buildPlace = JavaBot.getBuildTile(this.unit.getID(), UnitType.UnitTypes.Zerg_Evolution_Chamber.ordinal(), this.base.posX, this.base.posY);
            } else {
                if (Operators.distance(this.posX, this.posY, this.buildPlace.x * 32, this.buildPlace.y * 32) < 50 || this.unit.isConstructing()) {
                    JavaBot.knowledge.timerTryEvo = 50;
                }
                if (JavaBot.repartition.getEvoMinerals() >= 75) {
                    BwapiCallsManager.build(this.unit.getID(), this.buildPlace.x, this.buildPlace.y, UnitType.UnitTypes.Zerg_Evolution_Chamber.ordinal());
                } else {
                    BwapiCallsManager.move(this.unit.getID(), this.buildPlace.x * 32, this.buildPlace.y * 32);
                }
            }
        } else if (this.unit.isIdle()) {
            this.updateIdle();
        }
        switch (this.state) {
            case IN_BURROW: {
                this.updateInBurrow();
                break;
            }
            case UN_BURROW: {
                this.updateUnBurrow();
                break;
            }
            case BURROWED: {
                this.updateBurrowed();
                break;
            }
            case NORMAL: {
                this.updateNormal();
                break;
            }
            case ATTACKING: {
                this.updateAttacking();
                break;
            }
        }
        this.oldHp = this.unit.getHitPoints();
        if (!this.unit.isBurrowed() && this.timerInaccessible > 0) {
            --this.timerInaccessible;
        }
        if (this.timerAttack > 0) {
            --this.timerAttack;
        }
    }

    private void goToState(DroneState s, int transitionTime) {
        this.state = s;
        this.transitionStates = transitionTime;
    }

    private boolean mustBurrow() {
        if (Tech.burrow != 2) {
            return false;
        }
        return this.nearbyGroundEnemy(this.safeMarge) && this.unit.getHitPoints() < 40;
    }

    private void updateAttacking() {
        if (this.mustBurrow()) {
            this.goToState(DroneState.IN_BURROW, 0);
        } else if (this.timerAttack == 0 && !this.unit.isAttacking()) {
            this.mineClosestmineral();
            this.goToState(DroneState.NORMAL, 0);
        }
    }

    private void updateNormal() {
        if (this.mustBurrow()) {
            this.goToState(DroneState.IN_BURROW, 0);
        } else if (this.oldHp > this.unit.getHitPoints() && !this.unit.isAttacking() && this.timerAttack == 0 && BwapiCallsManager.attack(this.unit.getID(), (int)((double)this.base.posX + Math.random() * 150.0 - 75.0), (int)((double)this.base.posY + Math.random() * 150.0 - 75.0))) {
            this.timerAttack = 200;
            this.goToState(DroneState.ATTACKING, 0);
        }
    }

    private void updateUnBurrow() {
        if (this.countDontAct == 0 && BwapiCallsManager.useTech(this.unit.getID(), TechType.TechTypes.Burrowing.ordinal())) {
            this.countDontAct = 100;
        }
        if (!this.unit.isBurrowed()) {
            this.goToState(DroneState.NORMAL, 10);
            this.countDontAct = 10;
        }
    }

    private void updateBurrowed() {
        if (!this.unit.isBurrowed()) {
            this.goToState(DroneState.NORMAL, 0);
        } else if (!this.nearbyGroundEnemy(this.safeMarge)) {
            this.goToState(DroneState.UN_BURROW, 0);
            return;
        }
    }

    private void updateInBurrow() {
        if (this.countDontAct == 0 && BwapiCallsManager.useTech(this.unit.getID(), TechType.TechTypes.Burrowing.ordinal())) {
            this.countDontAct = 100;
        }
        if (this.unit.isBurrowed()) {
            this.countDontAct = 10;
            this.goToState(DroneState.BURROWED, 10);
        }
    }

    private void updateRebuild() {
        this.base.timerRebuild = 10;
        if (this.bestExpand == null || this.bestExpand.state == BaseManager.BaseState.FRIENDLY) {
            this.chosenForRebuild = 0;
            if (this.friendlyBase != null) {
                BwapiCallsManager.move(this.unit.getID(), this.friendlyBase.posX, this.friendlyBase.posY);
            }
        }
        Point point = this.buildPlace = this.bestExpand.basePlanner.potentialHatchery != null ? this.bestExpand.basePlanner.potentialHatchery : JavaBot.getBuildTile(this.unit.getID(), UnitType.UnitTypes.Zerg_Hatchery.ordinal(), this.bestExpand.posX, this.bestExpand.posY);
        if (Operators.distance(this.posX, this.posY, this.buildPlace.x * 32 + 32 + 32, this.buildPlace.y * 32 + 32 + 16) >= 40) {
            BwapiCallsManager.move(this.unit.getID(), this.buildPlace.x * 32 + 64, this.buildPlace.y * 32 + 32 + 16);
        }
        if (JavaBot.knowledge.realMinerals >= 300) {
            BwapiCallsManager.build(this.unit.getID(), this.buildPlace.x, this.buildPlace.y, UnitType.UnitTypes.Zerg_Hatchery.ordinal());
        }
    }

    private void updateExpand() {
        if (this.bestExpand.nbDrones >= 2 && Operators.distance(this.bestExpand, this.unit) > 50 || this.bestExpand.isIsland || this.bestExpand.state == BaseManager.BaseState.FRIENDLY || this.bestExpand.state == BaseManager.BaseState.ENNEMY) {
            if (this.friendlyBase != null) {
                BwapiCallsManager.move(this.unit.getID(), this.friendlyBase.posX, this.friendlyBase.posY);
            }
            this.chosenForExpand = 0;
            JavaBot.knowledge.timerTryExpand = 50;
        }
        if (this.chosenForExpand == 1 || this.chosenForExpand == 2) {
            if (this.chosenForExpand == 1) {
                this.chosenForExpand = 2;
                this.timerInaccessible = this.timeUntilInaccessible;
                this.minDistance = Operators.distance(this.bestExpand, this.unit);
            }
            BwapiCallsManager.move(this.unit.getID(), this.bestExpand.posX, this.bestExpand.posY);
            if ((this.bestExpand.posX - this.posX) * (this.bestExpand.posX - this.posX) + (this.bestExpand.posY - this.posY) * (this.bestExpand.posY - this.posY) < 100) {
                this.chosenForExpand = 3;
            }
            if (this.timerInaccessible == 0) {
                if (this.friendlyBase != null) {
                    BwapiCallsManager.move(this.unit.getID(), this.friendlyBase.posX, this.friendlyBase.posY);
                }
                this.chosenForExpand = 0;
                this.bestExpand.inaccessible = true;
                this.bestExpand.safeExpandScore = (int)((double)this.bestExpand.safeExpandScore * 0.8);
                JavaBot.knowledge.timerTryExpand = 20;
            }
        }
        if (this.unit.isIdle() && this.chosenForExpand == 3) {
            this.timerInaccessible = this.timeUntilInaccessible;
            if (this.bestExpand.nbHatcheries > 0) {
                if (this.friendlyBase != null && BwapiCallsManager.move(this.unit.getID(), this.friendlyBase.posX, this.friendlyBase.posY)) {
                    this.chosenForExpand = 0;
                }
            } else if (this.buildPlace.x == -1) {
                this.buildPlace = this.bestExpand.basePlanner.potentialHatchery != null ? this.bestExpand.basePlanner.potentialHatchery : JavaBot.getBuildTile(this.unit.getID(), UnitType.UnitTypes.Zerg_Hatchery.ordinal(), this.bestExpand.posX, this.bestExpand.posY);
            } else {
                if (Operators.distance(this.posX, this.posY, this.buildPlace.x * 32, this.buildPlace.y * 32) < 300) {
                    JavaBot.requestsManager.requestRessources(300, 0);
                    ++JavaBot.knowledge.timerTryExpand;
                }
                if (JavaBot.knowledge.realMinerals >= 300) {
                    BwapiCallsManager.build(this.unit.getID(), this.buildPlace.x, this.buildPlace.y, UnitType.UnitTypes.Zerg_Hatchery.ordinal());
                }
            }
        }
    }

    public void updateIsInBase() {
        Tile t;
        int distMax = Integer.MAX_VALUE;
        BaseManager bestBase = null;
        int distMaxFriend = Integer.MAX_VALUE;
        BaseManager bestBaseFriend = null;
        BaseManager bestBaseExpand = null;
        int bestSafescore = 0;
        for (BaseManager manager : JavaBot.bases) {
            int dist = (manager.posX - this.posX) * (manager.posX - this.posX) + (manager.posY - this.posY) * (manager.posY - this.posY);
            if (dist < distMax) {
                distMax = dist;
                bestBase = manager;
            }
            if (manager.state == BaseManager.BaseState.FRIENDLY && dist < distMaxFriend) {
                distMaxFriend = dist;
                bestBaseFriend = manager;
            }
            if (this.chosenForExpand != 0 || manager.isIsland || manager.state != BaseManager.BaseState.UNKNOWN || manager.timerRebuild != 0 || bestSafescore + (manager.inaccessible ? 1200 : 0) >= manager.safeExpandScore && !(Math.random() < (double)0.03f) || this.bestExpand != null && !(Math.random() < (double)0.85f)) continue;
            bestBaseExpand = manager;
            bestSafescore = manager.safeExpandScore;
        }
        if (bestBase != null) {
            this.base = bestBase;
            if (this.base != this.oldBase) {
                this.base.dronesMap.put(this.unit.getID(), this.unit);
                if (this.oldBase != null) {
                    this.oldBase.dronesMap.remove(this.unit.getID());
                }
            }
            this.oldBase = this.base;
        }
        if (bestBaseFriend != null) {
            this.friendlyBase = bestBaseFriend;
        }
        if (this.chosenForExpand == 0 && this.chosenForRebuild == 0) {
            this.bestExpand = bestBaseExpand;
        }
        if (this.bestExpand != null && this.chosenForExpand != 0 && (t = TileGraph.getTile(this.posY / 32, this.posX / 32)) != null && t.DroneVisited == 0) {
            this.timerInaccessible = this.timeUntilInaccessible;
            t.DroneVisited = 600;
        }
    }

    public void updateIdle() {
        this.mineClosestmineral();
    }

    public void mineClosestmineral() {
        int closestId = -1;
        double closestDist = 9.9999999E7;
        int mineralsID = UnitType.UnitTypes.Resource_Mineral_Field.ordinal();
        for (Unit neu : this.bwapi.getNeutralUnits()) {
            if (neu.getTypeID() != mineralsID) continue;
            int a = neu.getX() - this.unit.getX();
            int b = neu.getY() - this.unit.getY();
            double distance = Math.sqrt(a * a + b * b);
            if (closestId != -1 && !(distance < closestDist)) continue;
            closestDist = distance;
            closestId = neu.getID();
        }
        if (closestId != -1) {
            BwapiCallsManager.rightClick(this.unit.getID(), closestId);
        }
    }

    public boolean free() {
        return !this.unit.isCarryingMinerals() && !this.unit.isGatheringGas() && this.chosenForExpand == 0 && this.chosenForRebuild == 0 && this.chosenForPool == 0 && this.chosenForMacro == 0 && this.chosenForExtractor == 0 && this.chosenForHydraDen == 0 && this.chosenForCreep == 0 && this.chosenForQueenNest == 0 && this.chosenForSpire == 0 && this.chosenForEvo == 0 && !this.unit.isConstructing() && this.state == DroneState.NORMAL;
    }

    @Override
    public void drawDebug() {
        if (this.chosenForExpand != 0) {
            this.bwapi.drawText(this.unit.getX() - 10, this.unit.getY() - 1, "EXPAND " + this.timerInaccessible, false);
        } else if (this.chosenForRebuild != 0) {
            this.bwapi.drawText(this.unit.getX() - 10, this.unit.getY() - 1, "REBUILD", false);
        } else if (this.chosenForMacro != 0) {
            this.bwapi.drawText(this.unit.getX() - 10, this.unit.getY() - 1, "MACRO " + this.timerInaccessible, false);
        } else if (this.chosenForPool != 0) {
            this.bwapi.drawText(this.unit.getX() - 10, this.unit.getY() - 1, "POOL", false);
        } else if (this.chosenForExtractor != 0) {
            this.bwapi.drawText(this.unit.getX() - 10, this.unit.getY() - 1, "EXTRACTOR", false);
        } else if (this.chosenForHydraDen != 0) {
            this.bwapi.drawText(this.unit.getX() - 10, this.unit.getY() - 1, "HYDRA", false);
        } else if (this.chosenForQueenNest != 0) {
            this.bwapi.drawText(this.unit.getX() - 10, this.unit.getY() - 1, "QUEENnest", false);
        } else if (this.chosenForSpire != 0) {
            this.bwapi.drawText(this.unit.getX() - 10, this.unit.getY() - 1, "SPIRE", false);
        } else if (this.chosenForCreep != 0) {
            this.bwapi.drawText(this.unit.getX() - 10, this.unit.getY() - 1, "CREEP", false);
        } else if (this.chosenForEvo != 0) {
            this.bwapi.drawText(this.unit.getX() - 10, this.unit.getY() - 1, "EVO", false);
        }
        if (this.bestExpand != null && (this.chosenForExpand != 0 || this.chosenForRebuild != 0)) {
            this.bwapi.drawLine(this.posX, this.posY, this.bestExpand.posX, this.bestExpand.posY, 74, false);
            if (Tech.burrow == 2) {
                if (this.unit.isBurrowed()) {
                    this.bwapi.drawCircle(this.posX, this.posY, this.radiusDetectUnburrow, 111, false, false);
                } else {
                    this.bwapi.drawCircle(this.posX, this.posY, this.radiusDetectBurrow, 135, false, false);
                }
            }
        }
    }

    public static enum DroneState {
        NORMAL,
        ATTACKING,
        IN_BURROW,
        UN_BURROW,
        BURROWED;

    }
}

