/*
 * Decompiled with CFR 0.152.
 */
package javabot.managers;

import java.util.ArrayList;
import java.util.HashMap;
import javabot.JNIBWAPI;
import javabot.JavaBot;
import javabot.knowledge.BasePlanner;
import javabot.knowledge.Strategy;
import javabot.knowledge.Tech;
import javabot.managers.EnemyBuildingManager;
import javabot.model.BaseLocation;
import javabot.model.Map;
import javabot.model.Unit;
import javabot.operators.Operators;
import javabot.types.UnitType;

public class BaseManager {
    int size = 350;
    BaseLocation baseLocation;
    public int posX;
    public int posY;
    int tileX;
    int tileY;
    boolean isIsland;
    JNIBWAPI bwapi;
    public BaseState state;
    boolean beingBuilt;
    public boolean possibleEnemy;
    public boolean inaccessible;
    public boolean hasGas;
    int dronesOnMinerals;
    int dronesOnGas;
    int timerGoOnGas;
    int timerGoOnMinerals;
    int nbDronesWantedOnGas;
    int safeExpandScore;
    public int timerTryExtractor;
    public int timerTryHydraDen;
    public int timerTryCreep;
    public int timerTryQueenNest;
    public int timerTrySpire;
    public int timerTryMacro;
    public int timerChangeRatio;
    public int timerRebuild;
    public boolean requestExtractor;
    public boolean requestHydraDen;
    public boolean requestCreep;
    public boolean requestQueenNest;
    public boolean requestLair;
    public boolean requestSpire;
    public boolean requestHive;
    int nbHatcheries;
    int nbExtractor;
    int nbHydraDen;
    int nbCreepColony;
    int nbSunkenColony;
    int nbSporeColony;
    int nbQueenNest;
    int nbSpire;
    int nbGreatSpire;
    public int nbMinerals;
    public int nbDronesIdeal;
    public Unit extractor;
    ArrayList<Unit> buildings;
    public HashMap<Integer, Unit> dronesMap;
    int nbDrones;
    public BasePlanner basePlanner;
    public int blockLair;

    public BaseManager(BaseLocation base) {
        this.baseLocation = base;
        this.posX = base.getX();
        this.posY = base.getY();
        this.tileX = base.getTx();
        this.tileY = base.getTy();
        this.basePlanner = new BasePlanner(this.posX, this.posY);
        this.isIsland = base.isIsland();
        this.bwapi = JavaBot.bwapi;
        this.buildings = new ArrayList();
        this.dronesMap = new HashMap();
        this.nbDrones = 0;
        this.state = BaseState.UNKNOWN;
        this.possibleEnemy = base.isStartLocation();
        this.inaccessible = false;
        this.hasGas = false;
        this.timerGoOnGas = 0;
        this.timerGoOnMinerals = 0;
        this.timerTryExtractor = 0;
        this.timerTryHydraDen = 0;
        this.timerTryCreep = 0;
        this.timerTryQueenNest = 0;
        this.timerTrySpire = 0;
        this.timerTryMacro = 0;
        this.timerChangeRatio = 0;
        this.timerRebuild = 3;
        this.blockLair = 1;
        this.dronesOnMinerals = 0;
        this.dronesOnGas = 0;
        this.nbDronesWantedOnGas = 0;
        this.safeExpandScore = 0;
        this.nbHatcheries = 0;
        this.nbExtractor = 0;
        this.nbHydraDen = 0;
        this.nbCreepColony = 0;
        this.nbSunkenColony = 0;
        this.nbSporeColony = 0;
        this.requestExtractor = false;
        this.requestHydraDen = false;
        this.requestCreep = false;
        this.requestQueenNest = false;
        this.requestLair = false;
        this.requestSpire = false;
        this.requestHive = false;
        this.extractor = null;
        this.nbMinerals = 0;
        this.nbDronesIdeal = 0;
    }

    public BaseManager(int x, int y) {
        this.baseLocation = null;
        this.posX = x;
        this.posY = y;
        this.tileX = x / 32;
        this.tileY = y / 32;
        this.basePlanner = new BasePlanner(this.posX, this.posY);
        this.isIsland = true;
        this.bwapi = JavaBot.bwapi;
        this.buildings = new ArrayList();
        this.dronesMap = new HashMap();
        this.nbDrones = 0;
        this.state = BaseState.UNKNOWN;
        this.possibleEnemy = false;
        this.inaccessible = false;
        this.hasGas = false;
        this.timerGoOnGas = 0;
        this.timerGoOnMinerals = 0;
        this.timerTryExtractor = 0;
        this.timerTryHydraDen = 0;
        this.timerTryCreep = 0;
        this.timerTryQueenNest = 0;
        this.timerTrySpire = 0;
        this.timerTryMacro = 0;
        this.dronesOnMinerals = 0;
        this.dronesOnGas = 0;
        this.nbDronesWantedOnGas = 0;
        this.safeExpandScore = 0;
        this.nbHatcheries = 0;
        this.nbExtractor = 0;
        this.nbHydraDen = 0;
        this.nbCreepColony = 0;
        this.nbSunkenColony = 0;
        this.nbSporeColony = 0;
        this.requestExtractor = false;
        this.requestHydraDen = false;
        this.requestCreep = false;
        this.requestQueenNest = false;
        this.requestLair = false;
        this.requestSpire = false;
        this.requestHive = false;
        this.extractor = null;
        this.nbMinerals = 0;
        this.nbDronesIdeal = 0;
    }

    public void update() {
        this.basePlanner.update();
        this.nbHatcheries = 0;
        this.nbExtractor = 0;
        this.nbHydraDen = 0;
        this.nbCreepColony = 0;
        this.nbSunkenColony = 0;
        this.nbSporeColony = 0;
        this.nbSpire = 0;
        this.nbGreatSpire = 0;
        this.dronesOnMinerals = 0;
        this.dronesOnGas = 0;
        this.nbDrones = this.dronesMap.size();
        this.extractor = null;
        for (Unit u : this.buildings) {
            if (u.getTypeID() == UnitType.UnitTypes.Zerg_Hatchery.ordinal() || u.getTypeID() == UnitType.UnitTypes.Zerg_Lair.ordinal() || u.getTypeID() == UnitType.UnitTypes.Zerg_Hive.ordinal()) {
                ++this.nbHatcheries;
            }
            if (u.getTypeID() == UnitType.UnitTypes.Zerg_Extractor.ordinal()) {
                ++this.nbExtractor;
                if (u.getRemainingBuildTimer() == 0) {
                    this.extractor = u;
                }
            }
            if (u.getTypeID() == UnitType.UnitTypes.Zerg_Hydralisk_Den.ordinal()) {
                ++this.nbHydraDen;
            }
            if (u.getTypeID() == UnitType.UnitTypes.Zerg_Creep_Colony.ordinal()) {
                ++this.nbCreepColony;
            }
            if (u.getTypeID() == UnitType.UnitTypes.Zerg_Sunken_Colony.ordinal()) {
                ++this.nbSunkenColony;
            }
            if (u.getTypeID() == UnitType.UnitTypes.Zerg_Spore_Colony.ordinal()) {
                ++this.nbSporeColony;
            }
            if (u.getTypeID() == UnitType.UnitTypes.Zerg_Queens_Nest.ordinal()) {
                ++this.nbQueenNest;
            }
            if (u.getTypeID() == UnitType.UnitTypes.Zerg_Spire.ordinal()) {
                ++this.nbSpire;
            }
            if (u.getTypeID() != UnitType.UnitTypes.Zerg_Greater_Spire.ordinal()) continue;
            ++this.nbGreatSpire;
        }
        if (this.state == BaseState.ENNEMY) {
            this.state = BaseState.UNKNOWN;
        }
        for (EnemyBuildingManager b : JavaBot.enemyBuildingsManager) {
            if (Operators.distance(this, b.unit) >= this.size) continue;
            this.state = BaseState.ENNEMY;
            break;
        }
        if (this.state != BaseState.FRIENDLY && this.nbHatcheries > 0) {
            this.state = BaseState.FRIENDLY;
            this.inaccessible = false;
        }
        this.nbMinerals = 0;
        if (this.state == BaseState.FRIENDLY) {
            for (Unit u : this.bwapi.getNeutralUnits()) {
                if (!this.hasGas && u.getTypeID() == UnitType.UnitTypes.Resource_Vespene_Geyser.ordinal() && Operators.distance(this, u) < 350) {
                    this.hasGas = true;
                }
                if (u.getTypeID() != UnitType.UnitTypes.Resource_Mineral_Field.ordinal() || Operators.distance(this, u) >= 350) continue;
                ++this.nbMinerals;
            }
        }
        this.nbDronesIdeal = (int)(1.8f * (float)this.nbMinerals + (float)(this.hasGas ? 3 : 0));
        if (this.state == BaseState.FRIENDLY && this.nbHatcheries == 0) {
            this.state = BaseState.UNKNOWN;
        }
        for (Unit u : this.dronesMap.values()) {
            if (u.isGatheringMinerals()) {
                ++this.dronesOnMinerals;
            }
            if (!u.isGatheringGas()) continue;
            ++this.dronesOnGas;
        }
        this.requestExtractor = !(!this.hasGas || JavaBot.strategy.nbHatcheryTotal < 3 && JavaBot.currFrame < 3500 || JavaBot.strategy.nbPoolTotal < 1 || this.nbExtractor != 0 || !JavaBot.strategy.needMoreGas || this.nbHatcheries < 1 || this.nbDrones < 5 && !((double)JavaBot.strategy.nbDronesTotal >= (double)JavaBot.strategy.idealNbDrones * 0.75) || !JavaBot.knowledge.okExtractors);
        this.requestHydraDen = JavaBot.strategy.nbHydraTotal == 0 && (JavaBot.strategy.nbHatcheryTotal >= 3 || JavaBot.currFrame >= 4000) && JavaBot.strategy.nbPoolTotal >= 1 && this.nbExtractor >= 1 && Tech.burrow != 0 && this.nbHydraDen == 0 && this.nbHatcheries >= 1;
        this.requestQueenNest = !(JavaBot.strategy.nbQueenNestTotal != 0 || JavaBot.knowledge.currentBuildings[Operators.iterLair] < 1 && JavaBot.strategy.nbHiveTotal <= 0 || this.nbHatcheries < 1 || this.nbDrones < 5 && !((double)JavaBot.strategy.nbDronesTotal >= (double)JavaBot.strategy.idealNbDrones * 0.75));
        this.requestSpire = !(JavaBot.strategy.nbSpireTotal + JavaBot.strategy.nbGreatSpireTotal != 0 || JavaBot.strategy.nbQueenNestTotal <= 0 || JavaBot.knowledge.currentBuildings[Operators.iterLair] <= 0 && JavaBot.strategy.nbHiveTotal <= 0 || this.nbSpire != 0 || this.nbHatcheries < 1 || this.nbDrones < 5 && !((double)JavaBot.strategy.nbDronesTotal >= (double)JavaBot.strategy.idealNbDrones * 0.75) || JavaBot.strategy.nbMutalisksTotal + JavaBot.strategy.nbGuardiansTotal + JavaBot.strategy.nbDevourersTotal >= JavaBot.strategy.idealNbMutalisks + JavaBot.strategy.idealNbGuardians + JavaBot.strategy.idealNbDevourers);
        this.requestCreep = this.timerTryCreep == 0 && JavaBot.strategy.nbPoolTotal >= 1 && this.nbCreepColony + this.nbSunkenColony + this.nbSporeColony <= 0 && this.nbHatcheries >= 1 && (this.nbDrones >= 4 || (double)JavaBot.strategy.nbDronesTotal >= (double)JavaBot.strategy.idealNbDrones * 0.75) && (JavaBot.strategy.nbHatcheryTotal >= 3 || JavaBot.strategy.nbOverlordsTotal >= 2 || JavaBot.strategy.enemyRace == Strategy.RaceType.Zerg) || JavaBot.strategy.nbPoolTotal >= 1 && this.nbCreepColony + this.nbSunkenColony + this.nbSporeColony < 2 && JavaBot.strategy.nbHatcheryTotal >= 5 && (this.nbDrones >= 6 || (double)JavaBot.strategy.nbDronesTotal >= (double)JavaBot.strategy.idealNbDrones * 0.75) || JavaBot.strategy.nbEvoChamberTotal >= 1 && this.nbCreepColony + this.nbSunkenColony + this.nbSporeColony < 3 && JavaBot.strategy.nbHatcheryTotal >= 5 && (this.nbDrones >= 6 || (double)JavaBot.strategy.nbDronesTotal >= (double)JavaBot.strategy.idealNbDrones * 0.75);
        this.requestLair = JavaBot.strategy.nbPoolTotal >= 1 && this.nbCreepColony + this.nbSunkenColony > 0 && this.nbHatcheries >= 1 && JavaBot.strategy.nbHydraTotal >= 1 && this.nbCreepColony + this.nbSunkenColony > 0 && (this.nbDrones >= 5 || (double)JavaBot.strategy.nbDronesTotal >= (double)JavaBot.strategy.idealNbDrones * 0.75) && JavaBot.knowledge.currentBuildings[Operators.iterLair] == 0 && JavaBot.knowledge.warpingBuildings[Operators.iterLair] == 0 && JavaBot.knowledge.currentBuildings[Operators.iterHive] == 0 && JavaBot.knowledge.warpingBuildings[Operators.iterHive] == 0;
        this.requestHive = !(JavaBot.knowledge.currentBuildings[Operators.iterQueenNest] < 1 || this.nbCreepColony + this.nbSunkenColony <= 0 || this.nbHatcheries < 1 || JavaBot.strategy.nbQueensTotal < 3 && Tech.broodlings != 1 || this.nbDrones < 5 && !((double)JavaBot.strategy.nbDronesTotal >= (double)JavaBot.strategy.idealNbDrones * 0.75) || JavaBot.strategy.nbSpireTotal < 1 || JavaBot.knowledge.currentBuildings[Operators.iterHive] != 0 || JavaBot.knowledge.warpingBuildings[Operators.iterHive] != 0);
        if (this.nbExtractor > 0 && this.timerChangeRatio == 0) {
            if (this.nbDronesWantedOnGas < 3 && JavaBot.strategy.needMoreGas) {
                ++this.nbDronesWantedOnGas;
                this.timerChangeRatio = 100;
            }
            if (this.nbDronesWantedOnGas > 0 && JavaBot.strategy.needMoreMinerals) {
                --this.nbDronesWantedOnGas;
                this.timerChangeRatio = 100;
            }
        }
        if (this.timerTryExtractor > 0) {
            --this.timerTryExtractor;
        }
        if (this.timerTryHydraDen > 0) {
            --this.timerTryHydraDen;
        }
        if (this.timerTryCreep > 0) {
            --this.timerTryCreep;
        }
        if (this.timerTrySpire > 0) {
            --this.timerTrySpire;
        }
        if (this.timerTryMacro > 0) {
            --this.timerTryMacro;
        }
        if (this.timerTryQueenNest > 0) {
            --this.timerTryQueenNest;
        }
        if (this.timerChangeRatio > 0) {
            --this.timerChangeRatio;
        }
        if (this.timerRebuild > 0) {
            --this.timerRebuild;
        }
        if (this.blockLair > 0) {
            --this.blockLair;
        }
        if (this.timerGoOnGas > 0) {
            --this.timerGoOnGas;
        }
        if (this.timerGoOnMinerals > 0) {
            --this.timerGoOnMinerals;
        }
        if (this.state == BaseState.FRIENDLY) {
            this.possibleEnemy = false;
        }
    }

    public static void setScoresExpand(ArrayList<BaseManager> bases, ArrayList<BaseLocation> locations, int homePositionX, int homePositionY, JNIBWAPI bwapi2) {
        Map map = bwapi2.getMap();
        for (BaseManager base : bases) {
            base.safeExpandScore = 0;
            for (BaseLocation baseLoc : locations) {
                if (!baseLoc.isStartLocation()) continue;
                if (baseLoc.getX() == homePositionX && baseLoc.getY() == homePositionY) {
                    base.safeExpandScore = (int)((float)base.safeExpandScore + (float)Operators.distance(base.posX, base.posY, baseLoc.getX(), baseLoc.getY()) * 0.7f);
                    continue;
                }
                base.safeExpandScore += Operators.distance(base.posX, base.posY, baseLoc.getX(), baseLoc.getY());
            }
            if (base.possibleEnemy) {
                base.safeExpandScore = (int)((float)base.safeExpandScore * 0.6f);
            }
            if (Operators.distance(base.posX, base.posY, homePositionX, homePositionY) >= 1500) continue;
            base.safeExpandScore = (int)((float)base.safeExpandScore * 0.9f);
        }
    }

    public void drawDebug() {
        if (this.state == BaseState.FRIENDLY) {
            this.bwapi.drawCircle(this.posX, this.posY, 350, 117, false, false);
        }
        if (this.state == BaseState.ENNEMY) {
            this.bwapi.drawCircle(this.posX, this.posY, 350, 111, false, false);
        }
        if (this.state == BaseState.UNKNOWN) {
            this.bwapi.drawCircle(this.posX, this.posY, 350, 74, false, false);
        }
        if (this.isIsland) {
            this.bwapi.drawText(this.posX, this.posY - 15, "Island", false);
        }
        if (this.inaccessible) {
            this.bwapi.drawText(this.posX, this.posY - 20, "INACCESSIBLE", false);
        }
        this.bwapi.drawText(this.posX, this.posY - 30, "Nb buildings: " + this.buildings.size(), false);
        this.bwapi.drawText(this.posX, this.posY - 40, "Nb drones: " + this.nbDrones, false);
        this.bwapi.drawText(this.posX, this.posY - 50, "NbHatcheries: " + this.nbHatcheries, false);
        this.bwapi.drawText(this.posX, this.posY - 60, "DronesMineral: " + this.dronesOnMinerals, false);
        this.bwapi.drawText(this.posX, this.posY - 70, "DronesGas: " + this.dronesOnGas, false);
    }

    public static enum BaseState {
        FRIENDLY,
        ENNEMY,
        CONSTRUCTING,
        REQUESTED,
        UNKNOWN;

    }
}

