/*
 * Decompiled with CFR 0.152.
 */
package javabot.knowledge;

import java.awt.Point;
import javabot.JNIBWAPI;
import javabot.knowledge.Tile;
import javabot.model.Map;
import javabot.model.Unit;
import javabot.operators.Operators;
import javabot.types.UnitType;

public class TileGraph {
    public static int sizeX;
    public static int sizeY;
    public static JNIBWAPI bwapi;
    public static Map map;
    public static Tile[][] tiles;

    public static void init(JNIBWAPI bw, int homePositionX, int homePositionY) {
        Tile t;
        int j;
        bwapi = bw;
        map = bwapi.getMap();
        sizeX = map.getWidth();
        sizeY = map.getHeight();
        tiles = new Tile[sizeY][sizeX];
        int i = 0;
        while (i < sizeY) {
            j = 0;
            while (j < sizeX) {
                t = new Tile(j, i);
                t.buildingValue = 0;
                if (map.isBuildable(j, i)) {
                    t.buildingValue = 1;
                }
                TileGraph.tiles[i][j] = t;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < sizeY) {
            j = 0;
            while (j < 10) {
                t = tiles[i][j];
                t.BordersMap = 100 - 10 * j;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < sizeY) {
            j = sizeX - 11;
            while (j < sizeX) {
                t = tiles[i][j];
                t.BordersMap = 10 * (j - sizeX + 11);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 10) {
            j = 5;
            while (j < sizeX - 5) {
                t = tiles[i][j];
                t.BordersMap = 100 - 10 * i;
                ++j;
            }
            ++i;
        }
        i = sizeY - 11;
        while (i < sizeY) {
            j = 5;
            while (j < sizeX - 5) {
                t = tiles[i][j];
                t.BordersMap = 10 * (i - sizeY + 11);
                ++j;
            }
            ++i;
        }
    }

    public static void update() {
        int i = 0;
        while (i < sizeY) {
            int j = 0;
            while (j < sizeX) {
                Tile t = tiles[i][j];
                t.update();
                ++j;
            }
            ++i;
        }
    }

    public static boolean OkPos(int i, int j) {
        return i >= 0 && j >= 0 && i < sizeY && j < sizeX;
    }

    public static void debug() {
        int i = 0;
        while (i < sizeY) {
            int j = 0;
            while (j < sizeX) {
                Tile t = tiles[i][j];
                t.debug();
                ++j;
            }
            ++i;
        }
    }

    public static void fillBuilding(Unit unit) {
        if (unit.getTypeID() == UnitType.UnitTypes.Zerg_Extractor.ordinal()) {
            return;
        }
        int tileX = unit.getTileX();
        int tileY = unit.getTileY();
        Point size = Operators.getSize(unit.getTypeID());
        int Y = tileY;
        while (Y < tileY + size.y) {
            if (Y >= 0 && Y < tiles.length) {
                int X = tileX;
                while (X < tileX + size.x) {
                    if (X >= 0 && X < tiles[0].length) {
                        TileGraph.tiles[Y][X].buildingValue = 2;
                    }
                    ++X;
                }
            }
            ++Y;
        }
    }

    public static Tile getTile(int Y, int X) {
        if (Y < 0 || Y >= tiles.length || X < 0 || X >= tiles[0].length) {
            return null;
        }
        return tiles[Y][X];
    }
}

