/*
 * Decompiled with CFR 0.152.
 */
package javabot.knowledge;

import java.awt.Point;
import java.util.ArrayList;
import javabot.JNIBWAPI;
import javabot.JavaBot;
import javabot.knowledge.TileGraph;
import javabot.managers.BuildingPlacer;
import javabot.model.ChokePoint;
import javabot.model.Map;
import javabot.model.Unit;
import javabot.operators.Operators;
import javabot.types.UnitType;

public class BasePlanner {
    public JNIBWAPI bwapi;
    public Map map;
    public int sizeX;
    public int sizeY;
    public int posX;
    public int posY;
    public int posTileX;
    public int posTileY;
    public ArrayList<ChokePoint> chokePoints;
    public Point potentialHatchery;
    public ArrayList<BuildingPlacer> potentialBuildings;
    public int timerReset;
    public int timerResetMax = 50;
    public int allowedRangePylon;
    public Point bestChokePoint;

    public BasePlanner(int homePositionX, int homePositionY) {
        this.posX = homePositionX;
        this.posY = homePositionY;
        this.posTileX = homePositionX / 32;
        this.posTileY = homePositionY / 32;
        this.bwapi = JavaBot.bwapi;
        this.map = this.bwapi.getMap();
        this.sizeX = TileGraph.sizeX;
        this.sizeY = TileGraph.sizeY;
        this.timerReset = this.timerResetMax;
        this.potentialBuildings = new ArrayList();
        this.potentialBuildings.add(new BuildingPlacer(UnitType.UnitTypes.Zerg_Hatchery.ordinal(), this.bwapi, "HATCH", this.posTileX, this.posTileY));
        this.potentialHatchery = null;
        this.redRessourceTiles();
    }

    public void redRessourceTiles() {
        for (Unit u : this.bwapi.getNeutralUnits()) {
            int jk;
            int bn;
            int j;
            int i;
            if (u.getTypeID() == UnitType.UnitTypes.Resource_Mineral_Field.ordinal() && Operators.distance(u, this.posX, this.posY) < 600) {
                i = u.getTileY();
                j = u.getTileX();
                bn = -3;
                while (bn <= 3) {
                    jk = -3;
                    while (jk <= 4) {
                        if (TileGraph.OkPos(i + bn, j + jk)) {
                            TileGraph.tiles[i + bn][j + jk].buildingValue = 4;
                        }
                        ++jk;
                    }
                    ++bn;
                }
                TileGraph.tiles[i][j].buildingValue = 3;
                TileGraph.tiles[i][j + 1].buildingValue = 3;
            }
            if (u.getTypeID() != UnitType.UnitTypes.Resource_Vespene_Geyser.ordinal() || Operators.distance(u, this.posX, this.posY) >= 600) continue;
            i = u.getTileY();
            j = u.getTileX();
            bn = -3;
            while (bn <= 4) {
                jk = -3;
                while (jk <= 6) {
                    if (TileGraph.OkPos(i + bn, j + jk)) {
                        TileGraph.tiles[i + bn][j + jk].buildingValue = 4;
                    }
                    ++jk;
                }
                ++bn;
            }
            int hj = 0;
            while (hj < 4) {
                jk = 0;
                while (jk < 2) {
                    TileGraph.tiles[i + jk][j + hj].buildingValue = 3;
                    ++jk;
                }
                ++hj;
            }
        }
    }

    public void update() {
        --this.timerReset;
        for (BuildingPlacer bPlacer : this.potentialBuildings) {
            if (this.timerReset == 0 || bPlacer.bestPlace == null || !this.OKposition(bPlacer.bestPlace, bPlacer.size, bPlacer.typeID == UnitType.UnitTypes.Zerg_Hatchery.ordinal())) {
                this.tryPlaceBuilding(bPlacer);
            }
            if (bPlacer.typeID != UnitType.UnitTypes.Zerg_Hatchery.ordinal()) continue;
            this.potentialHatchery = bPlacer.bestPlace;
        }
        if (this.timerReset <= 0) {
            this.timerReset = this.timerResetMax;
        }
    }

    private boolean OKposition(Point potentialBuilding, Point size, boolean hatch) {
        int Y = potentialBuilding.y;
        while (Y < potentialBuilding.y + size.y) {
            int X = potentialBuilding.x;
            while (X < potentialBuilding.x + size.x) {
                if (X < 0 || Y < 0 || X >= TileGraph.tiles[0].length || Y >= TileGraph.tiles.length) {
                    return false;
                }
                int tileValue = TileGraph.tiles[Y][X].buildingValue;
                if (tileValue != 1 && tileValue != 4 || hatch && tileValue == 4) {
                    return false;
                }
                ++X;
            }
            ++Y;
        }
        return true;
    }

    private void tryPlaceBuilding(BuildingPlacer bPlacer) {
        int startPosX = bPlacer.homePosTileX;
        int startPosY = bPlacer.homePosTileY;
        boolean hatch = false;
        int allowedRange = 40;
        if (bPlacer.typeID == UnitType.UnitTypes.Zerg_Hatchery.ordinal()) {
            allowedRange = 1;
            hatch = true;
            startPosX -= 2;
            --startPosY;
        }
        bPlacer.bestPlace = null;
        Point size = bPlacer.size;
        int i = 0;
        while (i < 5) {
            Point posTest = new Point((int)((double)startPosX + Math.random() * (double)(hatch ? i : 1) * (double)allowedRange * 2.0 - (double)((hatch ? i : 1) * allowedRange)), (int)((double)startPosY + Math.random() * (double)(hatch ? i : 1) * (double)allowedRange * 2.0 - (double)((hatch ? i : 1) * allowedRange)));
            if (this.OKposition(posTest, size, hatch)) {
                bPlacer.bestPlace = posTest;
                return;
            }
            ++i;
        }
    }

    public void debug() {
        for (BuildingPlacer bPlacer : this.potentialBuildings) {
            bPlacer.debug();
        }
    }
}

