/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.AIModule;
import bwapi.Game;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class Mirror {
    private Game game;
    private AIModule module = new AIModule();
    private FrameCallback frameCallback;
    private static final boolean EXTRACT_JAR = true;
    private static final String VERSION = "2_5";

    public Game getGame() {
        return this.game;
    }

    public AIModule getModule() {
        return this.module;
    }

    public native void startGame();

    private void update() {
        if (this.frameCallback != null) {
            this.frameCallback.update();
        }
    }

    static {
        Object object;
        String string2 = System.getProperty("os.arch");
        String[] stringArray = new String[]{"bwapi_bridge2_5", "libgmp-10", "libmpfr-4"};
        if (!string2.equals("x86")) {
            throw new UnsupportedOperationException("BWMirror API supports only x86 architecture.");
        }
        try {
            System.setProperty("java.library.path", ".");
            object = ClassLoader.class.getDeclaredField("sys_paths");
            ((Field)object).setAccessible(true);
            ((Field)object).set(null, null);
            String string3 = Mirror.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            String string4 = URLDecoder.decode(string3, "UTF-8");
            for (String string5 : stringArray) {
                String string6 = string5 + ".dll";
                if (new File(string6).exists()) continue;
                JarResources jarResources = new JarResources(string3);
                byte[] byArray = jarResources.getResource(string6);
                FileOutputStream fileOutputStream = new FileOutputStream(string6);
                fileOutputStream.write(byArray);
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            System.err.println("Failed to extract native libraries.\n" + exception);
        }
        System.loadLibrary(stringArray[0]);
        object = new File("bwapi-data/BWTA");
        if (!((File)object).exists()) {
            try {
                ((File)object).mkdirs();
            }
            catch (Exception exception) {
                System.err.println("Unable to create /bwapi-data/BWTA folder, BWTA analysis will not be saved.");
            }
        }
    }

    private static class JarResources {
        public boolean debugOn = false;
        private Hashtable htSizes = new Hashtable();
        private Hashtable htJarContents = new Hashtable();
        private String jarFileName;

        public JarResources(String string2) {
            this.jarFileName = string2;
            this.init();
        }

        public byte[] getResource(String string2) {
            return (byte[])this.htJarContents.get(string2);
        }

        private void init() {
            try {
                Object object;
                ZipFile zipFile = new ZipFile(this.jarFileName);
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    if (this.debugOn) {
                        System.out.println(this.dumpZipEntry((ZipEntry)object));
                    }
                    this.htSizes.put(((ZipEntry)object).getName(), new Integer((int)((ZipEntry)object).getSize()));
                }
                zipFile.close();
                object = new FileInputStream(this.jarFileName);
                BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object);
                ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
                ZipEntry zipEntry = null;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    int n;
                    if (zipEntry.isDirectory()) continue;
                    if (this.debugOn) {
                        System.out.println("ze.getName()=" + zipEntry.getName() + "," + "getSize()=" + zipEntry.getSize());
                    }
                    if ((n = (int)zipEntry.getSize()) == -1) {
                        n = (Integer)this.htSizes.get(zipEntry.getName());
                    }
                    byte[] byArray = new byte[n];
                    int n2 = 0;
                    int n3 = 0;
                    while (n - n2 > 0 && (n3 = zipInputStream.read(byArray, n2, n - n2)) != -1) {
                        n2 += n3;
                    }
                    this.htJarContents.put(zipEntry.getName(), byArray);
                    if (!this.debugOn) continue;
                    System.out.println(zipEntry.getName() + "  rb=" + n2 + ",size=" + n + ",csize=" + zipEntry.getCompressedSize());
                }
            }
            catch (NullPointerException nullPointerException) {
                System.out.println("done.");
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        private String dumpZipEntry(ZipEntry zipEntry) {
            StringBuffer stringBuffer = new StringBuffer();
            if (zipEntry.isDirectory()) {
                stringBuffer.append("d ");
            } else {
                stringBuffer.append("f ");
            }
            if (zipEntry.getMethod() == 0) {
                stringBuffer.append("stored   ");
            } else {
                stringBuffer.append("defalted ");
            }
            stringBuffer.append(zipEntry.getName());
            stringBuffer.append("\t");
            stringBuffer.append("" + zipEntry.getSize());
            if (zipEntry.getMethod() == 8) {
                stringBuffer.append("/" + zipEntry.getCompressedSize());
            }
            return stringBuffer.toString();
        }
    }

    private static interface FrameCallback {
        public void update();
    }
}

