/*
 * Decompiled with CFR 0.152.
 */
package Strategery.History;

import Lifecycle.With$;
import Strategery.History.HistoricalGame;
import Strategery.History.HistorySerializer$;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Predef$DummyImplicit$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class HistoryLoader$ {
    public static final HistoryLoader$ MODULE$;
    private final String Strategery$History$HistoryLoader$$filenameHistoryPrefix;
    private final String filenameEnemyToken;
    private final String filenameTemplate;
    private final String loadFilesDirectory;
    private final String saveFilesDirectory;
    private final String seedFilesDirectory;
    private final String[] directoriesInDecendingOrderOfRecency;

    static {
        new HistoryLoader$();
    }

    public String Strategery$History$HistoryLoader$$filenameHistoryPrefix() {
        return this.Strategery$History$HistoryLoader$$filenameHistoryPrefix;
    }

    private String filenameEnemyToken() {
        return this.filenameEnemyToken;
    }

    private String filenameTemplate() {
        return this.filenameTemplate;
    }

    private String loadFilesDirectory() {
        return this.loadFilesDirectory;
    }

    private String saveFilesDirectory() {
        return this.saveFilesDirectory;
    }

    private String seedFilesDirectory() {
        return this.seedFilesDirectory;
    }

    private String[] directoriesInDecendingOrderOfRecency() {
        return this.directoriesInDecendingOrderOfRecency;
    }

    public Iterable<HistoricalGame> load() {
        Iterable<String> gamesSerialized = this.loadAllGames(Predef$.MODULE$.wrapRefArray((Object[])this.directoriesInDecendingOrderOfRecency()));
        Vector<HistoricalGame> games = HistorySerializer$.MODULE$.readGames(gamesSerialized);
        HashMap gamesByTimestamp = new HashMap();
        games.foreach(new Serializable(gamesByTimestamp){
            public static final long serialVersionUID = 0L;
            private final HashMap gamesByTimestamp$1;

            public final Option<HistoricalGame> apply(HistoricalGame game) {
                return this.gamesByTimestamp$1.put(BoxesRunTime.boxToLong(game.timestamp()), this.gamesByTimestamp$1.getOrElse(BoxesRunTime.boxToLong(game.timestamp()), new Serializable(this, game){
                    public static final long serialVersionUID = 0L;
                    private final HistoricalGame game$1;

                    public final HistoricalGame apply() {
                        return this.game$1;
                    }
                    {
                        this.game$1 = game$1;
                    }
                }));
            }
            {
                this.gamesByTimestamp$1 = gamesByTimestamp$1;
            }
        });
        return gamesByTimestamp.values();
    }

    public void save(Iterable<HistoricalGame> games) {
        Iterable<String> enemyGamesSerialized = HistorySerializer$.MODULE$.writeGames((Iterable)games.filter((Function1<HistoricalGame, Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(HistoricalGame x$1) {
                String string2 = x$1.enemyName();
                String string3 = With$.MODULE$.history().currentEnemyName();
                return !(string2 != null ? !string2.equals(string3) : string3 != null);
            }
        })));
        this.saveGames(this.saveName(), enemyGamesSerialized);
    }

    private String saveName() {
        return new StringBuilder().append((Object)this.saveFilesDirectory()).append((Object)this.filenameTemplate().replace(this.filenameEnemyToken(), With$.MODULE$.history().currentEnemyName())).toString();
    }

    private Iterable<String> loadAllGames(Iterable<String> directories) {
        return directories.flatMap(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<String> apply(String directory) {
                return HistoryLoader$.MODULE$.Strategery$History$HistoryLoader$$loadGamesFromDirectory(directory);
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public Iterable<String> Strategery$History$HistoryLoader$$loadGamesFromDirectory(String directory) {
        try {
            File[] files2 = new File(directory).listFiles();
            if (files2 == null) {
                files2 = (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
            }
            File[] historyFiles = (File[])Predef$.MODULE$.refArrayOps((Object[])files2).filter(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(File x$2) {
                    return x$2.getName().contains(HistoryLoader$.MODULE$.Strategery$History$HistoryLoader$$filenameHistoryPrefix());
                }
            });
            return Predef$.MODULE$.refArrayOps((Object[])historyFiles).flatMap(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Iterable<String> apply(File file) {
                    return HistoryLoader$.MODULE$.Strategery$History$HistoryLoader$$loadGamesFromFile(file);
                }
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef$DummyImplicit$.MODULE$.dummyImplicit()));
        }
        catch (Exception exception) {
            With$.MODULE$.logger().warn(new StringBuilder().append((Object)"Failed to read games directory ").append((Object)directory).toString());
            With$.MODULE$.logger().onException(exception);
            return (Iterable)package$.MODULE$.Iterable().empty();
        }
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<String> Strategery$History$HistoryLoader$$loadGamesFromFile(File file) {
        void var3_3;
        BufferedReader reader = null;
        ArrayBuffer output = (ArrayBuffer)package$.MODULE$.Iterable().empty();
        String filename = "[Unknown file]";
        try {
            if (file.exists()) {
                filename = file.getName();
                boolean proceed = true;
                ArrayBuffer lines2 = new ArrayBuffer();
                FileInputStream stream = new FileInputStream(file);
                reader = new BufferedReader(new InputStreamReader(stream));
                while (proceed) {
                    String nextLine = reader.readLine();
                    proceed = nextLine != null;
                    Object object = proceed ? lines2.$plus$eq(nextLine) : BoxedUnit.UNIT;
                }
                output = lines2;
            }
        }
        catch (Exception exception) {
            With$.MODULE$.logger().warn(new StringBuilder().append((Object)"Failed to load game history from ").append((Object)filename).toString());
            With$.MODULE$.logger().onException(exception);
        }
        if (reader != null) {
            reader.close();
        }
        return var3_3;
    }

    private void saveGames(String filename, Iterable<String> contents) {
        BufferedWriter bufferedWriter = null;
        try {
            File file = new File(filename);
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter2 = bufferedWriter = new BufferedWriter(fileWriter);
            ((IterableLike)contents.map(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$3) {
                    return new StringBuilder().append((Object)x$3).append((Object)"\n").toString();
                }
            }, Iterable$.MODULE$.canBuildFrom())).foreach(new Serializable(bufferedWriter2){
                public static final long serialVersionUID = 0L;
                private final BufferedWriter eta$0$1$1;

                public final void apply(String x$1) {
                    this.eta$0$1$1.write(x$1);
                }
                {
                    this.eta$0$1$1 = eta$0$1$1;
                }
            });
        }
        catch (Exception exception) {
            With$.MODULE$.logger().warn(new StringBuilder().append((Object)"Failed to save game history to ").append((Object)filename).toString());
            With$.MODULE$.logger().onException(exception);
        }
        if (bufferedWriter != null) {
            bufferedWriter.close();
        }
    }

    private HistoryLoader$() {
        MODULE$ = this;
        this.Strategery$History$HistoryLoader$$filenameHistoryPrefix = new StringBuilder().append((Object)"_v").append(BoxesRunTime.boxToInteger(HistorySerializer$.MODULE$.formatVersion())).append((Object)"_history_").toString();
        this.filenameEnemyToken = "{opponent}";
        this.filenameTemplate = new StringBuilder().append((Object)this.Strategery$History$HistoryLoader$$filenameHistoryPrefix()).append((Object)this.filenameEnemyToken()).append((Object)".csv").toString();
        this.loadFilesDirectory = "bwapi-data/read/";
        this.saveFilesDirectory = "bwapi-data/write/";
        this.seedFilesDirectory = "bwapi-data/AI/";
        this.directoriesInDecendingOrderOfRecency = (String[])((Object[])new String[]{this.loadFilesDirectory(), this.saveFilesDirectory(), this.seedFilesDirectory()});
    }
}

