/*
 * Decompiled with CFR 0.152.
 */
package Micro.Decisions;

import Information.Geography.Pathfinding.ZonePath;
import Information.Geography.Types.Zone;
import Lifecycle.With$;
import Mathematics.Physics.Force;
import Mathematics.Physics.ForceMath$;
import Mathematics.Points.Pixel;
import Mathematics.PurpleMath$;
import Micro.Agency.Explosion;
import ProxyBwapi.Races.Protoss$;
import ProxyBwapi.UnitClass.UnitClass;
import ProxyBwapi.UnitInfo.FriendlyUnitInfo;
import ProxyBwapi.UnitInfo.UnitInfo;
import Utilities.ByOption$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering$Double$;
import scala.runtime.BoxesRunTime;

public final class Potential$ {
    public static final Potential$ MODULE$;

    static {
        new Potential$();
    }

    public Force unitAttraction(FriendlyUnitInfo unit, UnitInfo other, Function2<UnitInfo, UnitInfo, Object> magnifier) {
        return this.unitAttraction(unit, other, BoxesRunTime.unboxToDouble(magnifier.apply(unit, other)));
    }

    public Force unitAttraction(FriendlyUnitInfo unit, UnitInfo other, double magnitude) {
        Pixel pixelFrom = unit.pixelCenter();
        Pixel pixelTo = other.pixelCenter();
        Force output = ForceMath$.MODULE$.fromPixels(pixelFrom, pixelTo, magnitude);
        return output;
    }

    public Force threatsRepulsion(FriendlyUnitInfo unit) {
        Vector threats2 = (Vector)unit.matchups().threats().filterNot((Function1)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(UnitInfo x$1) {
                return x$1.is(Predef$.MODULE$.wrapRefArray((Object[])new UnitClass[]{Protoss$.MODULE$.Interceptor()}));
            }
        }));
        Vector<Force> forces = threats2.map(new Serializable(unit){
            public static final long serialVersionUID = 0L;
            private final FriendlyUnitInfo unit$1;

            public final Force apply(UnitInfo x$2) {
                return Potential$.MODULE$.threatRepulsion(this.unit$1, x$2);
            }
            {
                this.unit$1 = unit$1;
            }
        }, Vector$.MODULE$.canBuildFrom());
        Force output = ForceMath$.MODULE$.sum(forces).normalize();
        return output;
    }

    public Force threatRepulsion(FriendlyUnitInfo unit, UnitInfo threat) {
        double magnitudeDamage = threat.dpfOnNextHitAgainst(unit);
        double magnitudeDistance = Math.max(1.0, 12.0 + (double)threat.framesToGetInRange(unit));
        double magnitudeFinal = magnitudeDamage / magnitudeDistance;
        Force output = this.unitAttraction(unit, threat, -magnitudeFinal);
        return output;
    }

    public Force explosionsRepulsion(FriendlyUnitInfo unit) {
        ListBuffer<Explosion> explosions = unit.agent().explosions();
        ListBuffer<Force> forces = explosions.map(new Serializable(unit){
            public static final long serialVersionUID = 0L;
            private final FriendlyUnitInfo unit$2;

            public final Force apply(Explosion x$3) {
                return Potential$.MODULE$.explosionRepulsion(this.unit$2, x$3);
            }
            {
                this.unit$2 = unit$2;
            }
        }, ListBuffer$.MODULE$.canBuildFrom());
        Force output = ForceMath$.MODULE$.sum(forces).normalize();
        return output;
    }

    public Force explosionRepulsion(FriendlyUnitInfo unit, Explosion explosion) {
        double magnitudeDamage = explosion.damage();
        double magnitudeDistance = explosion.safetyRadius() / Math.max(1.0, unit.pixelDistanceFast(explosion.pixelCenter()));
        double magnitudeFinal = magnitudeDamage / magnitudeDistance;
        Force output = ForceMath$.MODULE$.fromPixels(unit.pixelCenter(), explosion.pixelCenter(), -magnitudeFinal);
        return output;
    }

    public Force detectionRepulsion(FriendlyUnitInfo unit) {
        Vector detectors2 = (Vector)unit.matchups().enemies().filter((Function1)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(UnitInfo e) {
                return e.aliveAndComplete() && e.unitClass().isDetector();
            }
        }));
        Vector<Force> forces = detectors2.map(new Serializable(unit){
            public static final long serialVersionUID = 0L;
            private final FriendlyUnitInfo unit$3;

            public final Force apply(UnitInfo x$4) {
                return Potential$.MODULE$.detectorRepulsion(this.unit$3, x$4);
            }
            {
                this.unit$3 = unit$3;
            }
        }, Vector$.MODULE$.canBuildFrom());
        Force output = ForceMath$.MODULE$.sum(forces).normalize();
        return output;
    }

    /*
     * WARNING - void declaration
     */
    public Force detectorRepulsion(FriendlyUnitInfo unit, UnitInfo detector) {
        void var3_3;
        Force output = this.unitAttraction(unit, detector, -1.0 / detector.pixelDistanceFast(unit));
        return var3_3;
    }

    public Force mobilityAttraction(FriendlyUnitInfo unit) {
        double mobilityNeed = 3.0 + BoxesRunTime.unboxToDouble(ByOption$.MODULE$.max(unit.matchups().threatsViolent().map(new Serializable(unit){
            public static final long serialVersionUID = 0L;
            private final FriendlyUnitInfo unit$4;

            public final double apply(UnitInfo threat) {
                return (double)2 * threat.pixelRangeAgainstFromCenter(this.unit$4) / (double)32;
            }
            {
                this.unit$4 = unit$4;
            }
        }, Vector$.MODULE$.canBuildFrom()), Ordering$Double$.MODULE$).getOrElse(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 0.0;
            }
        }));
        int mobilityNow = unit.mobility();
        double mobilityCap = unit.flying() ? 12.0 : (double)unit.zone().maxMobility() / 2.0;
        Force mobilityForce = unit.mobilityForce();
        double magnitudeRaw = Math.min(mobilityNeed, mobilityCap) / (double)mobilityNow / 2.0;
        double magnitude = PurpleMath$.MODULE$.clamp(magnitudeRaw, 1.0, 5.0);
        Force output = mobilityForce.normalize(magnitude);
        return output;
    }

    public Force collisionRepulsion(FriendlyUnitInfo unit) {
        if (unit.flying()) {
            return new Force();
        }
        Vector blockers = (Vector)unit.matchups().allies().filterNot((Function1)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(UnitInfo x$5) {
                return x$5.flying();
            }
        }));
        Option<UnitInfo> nearestBlocker = ByOption$.MODULE$.minBy(blockers, new Serializable(unit){
            public static final long serialVersionUID = 0L;
            private final FriendlyUnitInfo unit$5;

            public final double apply(UnitInfo x$6) {
                return x$6.pixelsFromEdgeFast(this.unit$5);
            }
            {
                this.unit$5 = unit$5;
            }
        }, Ordering$Double$.MODULE$);
        if (nearestBlocker.isEmpty()) {
            return new Force();
        }
        double maximumDistance = Math.max(32.0, unit.pixelRangeMax());
        double blockerDistance = nearestBlocker.get().pixelsFromEdgeFast(unit);
        double magnitude = Math.max(0.0, 1.0 - blockerDistance / maximumDistance);
        Force output = this.unitAttraction(unit, nearestBlocker.get(), -magnitude);
        return output;
    }

    public Force exitAttraction(FriendlyUnitInfo unit) {
        return unit.flying() ? this.exitAttractionAir(unit) : this.exitAttractionGround(unit);
    }

    public Force exitAttractionAir(FriendlyUnitInfo unit) {
        return ForceMath$.MODULE$.fromPixels(unit.pixelCenter(), unit.agent().origin(), ForceMath$.MODULE$.fromPixels$default$3()).normalize();
    }

    public Force exitAttractionGround(FriendlyUnitInfo unit) {
        Zone zoneNow = unit.zone();
        Zone zoneOrigin = unit.agent().origin().zone();
        Option<ZonePath> path = With$.MODULE$.paths().zonePath(zoneNow, zoneOrigin);
        if (path.isEmpty() || path.get().steps().isEmpty()) {
            return new Force();
        }
        Force forceExiting = ForceMath$.MODULE$.fromPixels(unit.pixelCenter(), path.get().steps().head().edge().centerPixel(), ForceMath$.MODULE$.fromPixels$default$3());
        Force forceNormal = forceExiting.normalize();
        return forceNormal;
    }

    public Force smuggleRepulsion(FriendlyUnitInfo unit) {
        if (unit.tileIncludingCenter().tileDistanceFromEdge() < 5) {
            return new Force();
        }
        return unit.mobilityForce().normalize().unary_$minus();
    }

    private Potential$() {
        MODULE$ = this;
    }
}

