/*
 * Decompiled with CFR 0.152.
 */
package Micro.Actions.Combat.Maneuvering;

import Debugging.Visualizations.ForceColors$;
import Mathematics.Physics.Force;
import Mathematics.Points.Pixel;
import Micro.Actions.Action;
import Micro.Actions.Combat.Maneuvering.Duck$;
import Micro.Actions.Commands.Attack$;
import Micro.Actions.Commands.Gravitate$;
import Micro.Agency.Explosion;
import Micro.Decisions.Potential$;
import ProxyBwapi.Races.Protoss$;
import ProxyBwapi.Races.Terran$;
import ProxyBwapi.UnitClass.UnitClass;
import ProxyBwapi.UnitInfo.FriendlyUnitInfo;
import ProxyBwapi.UnitInfo.UnitInfo;
import Utilities.ByOption$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering$Double$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class Duck$
extends Action {
    public static final Duck$ MODULE$;

    static {
        new Duck$();
    }

    @Override
    public boolean allowed(FriendlyUnitInfo unit) {
        return unit.canMove();
    }

    @Override
    public void perform(FriendlyUnitInfo unit) {
        unit.agent().explosions().$plus$plus$eq(this.getExplosions(unit));
        if (unit.agent().explosions().nonEmpty()) {
            Force forceExplosion = Potential$.MODULE$.explosionsRepulsion(unit);
            Force forceMobility = Potential$.MODULE$.mobilityAttraction(unit).normalize();
            Force forceSpreading = Potential$.MODULE$.collisionRepulsion(unit);
            unit.agent().forces().put(ForceColors$.MODULE$.threat(), forceExplosion);
            unit.agent().forces().put(ForceColors$.MODULE$.mobility(), forceMobility);
            unit.agent().forces().put(ForceColors$.MODULE$.spreading(), forceSpreading);
            Gravitate$.MODULE$.delegate(unit);
        }
    }

    private Iterable<Explosion> getExplosions(FriendlyUnitInfo unit) {
        ListBuffer output = new ListBuffer();
        output.$plus$plus$eq((TraversableOnce)unit.matchups().threats().flatMap(new Serializable(unit){
            public static final long serialVersionUID = 0L;
            private final FriendlyUnitInfo unit$1;

            public final Iterable<Explosion> apply(UnitInfo threat) {
                return Option$.MODULE$.option2Iterable(Duck$.MODULE$.Micro$Actions$Combat$Maneuvering$Duck$$explosion(this.unit$1, threat));
            }
            {
                this.unit$1 = unit$1;
            }
        }, Vector$.MODULE$.canBuildFrom()));
        return (Iterable)output.filter((Function1)((Object)new Serializable(unit){
            public static final long serialVersionUID = 0L;
            private final FriendlyUnitInfo unit$1;

            public final boolean apply(Explosion explosion) {
                return explosion.safetyRadius() > this.unit$1.pixelDistanceFast(explosion.pixelCenter());
            }
            {
                this.unit$1 = unit$1;
            }
        }));
    }

    public Option<Explosion> Micro$Actions$Combat$Maneuvering$Duck$$explosion(FriendlyUnitInfo unit, UnitInfo threat) {
        Some<Explosion> some;
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        if (threat.is(Predef$.MODULE$.wrapRefArray((Object[])new UnitClass[]{Terran$.MODULE$.SpiderMine()})) && !unit.flying() && !unit.unitClass().floats()) {
            if (threat.burrowed()) {
                double safetyMarginPixels = 96.0;
                some = new Some<Explosion>(new Explosion(threat.pixelCenter(), 96.0 + safetyMarginPixels, threat.damageOnNextHitAgainst(unit)));
            } else {
                ObjectRef<Object> target$lzy = ObjectRef.zero();
                if (this.target$1(threat, target$lzy, bitmap$0).contains(unit)) {
                    if (unit.canAttack(threat) && unit.readyForAttackOrder()) {
                        unit.agent().toAttack_$eq(new Some<UnitInfo>(threat));
                        Attack$.MODULE$.consider(unit, Attack$.MODULE$.consider$default$2());
                    }
                    some = None$.MODULE$;
                } else {
                    double safetyMarginPixels = 0.0;
                    some = new Some<Explosion>(new Explosion(threat.projectFrames(4), 74.0 + unit.unitClass().radialHypotenuse() + safetyMarginPixels, threat.damageOnNextHitAgainst(unit)));
                }
            }
        } else if (threat.is(Predef$.MODULE$.wrapRefArray((Object[])new UnitClass[]{Protoss$.MODULE$.Scarab()})) && !unit.flying()) {
            Option<UnitInfo> target2 = threat.target().orElse(new Serializable(threat){
                public static final long serialVersionUID = 0L;
                public final UnitInfo threat$1;

                public final Option<UnitInfo> apply() {
                    return ByOption$.MODULE$.minBy(this.threat$1.matchups().targets(), new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.1 $outer;

                        public final double apply(UnitInfo x$2) {
                            return x$2.pixelDistanceFast(this.$outer.threat$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Ordering$Double$.MODULE$);
                }
                {
                    this.threat$1 = threat$1;
                }
            });
            if (target2.contains(unit)) {
                some = None$.MODULE$;
            } else {
                Pixel targetPixel = target2.map(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Pixel apply(UnitInfo x$3) {
                        return x$3.pixelCenter();
                    }
                }).getOrElse(new Serializable(threat){
                    public static final long serialVersionUID = 0L;
                    private final UnitInfo threat$1;

                    public final Pixel apply() {
                        return this.threat$1.projectFrames(4);
                    }
                    {
                        this.threat$1 = threat$1;
                    }
                });
                double safetyMarginPixels = 32.0;
                some = new Some<Explosion>(new Explosion(targetPixel, 60.0 * unit.unitClass().radialHypotenuse() + safetyMarginPixels, threat.damageOnNextHitAgainst(unit)));
            }
        } else {
            some = None$.MODULE$;
        }
        return some;
    }

    private final Option target$lzycompute$1(UnitInfo threat$1, ObjectRef target$lzy$1, VolatileByteRef bitmap$0$1) {
        Duck$ duck$ = this;
        synchronized (duck$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                target$lzy$1.elem = threat$1.target().orElse(new Serializable(threat$1){
                    public static final long serialVersionUID = 0L;
                    public final UnitInfo threat$1;

                    public final Option<UnitInfo> apply() {
                        return ByOption$.MODULE$.minBy(this.threat$1.matchups().targets(), new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.target.lzycompute.1.1 $outer;

                            public final double apply(UnitInfo x$1) {
                                return x$1.pixelDistanceFast(this.$outer.threat$1);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, Ordering$Double$.MODULE$);
                    }
                    {
                        this.threat$1 = threat$1;
                    }
                });
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (Option)target$lzy$1.elem;
        }
    }

    private final Option target$1(UnitInfo threat$1, ObjectRef target$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.target$lzycompute$1(threat$1, target$lzy$1, bitmap$0$1) : (Option)target$lzy$1.elem;
    }

    private Duck$() {
        MODULE$ = this;
    }
}

