/*
 * Decompiled with CFR 0.152.
 */
package Mathematics;

import scala.Predef$;
import scala.collection.Traversable;
import scala.math.Numeric$DoubleIsFractional$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

public final class PurpleMath$ {
    public static final PurpleMath$ MODULE$;
    private final double twoPI;
    private final double twoPi;

    static {
        new PurpleMath$();
    }

    public double twoPI() {
        return this.twoPI;
    }

    public double mean(Traversable<Object> values) {
        return values.isEmpty() ? 0.0 : BoxesRunTime.unboxToDouble(values.sum(Numeric$DoubleIsFractional$.MODULE$)) / (double)values.size();
    }

    public double nanToZero(double value2) {
        return Predef$.MODULE$.double2Double(value2).isNaN() || RichDouble$.MODULE$.isInfinity$extension(Predef$.MODULE$.doubleWrapper(value2)) ? 0.0 : value2;
    }

    public double nanToOne(double value2) {
        return Predef$.MODULE$.double2Double(value2).isNaN() || RichDouble$.MODULE$.isInfinity$extension(Predef$.MODULE$.doubleWrapper(value2)) ? 1.0 : value2;
    }

    public double nanToInfinity(double value2) {
        return Predef$.MODULE$.double2Double(value2).isNaN() || RichDouble$.MODULE$.isInfinity$extension(Predef$.MODULE$.doubleWrapper(value2)) ? Double.POSITIVE_INFINITY : value2;
    }

    public double clampRatio(double value2, double ratio) {
        return this.clamp(value2, ratio, 1.0 / ratio);
    }

    public int clamp(int value2, int value1, int value22) {
        int min2 = Math.min(value1, value22);
        int max2 = Math.max(value1, value22);
        return Math.min(max2, Math.max(value2, min2));
    }

    public double clamp(double value2, double value1, double value22) {
        double min2 = Math.min(value1, value22);
        double max2 = Math.max(value1, value22);
        return Math.min(max2, Math.max(value2, min2));
    }

    public double clampToOne(double value2) {
        return Math.max(0.0, Math.min(1.0, value2));
    }

    public int signum(int n) {
        return n == 0 ? 0 : (n < 0 ? -1 : 1);
    }

    public double twoPi() {
        return this.twoPi;
    }

    public double normalizeAngle(double angleRadians) {
        while (true) {
            if (angleRadians < 0.0) {
                angleRadians += this.twoPi();
                continue;
            }
            if (!(angleRadians > this.twoPi())) break;
            angleRadians -= this.twoPi();
        }
        return angleRadians;
    }

    private PurpleMath$() {
        MODULE$ = this;
        this.twoPI = Math.PI * 2;
        this.twoPi = Math.PI * 2;
    }
}

