/*
 * Decompiled with CFR 0.152.
 */
package Macro.Allocation;

import Lifecycle.With$;
import Planning.Composition.ResourceLocks.LockCurrency;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashSet;
import scala.math.Ordering;
import scala.math.Ordering$Int$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001B\u0001\u0003\u0001\u001d\u0011AAQ1oW*\u00111\u0001B\u0001\u000b\u00032dwnY1uS>t'\"A\u0003\u0002\u000b5\u000b7M]8\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0001\u0004%I!F\u0001\r[&tWM]1mg2+g\r^\u000b\u0002-A\u0011\u0011bF\u0005\u00031)\u00111!\u00138u\u0011\u001dQ\u0002\u00011A\u0005\nm\t\u0001#\\5oKJ\fGn\u001d'fMR|F%Z9\u0015\u0005qy\u0002CA\u0005\u001e\u0013\tq\"B\u0001\u0003V]&$\bb\u0002\u0011\u001a\u0003\u0003\u0005\rAF\u0001\u0004q\u0012\n\u0004B\u0002\u0012\u0001A\u0003&a#A\u0007nS:,'/\u00197t\u0019\u00164G\u000f\t\u0005\bI\u0001\u0001\r\u0011\"\u0003\u0016\u0003\u001d9\u0017m\u001d'fMRDqA\n\u0001A\u0002\u0013%q%A\u0006hCNdUM\u001a;`I\u0015\fHC\u0001\u000f)\u0011\u001d\u0001S%!AA\u0002YAaA\u000b\u0001!B\u00131\u0012\u0001C4bg2+g\r\u001e\u0011\t\u000f1\u0002\u0001\u0019!C\u0005+\u0005Q1/\u001e9qYfdUM\u001a;\t\u000f9\u0002\u0001\u0019!C\u0005_\u0005q1/\u001e9qYfdUM\u001a;`I\u0015\fHC\u0001\u000f1\u0011\u001d\u0001S&!AA\u0002YAaA\r\u0001!B\u00131\u0012aC:vaBd\u0017\u0010T3gi\u0002Bq\u0001\u000e\u0001C\u0002\u0013%Q'\u0001\u0005sKF,Xm\u001d;t+\u00051\u0004cA\u001c=}5\t\u0001H\u0003\u0002:u\u00059Q.\u001e;bE2,'BA\u001e\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003{a\u0012q\u0001S1tQN+G\u000f\u0005\u0002@\r6\t\u0001I\u0003\u0002B\u0005\u0006i!+Z:pkJ\u001cW\rT8dWNT!a\u0011#\u0002\u0017\r{W\u000e]8tSRLwN\u001c\u0006\u0002\u000b\u0006A\u0001\u000b\\1o]&tw-\u0003\u0002H\u0001\naAj\\2l\u0007V\u0014(/\u001a8ds\"1\u0011\n\u0001Q\u0001\nY\n\u0011B]3rk\u0016\u001cHo\u001d\u0011\t\u000b-\u0003A\u0011\u0001'\u0002\rU\u0004H-\u0019;f)\u0005a\u0002\"\u0002(\u0001\t\u0003y\u0015a\u00059sS>\u0014\u0018\u000e^5{K\u0012\u0014V-];fgR\u001cX#\u0001)\u0011\u0007EKfH\u0004\u0002S/:\u00111KV\u0007\u0002)*\u0011QKB\u0001\u0007yI|w\u000e\u001e \n\u0003-I!\u0001\u0017\u0006\u0002\u000fA\f7m[1hK&\u0011!l\u0017\u0002\t\u0013R,'/\u00192mK*\u0011\u0001L\u0003\u0005\u0006;\u0002!\tAX\u0001\be\u0016\fX/Z:u)\tar\fC\u0003^9\u0002\u0007a\bC\u0003b\u0001\u0011\u0005!-A\u0004sK2,\u0017m]3\u0015\u0005q\u0019\u0007\"B/a\u0001\u0004q\u0004\"B3\u0001\t\u0013a\u0015\u0001\u0005:fG>,h\u000e\u001e*fg>,(oY3t\u0011\u00159\u0007\u0001\"\u0003i\u0003)\tX/Z;f\u0005VLXM\u001d\u000b\u00039%DQ!\u00184A\u0002yBQa\u001b\u0001\u0005\n1\fa\"[:Bm\u0006LG.\u00192mK:{w\u000f\u0006\u0002naB\u0011\u0011B\\\u0005\u0003_*\u0011qAQ8pY\u0016\fg\u000eC\u0003^U\u0002\u0007a\bC\u0003s\u0001\u0011%1/\u0001\u0007ge\u0006lWm\u001d+p\u000b\u0006\u0014h\u000eF\u0002\u0017iZDQ!^9A\u0002Y\tQA^1mk\u0016DQa^9A\u0002a\fAA]1uKB\u0011\u0011\"_\u0005\u0003u*\u0011a\u0001R8vE2,\u0007\"\u0002?\u0001\t\u0013i\u0018\u0001\u00064sC6,7\u000fV8FCJtW*\u001b8fe\u0006d7\u000f\u0006\u0002\u0017}\")qp\u001fa\u0001-\u0005AQ.\u001b8fe\u0006d7\u000fC\u0004\u0002\u0004\u0001!I!!\u0002\u0002\u001f\u0019\u0014\u0018-\\3t)>,\u0015M\u001d8HCN$2AFA\u0004\u0011\u001d\tI!!\u0001A\u0002Y\t1aZ1t\u0011\u001d\ti\u0001\u0001C\u0005\u0003\u001f\ta\"\u001a=qK\u000e$X\r\u001a$sC6,7\u000fF\u0002\u0017\u0003#Aa!XA\u0006\u0001\u0004q\u0004")
public class Bank {
    private int mineralsLeft = 0;
    private int gasLeft = 0;
    private int supplyLeft = 0;
    private final HashSet<LockCurrency> requests = new HashSet();

    private int mineralsLeft() {
        return this.mineralsLeft;
    }

    private void mineralsLeft_$eq(int x$1) {
        this.mineralsLeft = x$1;
    }

    private int gasLeft() {
        return this.gasLeft;
    }

    private void gasLeft_$eq(int x$1) {
        this.gasLeft = x$1;
    }

    private int supplyLeft() {
        return this.supplyLeft;
    }

    private void supplyLeft_$eq(int x$1) {
        this.supplyLeft = x$1;
    }

    private HashSet<LockCurrency> requests() {
        return this.requests;
    }

    public void update() {
        this.requests().clear();
        this.recountResources();
    }

    public Iterable<LockCurrency> prioritizedRequests() {
        return (Iterable)this.requests().toVector().sortBy((Function1)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LockCurrency x$1) {
                return x$1.owner().priority();
            }
        }), (Ordering)Ordering$Int$.MODULE$);
    }

    public void request(LockCurrency request) {
        this.requests().add(request);
        this.recountResources();
    }

    public void release(LockCurrency request) {
        request.isSatisfied_$eq(false);
        this.requests().remove(request);
        this.recountResources();
    }

    private void recountResources() {
        this.mineralsLeft_$eq(With$.MODULE$.self().minerals());
        this.gasLeft_$eq(With$.MODULE$.self().gas());
        this.supplyLeft_$eq(With$.MODULE$.self().supplyTotal() - With$.MODULE$.self().supplyUsed());
        this.prioritizedRequests().foreach(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Bank $outer;

            public final void apply(LockCurrency request) {
                this.$outer.Macro$Allocation$Bank$$queueBuyer(request);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void Macro$Allocation$Bank$$queueBuyer(LockCurrency request) {
        int framesToEarnCost = Math.max(this.framesToEarnMinerals(request.minerals()), this.framesToEarnGas(request.gas()));
        if (request.framesAhead() > framesToEarnCost || framesToEarnCost > 129600) {
            request.isSatisfied_$eq(false);
            request.expectedFrames_$eq(this.expectedFrames(request));
        } else {
            request.isSatisfied_$eq(request.isSpent() || this.isAvailableNow(request));
            if (!request.isSpent()) {
                this.mineralsLeft_$eq(this.mineralsLeft() - request.minerals());
                this.gasLeft_$eq(this.gasLeft() - request.gas());
                this.supplyLeft_$eq(this.supplyLeft() - request.supply());
            }
            request.expectedFrames_$eq(this.expectedFrames(request));
        }
    }

    private boolean isAvailableNow(LockCurrency request) {
        return !(request.minerals() != 0 && this.mineralsLeft() < request.minerals() || request.gas() != 0 && this.gasLeft() < request.gas() || request.supply() != 0 && this.supplyLeft() < request.supply());
    }

    private int framesToEarn(int value2, double rate) {
        return value2 <= 0 ? 0 : (rate <= 0.0 ? Integer.MAX_VALUE : (int)Math.ceil((double)value2 / With$.MODULE$.economy().ourIncomePerFrameMinerals()));
    }

    private int framesToEarnMinerals(int minerals) {
        return this.framesToEarn(minerals, With$.MODULE$.economy().ourIncomePerFrameMinerals());
    }

    private int framesToEarnGas(int gas) {
        return this.framesToEarn(gas, With$.MODULE$.economy().ourIncomePerFrameGas());
    }

    private int expectedFrames(LockCurrency request) {
        if (request.satisfied()) {
            return 0;
        }
        return BoxesRunTime.unboxToInt(((TraversableOnce)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapIntArray(new int[]{request.framesAhead(), this.framesToEarnMinerals(-this.mineralsLeft()), this.framesToEarnGas(-this.gasLeft())}))).max(Ordering$Int$.MODULE$));
    }
}

