/*
 * Decompiled with CFR 0.152.
 */
package Information.Geography.Pathfinding;

import Information.Geography.Pathfinding.GroundPathFinder$;
import Information.Geography.Pathfinding.GroundPaths;
import Information.Geography.Types.Edge;
import Information.Geography.Types.Zone;
import Lifecycle.With$;
import Mathematics.Points.Pixel;
import Mathematics.Points.Tile;
import bwta.BWTA;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxesRunTime;

public abstract class GroundPaths$class {
    public static boolean groundPathExists(GroundPaths $this, Tile origin2, Tile destination, boolean requireBwta) {
        return $this.groundPixelsByTile(origin2, destination, requireBwta) < $this.impossiblyLargeDistance();
    }

    public static boolean groundPathExists$default$3(GroundPaths $this) {
        return false;
    }

    public static double groundPixels(GroundPaths $this, Pixel origin2, Pixel destination) {
        boolean useAirDistance = false;
        Zone zoneOrigin = origin2.zone();
        Zone zoneDestination = destination.zone();
        Zone zone = zoneOrigin;
        Zone zone2 = zoneDestination;
        boolean bl = !(zone != null ? !zone.equals(zone2) : zone2 != null) ? true : (useAirDistance = false);
        if (!useAirDistance) {
            Edge[] edges2 = (Edge[])Predef$.MODULE$.refArrayOps((Object[])zoneOrigin.edges()).filter(new Serializable($this, zoneDestination){
                public static final long serialVersionUID = 0L;
                private final Zone zoneDestination$1;

                public final boolean apply(Edge x$1) {
                    return x$1.zones().contains(this.zoneDestination$1);
                }
                {
                    this.zoneDestination$1 = zoneDestination$1;
                }
            });
            useAirDistance = Predef$.MODULE$.refArrayOps((Object[])edges2).exists(new Serializable($this, origin2, destination){
                public static final long serialVersionUID = 0L;
                private final Pixel origin$1;
                private final Pixel destination$1;

                public final boolean apply(Edge edge) {
                    return edge.centerPixel().pixelDistanceFast(this.origin$1) + edge.centerPixel().pixelDistanceFast(this.destination$1) + edge.radiusPixels() < this.origin$1.pixelDistanceFast(this.destination$1);
                }
                {
                    this.origin$1 = origin$1;
                    this.destination$1 = destination$1;
                }
            });
        }
        if (useAirDistance) {
            return origin2.pixelDistanceFast(destination);
        }
        return $this.groundPixelsByTile(origin2.tileIncluding(), destination.tileIncluding(), $this.groundPixelsByTile$default$3());
    }

    public static double groundPixelsByTile(GroundPaths $this, Tile origin2, Tile destination, boolean requireBwta) {
        if (With$.MODULE$.configuration().useFastGroundDistance()) {
            Zone zone = origin2.zone();
            Zone zone2 = destination.zone();
            if (!(zone != null ? !zone.equals(zone2) : zone2 != null)) {
                return origin2.pixelCenter().pixelDistanceFast(destination.pixelCenter());
            }
        }
        Tuple2<Tile, Tile> request = new Tuple2<Tile, Tile>(origin2, destination);
        if (!$this.Information$Geography$Pathfinding$GroundPaths$$distanceCache().contains(request)) {
            GroundPaths$class.calculateDistance($this, request, requireBwta);
        }
        $this.Information$Geography$Pathfinding$GroundPaths$$distanceAge().put(request, BoxesRunTime.boxToDouble(With$.MODULE$.frame()));
        double result2 = BoxesRunTime.unboxToDouble($this.Information$Geography$Pathfinding$GroundPaths$$distanceCache().apply(request));
        GroundPaths$class.limitCacheSize($this);
        if (result2 < 0.0) {
            return $this.impossiblyLargeDistance();
        }
        return result2;
    }

    public static boolean groundPixelsByTile$default$3(GroundPaths $this) {
        return false;
    }

    private static void calculateDistance(GroundPaths $this, Tuple2 request, boolean requireBwta) {
        double distance = With$.MODULE$.configuration().useFastGroundDistance() && With$.MODULE$.frame() > 0 && !requireBwta ? GroundPathFinder$.MODULE$.groundDistanceFast(((Tile)request._1()).pixelCenter(), ((Tile)request._2()).pixelCenter()) : BWTA.getGroundDistance(((Tile)request._1()).bwapi(), ((Tile)request._2()).bwapi());
        $this.Information$Geography$Pathfinding$GroundPaths$$distanceCache().put(request, BoxesRunTime.boxToDouble(distance));
    }

    private static void limitCacheSize(GroundPaths $this) {
        if ($this.Information$Geography$Pathfinding$GroundPaths$$distanceCache().keys().size() > $this.Information$Geography$Pathfinding$GroundPaths$$maxCacheSize()) {
            int cutoff = With$.MODULE$.frame() - 1440;
            ((HashMap)$this.Information$Geography$Pathfinding$GroundPaths$$distanceAge().filter((Function1)((Object)new Serializable($this, cutoff){
                public static final long serialVersionUID = 0L;
                private final int cutoff$1;

                public final boolean apply(Tuple2<Tuple2<Tile, Tile>, Object> x$2) {
                    return x$2._2$mcD$sp() < (double)this.cutoff$1;
                }
                {
                    this.cutoff$1 = cutoff$1;
                }
            }))).foreach(new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ GroundPaths $outer;

                public final Option<Object> apply(Tuple2<Tuple2<Tile, Tile>, Object> pair) {
                    this.$outer.Information$Geography$Pathfinding$GroundPaths$$distanceCache().remove(pair._1());
                    return this.$outer.Information$Geography$Pathfinding$GroundPaths$$distanceAge().remove(pair._1());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
    }

    public static void $init$(GroundPaths $this) {
        $this.Information$Geography$Pathfinding$GroundPaths$_setter_$Information$Geography$Pathfinding$GroundPaths$$maxCacheSize_$eq(100000);
        $this.Information$Geography$Pathfinding$GroundPaths$_setter_$Information$Geography$Pathfinding$GroundPaths$$distanceCache_$eq(new HashMap());
        $this.Information$Geography$Pathfinding$GroundPaths$_setter_$Information$Geography$Pathfinding$GroundPaths$$distanceAge_$eq(new HashMap());
        $this.Information$Geography$Pathfinding$GroundPaths$_setter_$impossiblyLargeDistance_$eq(6.7108864E9);
    }
}

