/*
 * Decompiled with CFR 0.152.
 */
package Information.Geography.Pathfinding;

import Information.Geography.Pathfinding.GroundPathFinder$;
import Information.Geography.Pathfinding.TilePath;
import Information.Geography.Types.Edge;
import Information.Geography.Types.Zone;
import Lifecycle.With$;
import Mathematics.Points.Pixel;
import Mathematics.Points.Tile;
import scala.Array$;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.PriorityQueue;
import scala.math.Ordering$Double$;
import scala.math.Ordering$Int$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class GroundPathFinder$ {
    public static final GroundPathFinder$ MODULE$;

    static {
        new GroundPathFinder$();
    }

    public double groundDistanceFast(Pixel from2, Pixel to2) {
        Zone fromZone = from2.zone();
        Zone toZone = to2.zone();
        Zone zone = fromZone;
        Zone zone2 = toZone;
        if (!(zone != null ? !zone.equals(zone2) : zone2 != null)) {
            return from2.pixelDistanceFast(to2);
        }
        if (With$.MODULE$.paths().groundPathExists(fromZone.centroid(), toZone.centroid(), true)) {
            Tile[] fromEdgeTiles = (Tile[])Predef$.MODULE$.refArrayOps((Object[])fromZone.edges()).map(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tile apply(Edge x$1) {
                    return x$1.centerPixel().tileIncluding();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tile.class)));
            Tile[] toEdgeTiles = (Tile[])Predef$.MODULE$.refArrayOps((Object[])toZone.edges()).map(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tile apply(Edge x$2) {
                    return x$2.centerPixel().tileIncluding();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tile.class)));
            return BoxesRunTime.unboxToDouble(Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])fromEdgeTiles).map(new Serializable(from2, to2, toEdgeTiles){
                public static final long serialVersionUID = 0L;
                public final Pixel from$1;
                public final Pixel to$1;
                private final Tile[] toEdgeTiles$1;

                public final double apply(Tile fromEdgeTile) {
                    return BoxesRunTime.unboxToDouble(Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])this.toEdgeTiles$1).map(new Serializable(this, fromEdgeTile){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.groundDistanceFast.1 $outer;
                        private final Tile fromEdgeTile$1;

                        public final double apply(Tile toEdgeTile) {
                            return this.$outer.from$1.pixelDistanceFast(this.fromEdgeTile$1.pixelCenter()) + this.$outer.to$1.pixelDistanceFast(toEdgeTile.pixelCenter()) + With$.MODULE$.paths().groundPixelsByTile(this.fromEdgeTile$1, toEdgeTile, true);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.fromEdgeTile$1 = fromEdgeTile$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).min(Ordering$Double$.MODULE$));
                }
                {
                    this.from$1 = from$1;
                    this.to$1 = to$1;
                    this.toEdgeTiles$1 = toEdgeTiles$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).min(Ordering$Double$.MODULE$));
        }
        return With$.MODULE$.paths().impossiblyLargeDistance();
    }

    public TilePath manhattanGroundDistanceThroughObstacles(Tile start, Tile end, Set<Tile> obstacles, int maximumDistance) {
        HashSet<Tile> visited = new HashSet<Tile>();
        PriorityQueue<Tile> horizon = new PriorityQueue<Tile>(package$.MODULE$.Ordering().by(new Serializable(end){
            public static final long serialVersionUID = 0L;
            private final Tile end$1;

            public final int apply(Tile x$3) {
                return x$3.tileDistanceManhattan(this.end$1);
            }
            {
                this.end$1 = end$1;
            }
        }, Ordering$Int$.MODULE$));
        HashMap<Tile, Tile> cameFrom = new HashMap<Tile, Tile>();
        HashMap<Tile, Object> distanceFrom = new HashMap<Tile, Object>(){

            public int default(Tile key) {
                return Integer.MAX_VALUE;
            }
        };
        HashMap<Tile, Object> distanceTo = new HashMap<Tile, Object>(){

            public int default(Tile key) {
                return Integer.MAX_VALUE;
            }
        };
        distanceTo.update(start, BoxesRunTime.boxToInteger(0));
        distanceFrom.update(start, BoxesRunTime.boxToInteger(start.tileDistanceManhattan(end)));
        horizon.$plus$eq((Object)start);
        while (horizon.nonEmpty()) {
            Tile thisTile = horizon.dequeue();
            if (visited.contains(thisTile)) continue;
            visited.add(thisTile);
            Tile tile = thisTile;
            Tile tile2 = end;
            if (!(tile != null ? !((Object)tile).equals(tile2) : tile2 != null)) {
                return new TilePath(start, end, BoxesRunTime.unboxToInt(distanceFrom.apply(end)), visited.size(), new Some<Iterable<Tile>>(this.assemblePath(cameFrom, end)));
            }
            Tile[] neighbors = thisTile.adjacent4();
            for (int i = 0; i < 4; ++i) {
                Tile neighbor = neighbors[i];
                if (!neighbor.valid() || !BoxesRunTime.unboxToBoolean(With$.MODULE$.grids().walkable().get(neighbor)) || obstacles.contains(neighbor) || visited.contains(neighbor) || thisTile.tileDistanceManhattan(end) >= maximumDistance) continue;
                horizon.$plus$eq((Object)neighbor);
                int neighborDistanceFrom = BoxesRunTime.unboxToInt(distanceFrom.apply(thisTile)) + 1;
                if (neighborDistanceFrom >= BoxesRunTime.unboxToInt(distanceFrom.apply(neighbor))) continue;
                cameFrom.update(neighbor, thisTile);
                distanceFrom.update(neighbor, BoxesRunTime.boxToInteger(neighborDistanceFrom));
                distanceTo.update(neighbor, BoxesRunTime.boxToInteger(neighborDistanceFrom + neighbor.tileDistanceManhattan(end)));
            }
        }
        return new TilePath(start, end, Integer.MAX_VALUE, visited.size(), None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private Iterable<Tile> assemblePath(Map<Tile, Tile> cameFrom, Tile end) {
        void var3_3;
        ListBuffer<Object> path = new ListBuffer<Object>();
        path.$plus$eq((Object)end);
        Tile last2 = end;
        while (cameFrom.contains(last2)) {
            last2 = (Tile)cameFrom.apply(last2);
            path.append(Predef$.MODULE$.wrapRefArray((Object[])new Tile[]{last2}));
        }
        return var3_3;
    }

    private GroundPathFinder$() {
        MODULE$ = this;
    }
}

