/*
 * Decompiled with CFR 0.152.
 */
package Information.Battles.Estimations;

import Information.Battles.Estimations.Avatar;
import Information.Battles.Estimations.AvatarBuilder;
import Information.Battles.Estimations.Estimation;
import Lifecycle.With$;

public final class EstimateAvatar$ {
    public static final EstimateAvatar$ MODULE$;

    static {
        new EstimateAvatar$();
    }

    /*
     * WARNING - void declaration
     */
    public Estimation calculate(AvatarBuilder avatarBuilder) {
        void var2_2;
        Estimation output = new Estimation();
        output.avatarUs_$eq(avatarBuilder.avatarUs());
        output.avatarEnemy_$eq(avatarBuilder.avatarEnemy());
        output.totalUnitsUs_$eq(output.avatarUs().totalUnits());
        output.totalUnitsEnemy_$eq(output.avatarEnemy().totalUnits());
        if (avatarBuilder.avatarUs().totalUnits() <= 0.0 || avatarBuilder.avatarEnemy().totalUnits() <= 0.0) {
            return output;
        }
        int maxFrames = avatarBuilder.weRetreat() || avatarBuilder.enemyRetreats() ? 72 : With$.MODULE$.configuration().battleEstimationFrames();
        int frameStep = 24;
        while (output.frames() < maxFrames && output.weSurvive() && output.enemySurvives()) {
            output.frames_$eq(output.frames() + frameStep);
            output.damageToUs_$eq(output.damageToUs() + this.dealDamage(avatarBuilder.avatarEnemy(), avatarBuilder.avatarUs(), frameStep, output.deathsEnemy(), output.damageToUs()));
            output.damageToEnemy_$eq(output.damageToEnemy() + this.dealDamage(avatarBuilder.avatarUs(), avatarBuilder.avatarEnemy(), frameStep, output.deathsUs(), output.damageToEnemy()));
            output.deathsUs_$eq(this.deaths(avatarBuilder.avatarUs(), output.damageToUs()));
            output.deathsEnemy_$eq(this.deaths(avatarBuilder.avatarEnemy(), output.damageToEnemy()));
        }
        output.costToUs_$eq(this.totalCost(avatarBuilder.avatarUs(), output.damageToUs()));
        output.costToEnemy_$eq(this.totalCost(avatarBuilder.avatarEnemy(), output.damageToEnemy()));
        return var2_2;
    }

    private double dealDamage(Avatar from2, Avatar to2, double frames, double fromDeaths, double damageExisting) {
        double damageOutput = (from2.totalUnits() - fromDeaths) / from2.totalUnits();
        double airFocus = to2.totalFlyers() / to2.totalUnits();
        double groundFocus = 1.0 - airFocus;
        double seconds = (double)With$.MODULE$.configuration().battleEstimationFrames() / 24.0;
        double damagePerFramePerUnit = to2.vulnerabilityGroundConcussive() * (from2.dpfGroundConcussiveFocused() + from2.dpfGroundConcussiveUnfocused() * groundFocus) + to2.vulnerabilityGroundExplosive() * (from2.dpfGroundExplosiveFocused() + from2.dpfGroundExplosiveUnfocused() * groundFocus) + to2.vulnerabilityGroundNormal() * (from2.dpfGroundNormalFocused() + from2.dpfGroundNormalUnfocused() * groundFocus) + to2.vulnerabilityAirConcussive() * (from2.dpfAirConcussiveFocused() + from2.dpfAirConcussiveUnfocused() * airFocus) + to2.vulnerabilityAirExplosive() * (from2.dpfAirExplosiveFocused() + from2.dpfAirExplosiveUnfocused() * airFocus) + to2.vulnerabilityAirNormal() * (from2.dpfAirNormalFocused() + from2.dpfAirNormalUnfocused() * airFocus);
        return Math.min(to2.totalHealth() - damageExisting, damagePerFramePerUnit * frames / to2.totalUnits());
    }

    private double deaths(Avatar avatar, double damage) {
        return Math.min(avatar.totalUnits(), Math.floor(avatar.totalUnits() * damage / avatar.totalHealth()));
    }

    private double totalCost(Avatar avatar, double damage) {
        return avatar.subjectiveValue() * damage / avatar.totalHealth();
    }

    private EstimateAvatar$() {
        MODULE$ = this;
    }
}

