/*
 * Decompiled with CFR 0.152.
 */
package Debugging.Visualizations.Views.Fun;

import Debugging.Visualizations.Colors$;
import Debugging.Visualizations.Rendering.DrawMap$;
import Debugging.Visualizations.Views.View;
import Lifecycle.With$;
import Mathematics.Points.Pixel;
import ProxyBwapi.UnitInfo.FriendlyUnitProxy;
import ProxyBwapi.UnitInfo.UnitInfo;
import bwapi.Color;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.math.Ordering;
import scala.math.Ordering$Boolean$;
import scala.math.Ordering$Int$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;

public final class ShowHappyUnits$
extends View {
    public static final ShowHappyUnits$ MODULE$;

    static {
        new ShowHappyUnits$();
    }

    @Override
    public void renderMap() {
        ((IterableLike)((SeqLike)((TraversableOnce)With$.MODULE$.units().all().filter((Function1<UnitInfo, Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(UnitInfo unit) {
                return unit.alive() && (unit.complete() || unit.unitClass().isBuilding());
            }
        }))).toVector().sortBy((Function1)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(UnitInfo x$1) {
                return x$1.y();
            }
        }), (Ordering)Ordering$Int$.MODULE$)).sortBy(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(UnitInfo x$2) {
                return x$2.flying();
            }
        }, Ordering$Boolean$.MODULE$)).foreach(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(UnitInfo unit) {
                ShowHappyUnits$.MODULE$.renderUnit(unit);
            }
        });
        With$.MODULE$.game().drawTextScreen(408, 4, "Candy: ");
        With$.MODULE$.game().drawTextScreen(481, 4, "Soda: ");
        With$.MODULE$.game().drawTextScreen(541, 4, "Friends: ");
    }

    public void renderUnit(UnitInfo unit) {
        Color color = unit.color();
        boolean isActiveBuilding = unit.friendly().nonEmpty() && ((FriendlyUnitProxy)unit.friendly().get()).trainingQueue().nonEmpty();
        int animationFrame = unit.left() + unit.top() + With$.MODULE$.frame();
        int verticalBonus = unit.flying() ? 24 : (isActiveBuilding ? (int)(Math.sin(animationFrame / 8) * (double)6) : 0);
        int horizontalBonus = 0;
        int left = horizontalBonus + unit.left();
        int right = horizontalBonus + unit.right();
        int top = verticalBonus + unit.top();
        int bottom = verticalBonus + unit.bottom();
        int middle = (left + right) / 2;
        int farLeft = left - unit.unitClass().width() / 8;
        int farRight = right + unit.unitClass().width() / 8;
        int leftPerspective = left;
        int rightPerspective = right;
        int waist = top + unit.unitClass().height() / 4;
        int apex = top - unit.unitClass().height() / 4;
        this.drawSolidTriangle(new Pixel(farLeft, bottom), new Pixel(farRight, bottom), new Pixel(middle, apex), color, this.drawSolidTriangle$default$5());
        this.drawSolidTriangle(new Pixel(farLeft, bottom), new Pixel(leftPerspective, waist), new Pixel(middle, apex), color, this.drawSolidTriangle$default$5());
        this.drawSolidTriangle(new Pixel(farRight, bottom), new Pixel(rightPerspective, waist), new Pixel(middle, apex), color, this.drawSolidTriangle$default$5());
        DrawMap$.MODULE$.label(unit.unitClass().toString().replaceAll("Vespene", "Soda").replaceAll("Mineral", "Candy").replaceAll("Assimilator", "Soda Assimilator").replaceAll("Extractor", "Soda Extractor").replaceAll("Refinery", "Soda Refinery").replaceAll("Critter Rhynadon", "Snuggles the Rhino").replaceAll("Critter Ursadon", "Cupcake Cuddlemonster").replaceAll("Critter Kakaru", "Flying Dumpling"), new Pixel(middle, bottom + 9), DrawMap$.MODULE$.label$default$3(), DrawMap$.MODULE$.label$default$4(), DrawMap$.MODULE$.label$default$5(), DrawMap$.MODULE$.label$default$6());
        int eyeLeft = middle + unit.unitClass().width() / 5;
        int eyeRight = middle - unit.unitClass().width() / 5;
        int eyeLevel = top + unit.unitClass().height() / 2;
        int mouthLeft = left + unit.unitClass().width() / 3;
        int mouthRight = right - unit.unitClass().width() / 3;
        int mouthAngleLeft = left + unit.unitClass().width() * 5 / 12;
        int mouthAngleRight = right - unit.unitClass().width() * 5 / 12;
        int mouthTop = top + unit.unitClass().height() * 6 / 10;
        int mouthBottom = top + unit.unitClass().height() * 7 / 10;
        if (unit.unitClass().rawCanAttack() && !unit.unitClass().isWorker()) {
            int foreheadLow = eyeLevel - unit.unitClass().height() / 8;
            int foreheadHigh = eyeLevel - unit.unitClass().height() / 4;
            DrawMap$.MODULE$.line(new Pixel(mouthLeft, foreheadHigh), new Pixel(middle, foreheadLow), color);
            DrawMap$.MODULE$.line(new Pixel(mouthRight, foreheadHigh), new Pixel(middle, foreheadLow), color);
        }
        if (unit.complete()) {
            if (unit.totalHealth() < unit.unitClass().maxTotalHealth() / 2) {
                int swap = mouthBottom;
                mouthBottom = mouthTop;
                mouthTop = swap;
            } else if (unit.totalHealth() < unit.unitClass().maxTotalHealth() * 3 / 4) {
                int mouthMiddle;
                mouthTop = mouthMiddle = (mouthBottom + mouthTop) / 2;
                mouthBottom = mouthMiddle;
            }
        }
        if (unit.complete()) {
            DrawMap$.MODULE$.box(new Pixel(eyeLeft - 1, eyeLevel - 1), new Pixel(eyeLeft + 1, eyeLevel + 1), color, true);
            DrawMap$.MODULE$.box(new Pixel(eyeRight - 1, eyeLevel - 1), new Pixel(eyeRight + 1, eyeLevel + 1), color, true);
        } else {
            DrawMap$.MODULE$.line(new Pixel(eyeLeft - 1, eyeLevel + 1), new Pixel(eyeLeft + 1, eyeLevel + 1), color);
            DrawMap$.MODULE$.line(new Pixel(eyeLeft - 1, eyeLevel + 1), new Pixel(eyeLeft - 3, eyeLevel - 1), color);
            DrawMap$.MODULE$.line(new Pixel(eyeLeft + 1, eyeLevel + 1), new Pixel(eyeLeft + 3, eyeLevel - 1), color);
            DrawMap$.MODULE$.line(new Pixel(eyeRight - 1, eyeLevel + 1), new Pixel(eyeRight + 1, eyeLevel + 1), color);
            DrawMap$.MODULE$.line(new Pixel(eyeRight - 1, eyeLevel + 1), new Pixel(eyeRight - 3, eyeLevel - 1), color);
            DrawMap$.MODULE$.line(new Pixel(eyeRight + 1, eyeLevel + 1), new Pixel(eyeRight + 3, eyeLevel - 1), color);
            DrawMap$.MODULE$.text(new Pixel(right, top), "Z");
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 1 + animationFrame / 16 % 4).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(right, top){
                public static final long serialVersionUID = 0L;
                private final int right$1;
                private final int top$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    DrawMap$.MODULE$.text(new Pixel(this.right$1 + i * 6, this.top$1 - i * 2), "z");
                }
                {
                    this.right$1 = right$1;
                    this.top$1 = top$1;
                }
            }));
        }
        DrawMap$.MODULE$.line(new Pixel(mouthLeft, mouthTop), new Pixel(mouthAngleLeft, mouthBottom), color);
        DrawMap$.MODULE$.line(new Pixel(mouthAngleLeft, mouthBottom), new Pixel(mouthAngleRight, mouthBottom), color);
        DrawMap$.MODULE$.line(new Pixel(mouthRight, mouthTop), new Pixel(mouthAngleRight, mouthBottom), color);
        if (unit.carryingMinerals()) {
            DrawMap$.MODULE$.circle(unit.pixelCenter().add(-10, 0), 4, Colors$.MODULE$.NeonTeal(), true);
        }
        if (unit.carryingGas()) {
            DrawMap$.MODULE$.circle(unit.pixelCenter().add(-10, 0), 4, Colors$.MODULE$.NeonGreen(), true);
        }
    }

    public void drawSolidTriangle(Pixel p1, Pixel p2, Pixel p3, Color foreground, Color background) {
        DrawMap$.MODULE$.triangle(p1, p2, p3, background, true);
        DrawMap$.MODULE$.triangle(p1, p2, p3, foreground, false);
    }

    public Color drawSolidTriangle$default$5() {
        return Color.Black;
    }

    private ShowHappyUnits$() {
        MODULE$ = this;
    }
}

