/*
 * Decompiled with CFR 0.152.
 */
package Debugging.Visualizations.Rendering;

import Debugging.Visualizations.Colors$;
import Debugging.Visualizations.Rendering.DrawScreen;
import Lifecycle.With$;
import Mathematics.Points.Pixel;
import bwapi.Color;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableOnce;
import scala.math.Ordering$Double$;
import scala.math.Ordering$Int$;
import scala.runtime.BoxesRunTime;

public final class DrawScreen$ {
    public static final DrawScreen$ MODULE$;

    static {
        new DrawScreen$();
    }

    public void header(int x, String text2) {
        this.column(x, With$.MODULE$.visualization().lineHeightSmall(), text2);
    }

    public void column(int x, int y, Iterable<String> text2) {
        this.column(x, y, text2.mkString("\n"));
    }

    public void column(int x, int y, String text2) {
        With$.MODULE$.game().drawTextScreen(x, y, text2);
    }

    public void table(int x, int y, Iterable<Iterable<String>> cells) {
        ((IterableLike)cells.zipWithIndex(Iterable$.MODULE$.canBuildFrom())).foreach(new Serializable(x, y){
            public static final long serialVersionUID = 0L;
            private final int x$4;
            private final int y$1;

            public final void apply(Tuple2<Iterable<String>, Object> pair) {
                DrawScreen$.MODULE$.tableRow(this.x$4, this.y$1, pair._2$mcI$sp(), pair._1());
            }
            {
                this.x$4 = x$4;
                this.y$1 = y$1;
            }
        });
    }

    public void tableRow(int x, int y, int rowIndex, Iterable<String> row) {
        ((IterableLike)row.zipWithIndex(Iterable$.MODULE$.canBuildFrom())).foreach(new Serializable(x, y, rowIndex){
            public static final long serialVersionUID = 0L;
            private final int x$5;
            private final int y$2;
            private final int rowIndex$1;

            public final void apply(Tuple2<String, Object> pair) {
                With$.MODULE$.game().drawTextScreen(this.x$5 + pair._2$mcI$sp() * 60, this.y$2 + this.rowIndex$1 * 13, pair._1());
            }
            {
                this.x$5 = x$5;
                this.y$2 = y$2;
                this.rowIndex$1 = rowIndex$1;
            }
        });
    }

    public void graph(Pixel start, String label, Traversable<DrawScreen.GraphCurve> curves, Option<Object> fixedMin, Option<Object> fixedMax, Color color0, Color color1, int width, int height, int margin) {
        Pixel end = start.add(width, height);
        Pixel innerBorderStart = start.add(margin, margin + With$.MODULE$.visualization().lineHeightSmall());
        Pixel innerBorderEnd = end.subtract(margin, margin);
        Pixel pointStart = innerBorderStart.add(margin, margin);
        Pixel pointEnd = innerBorderEnd.subtract(margin, margin);
        double dataMin = BoxesRunTime.unboxToDouble(((TraversableOnce)curves.flatten(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final IndexedSeq<Object> apply(DrawScreen.GraphCurve x$1) {
                return x$1.points();
            }
        })).min(Ordering$Double$.MODULE$));
        double dataMax = BoxesRunTime.unboxToDouble(((TraversableOnce)curves.flatten(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final IndexedSeq<Object> apply(DrawScreen.GraphCurve x$2) {
                return x$2.points();
            }
        })).max(Ordering$Double$.MODULE$));
        double min2 = Math.min(dataMin, BoxesRunTime.unboxToDouble(fixedMin.getOrElse(new Serializable(dataMin){
            public static final long serialVersionUID = 0L;
            private final double dataMin$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.dataMin$1;
            }
            {
                this.dataMin$1 = dataMin$1;
            }
        })));
        double max2 = Math.max(dataMax, BoxesRunTime.unboxToDouble(fixedMax.getOrElse(new Serializable(dataMax){
            public static final long serialVersionUID = 0L;
            private final double dataMax$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.dataMax$1;
            }
            {
                this.dataMax$1 = dataMax$1;
            }
        })));
        int points2 = BoxesRunTime.unboxToInt(((TraversableOnce)curves.map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(DrawScreen.GraphCurve x$3) {
                return x$3.points().size();
            }
        }, Traversable$.MODULE$.canBuildFrom())).max(Ordering$Int$.MODULE$));
        double scaleX = (double)(pointEnd.x() - pointStart.x()) / (double)points2;
        double scaleY = (double)(pointEnd.y() - pointStart.y()) / Math.max(1.0, max2 - min2);
        With$.MODULE$.game().drawBoxScreen(start.bwapi(), end.bwapi(), color0, true);
        With$.MODULE$.game().drawBoxScreen(innerBorderStart.bwapi(), innerBorderEnd.bwapi(), color1, true);
        With$.MODULE$.game().drawTextScreen(start.add(margin, 0).bwapi(), label);
        curves.foreach(new Serializable(pointStart, max2, scaleX, scaleY){
            public static final long serialVersionUID = 0L;
            private final Pixel pointStart$1;
            private final double max$1;
            private final double scaleX$1;
            private final double scaleY$1;

            public final void apply(DrawScreen.GraphCurve curve) {
                for (int i = 0; i < curve.points().size() - 1; ++i) {
                    With$.MODULE$.game().drawLineScreen((int)((double)this.pointStart$1.x() + this.scaleX$1 * (double)i), (int)((double)this.pointStart$1.y() + this.scaleY$1 * (this.max$1 - BoxesRunTime.unboxToDouble(curve.points().apply(i)))), (int)((double)this.pointStart$1.x() + this.scaleX$1 * (double)(i + 1)), (int)((double)this.pointStart$1.y() + this.scaleY$1 * (this.max$1 - BoxesRunTime.unboxToDouble(curve.points().apply(i + 1)))), curve.color());
                }
            }
            {
                this.pointStart$1 = pointStart$1;
                this.max$1 = max$1;
                this.scaleX$1 = scaleX$1;
                this.scaleY$1 = scaleY$1;
            }
        });
    }

    public Option<Object> graph$default$4() {
        return None$.MODULE$;
    }

    public Option<Object> graph$default$5() {
        return None$.MODULE$;
    }

    public Color graph$default$6() {
        return Colors$.MODULE$.DeepViolet();
    }

    public Color graph$default$7() {
        return Colors$.MODULE$.MidnightViolet();
    }

    public int graph$default$8() {
        return 90;
    }

    public int graph$default$9() {
        return 90 + With$.MODULE$.visualization().lineHeightSmall();
    }

    public int graph$default$10() {
        return 2;
    }

    private DrawScreen$() {
        MODULE$ = this;
    }
}

