/*
 * Decompiled with CFR 0.152.
 */
package Debugging;

import Lifecycle.Manners$;
import Lifecycle.With$;
import ProxyBwapi.Players.PlayerInfo;
import java.io.File;
import java.io.PrintWriter;
import java.util.Calendar;
import scala.Array$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.TraversableOnce;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E3A!\u0001\u0002\u0001\u000b\t1Aj\\4hKJT\u0011aA\u0001\n\t\u0016\u0014WoZ4j]\u001e\u001c\u0001a\u0005\u0002\u0001\rA\u0011qAC\u0007\u0002\u0011)\t\u0011\"A\u0003tG\u0006d\u0017-\u0003\u0002\f\u0011\t1\u0011I\\=SK\u001aDQ!\u0004\u0001\u0005\u00029\ta\u0001P5oSRtD#A\b\u0011\u0005A\u0001Q\"\u0001\u0002\t\u000fI\u0001!\u0019!C\u0005'\u0005YAn\\4NKN\u001c\u0018mZ3t+\u0005!\u0002cA\u000b\u001b95\taC\u0003\u0002\u00181\u00059Q.\u001e;bE2,'BA\r\t\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00037Y\u0011!\u0002T5ti\n+hMZ3s!\ti\u0002E\u0004\u0002\b=%\u0011q\u0004C\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0012#AB*ue&twM\u0003\u0002 \u0011!1A\u0005\u0001Q\u0001\nQ\tA\u0002\\8h\u001b\u0016\u001c8/Y4fg\u0002BQA\n\u0001\u0005\u0002\u001d\nQA\u001a7vg\"$\u0012\u0001\u000b\t\u0003\u000f%J!A\u000b\u0005\u0003\tUs\u0017\u000e\u001e\u0005\u0006Y\u0001!\t!L\u0001\f_:,\u0005pY3qi&|g\u000e\u0006\u0002)]!)qf\u000ba\u0001a\u0005IQ\r_2faRLwN\u001c\t\u0003cer!AM\u001c\u000f\u0005M2T\"\u0001\u001b\u000b\u0005U\"\u0011A\u0002\u001fs_>$h(C\u0001\n\u0013\tA\u0004\"A\u0004qC\u000e\\\u0017mZ3\n\u0005iZ$!C#yG\u0016\u0004H/[8o\u0015\tA\u0004\u0002C\u0003>\u0001\u0011\u0005a(A\u0003eK\n,x\r\u0006\u0002)\u007f!)\u0001\t\u0010a\u00019\u00059Q.Z:tC\u001e,\u0007\"\u0002\"\u0001\t\u0003\u0019\u0015\u0001B<be:$\"\u0001\u000b#\t\u000b\u0001\u000b\u0005\u0019\u0001\u000f\t\u000b\u0019\u0003A\u0011A$\u0002\u000b\u0015\u0014(o\u001c:\u0015\u0005!B\u0005\"\u0002!F\u0001\u0004a\u0002\"\u0002&\u0001\t\u0013Y\u0015a\u00017pOR\u0011\u0001\u0006\u0014\u0005\u0006\u0001&\u0003\r\u0001\b\u0005\u0006\u001d\u0002!IaT\u0001\u0010M>\u0014X.\u0019;Fq\u000e,\u0007\u000f^5p]R\u0011A\u0004\u0015\u0005\u0006_5\u0003\r\u0001\r")
public class Logger {
    private final ListBuffer<String> logMessages = new ListBuffer();

    private ListBuffer<String> logMessages() {
        return this.logMessages;
    }

    public void flush() {
        String opponents = ((TraversableOnce)With$.MODULE$.enemies().map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(PlayerInfo x$1) {
                return x$1.name();
            }
        }, Vector$.MODULE$.canBuildFrom())).mkString("-");
        String filenameRaw = new StringBuilder().append((Object)opponents).append((Object)"-").append((Object)Calendar.getInstance().getTime().toString()).toString();
        String filename = new StringBuilder().append((Object)"bwapi-data/write/").append((Object)filenameRaw.replaceAll("[^A-Za-z0-9 \\-\\.]", "")).append((Object)".log.txt").toString();
        File file = new File(filename);
        PrintWriter printWriter = new PrintWriter(file);
        printWriter.write(((TraversableForwarder)this.logMessages().distinct()).mkString("\r\n"));
        printWriter.close();
    }

    public void onException(Exception exception) {
        this.log(new StringBuilder().append((Object)"An exception was thrown on frame ").append(BoxesRunTime.boxToInteger(With$.MODULE$.frame())).toString());
        this.logMessages().append(Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.formatException(exception)}));
        this.debug(this.formatException(exception));
    }

    public void debug(String message) {
        this.log(message);
    }

    public void warn(String message) {
        this.log(message);
    }

    public void error(String message) {
        this.log(message);
    }

    private void log(String message) {
        this.logMessages().append(Predef$.MODULE$.wrapRefArray((Object[])new String[]{message}));
        Manners$.MODULE$.chat(message);
        if (With$.MODULE$.configuration().enableStdOut()) {
            System.out.println(message);
        }
    }

    private String formatException(Exception exception) {
        new StringBuilder().append((Object)exception.getClass().getSimpleName()).append((Object)"\n").append((Object)exception.getMessage()).append((Object)"\n").toString();
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])exception.getStackTrace()).map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(StackTraceElement stackElement) {
                return new StringBuilder().append((Object)stackElement.getClassName()).append((Object)".").append((Object)stackElement.getMethodName()).append((Object)"(): ").append(BoxesRunTime.boxToInteger(stackElement.getLineNumber())).toString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("\n");
    }
}

