/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.unitgroups;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Race;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.RepairCommand;
import com.tyr.unitgroups.OutOfJob;
import com.tyr.unitgroups.UnitGroup;
import java.util.ArrayList;

public class UnderConstruction
extends UnitGroup {
    ArrayList<RepairCommand> emergencyCommands = new ArrayList();

    public UnderConstruction(OutOfJob rejects) {
        super(rejects);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        ArrayList<RepairCommand> removeRepairs = new ArrayList<RepairCommand>();
        for (RepairCommand repair : this.emergencyCommands) {
            repair.target.drawCircle(Color.Teal);
            repair.worker.drawCircle(Color.Teal);
            if (repair.target.isDead()) {
                removeRepairs.add(repair);
                continue;
            }
            if (repair.target.unit.isCompleted() || repair.worker.isDead()) {
                removeRepairs.add(repair);
                this.units.add(repair.target);
                continue;
            }
            if (!repair.worker.unit.isIdle()) continue;
            repair.worker.unit.rightClick(repair.target.unit);
        }
        for (RepairCommand repair : removeRepairs) {
            this.emergencyCommands.remove(repair);
            if (repair.worker.isDead()) continue;
            this.rejects.add(repair.worker);
        }
        ArrayList<Agent> completed = new ArrayList<Agent>();
        ArrayList<Agent> repairing = new ArrayList<Agent>();
        for (Agent building : this.units) {
            Agent worker;
            if (building.unit.isCompleted()) {
                completed.add(building);
                continue;
            }
            if (building.unit.getHitPoints() <= 75) {
                building.drawCircle(Color.Red, 12);
            }
            if (building.unit.isUnderAttack()) {
                building.drawCircle(Color.Orange, 16);
            }
            if (building.unit.isUnderAttack() && building.unit.getHitPoints() <= 75) {
                building.drawCircle(Color.Purple, 20);
                building.unit.cancelConstruction();
                continue;
            }
            building.drawCircle(Color.White);
            if (self.getRace() != Race.Terran || building.unit.getBuildUnit() != null || (worker = bot.workForce.pop(building.unit.getPosition())) == null) continue;
            worker.unit.rightClick(building.unit);
            RepairCommand emergencyCommand = new RepairCommand(worker, building);
            this.emergencyCommands.add(emergencyCommand);
            repairing.add(building);
        }
        for (Agent building : repairing) {
            this.units.remove(building);
        }
        for (Agent building : completed) {
            this.units.remove(building);
            this.rejects.add(building);
        }
    }

    @Override
    public int takeAgent(Agent agent) {
        if (agent.unit.getType().isBuilding() && !agent.unit.isCompleted()) {
            return 1;
        }
        return -1;
    }
}

