/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.unitgroups;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Race;
import bwapi.Unit;
import bwapi.UnitType;
import bwta.BaseLocation;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.KillWorkers;
import com.tyr.agents.None;
import com.tyr.unitgroups.OutOfJob;
import com.tyr.unitgroups.UnitGroup;
import java.util.ArrayList;

public class ScoutGroup
extends UnitGroup {
    int scoutBase = 0;
    public int opponentStrategy = 0;
    public static int unknown = 0;
    public static int zealotPush = 1;
    public static int cannons = 2;
    public static int tech = 3;
    public static int defensive = 4;
    public static int besiege = 5;
    public static int workerRush = 6;
    public int scoutCount = 1;
    public int workerScoutTiming = -1;
    public int nscouts = 0;
    private boolean scoutsSent = false;
    public boolean keepScouting = false;
    public static boolean clearEnemyExpands = false;
    public static Race enemyRace = Race.Unknown;
    private static final boolean FAKE_RANDOM = true;

    public ScoutGroup(OutOfJob rejects) {
        super(rejects);
        this.determineEnemyRace();
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        Agent agent;
        this.determineEnemyStrategy();
        this.determineEnemyRace();
        DebugMessages.addMessage("Enemy race: " + ScoutGroup.raceToString(enemyRace));
        if (!this.scoutsSent && game.getFrameCount() >= this.workerScoutTiming && this.workerScoutTiming != -1) {
            this.scoutsSent = true;
            int i = 0;
            while (i < this.nscouts) {
                this.requestWorkerScout();
                ++i;
            }
        }
        if (bot.suspectedEnemy.size() > 1) {
            ArrayList<BaseLocation> cleared = new ArrayList<BaseLocation>();
            BaseLocation enemyBase = null;
            for (BaseLocation se : bot.suspectedEnemy) {
                for (EnemyPosition p : EnemyManager.getManager().enemyBuildingMemory) {
                    if (!(se.getPosition().getDistance(p.pos.getX(), p.pos.getY()) <= 256.0)) continue;
                    enemyBase = se;
                    break;
                }
                if (enemyBase != null) break;
                if (!Tyr.game.isVisible(se.getTilePosition())) continue;
                cleared.add(se);
            }
            if (enemyBase != null && !clearEnemyExpands) {
                int i = bot.suspectedEnemy.size() - 1;
                while (i >= 0) {
                    if (bot.suspectedEnemy.get(i) != enemyBase) {
                        bot.expands.add(bot.suspectedEnemy.get(i));
                        bot.suspectedEnemy.remove(i);
                    }
                    --i;
                }
            } else {
                for (BaseLocation se : cleared) {
                    bot.expands.add(se);
                    bot.suspectedEnemy.remove(se);
                }
            }
        }
        if (this.keepScouting && this.units.size() < this.scoutCount && bot.homeGroup.units.size() > 4 && bot.bunkers.bunkersAreManned() && (self.getRace() != Race.Zerg || bot.homeGroup.units.size() >= 12) && (agent = bot.homeGroup.pop()) != null) {
            agent.order(new None(agent));
            this.add(agent);
        }
        ArrayList<Agent> done = new ArrayList<Agent>();
        for (Agent scout : this.units) {
            scout.drawCircle(Color.Purple);
            if (scout.getCommand().getClass() == KillWorkers.class) {
                if (!((KillWorkers)scout.getCommand()).breakOff) continue;
                scout.order(new None(scout));
                done.add(scout);
                continue;
            }
            if (!scout.unit.isIdle()) continue;
            ArrayList<BaseLocation> scoutLocations = null;
            scoutLocations = bot.suspectedEnemy.size() > 1 || scout.unit.getType().isWorker() ? bot.suspectedEnemy : bot.expands;
            if (scoutLocations.size() == 0) continue;
            int fullcycle = 0;
            while (fullcycle < 2) {
                ++this.scoutBase;
                if (this.scoutBase >= scoutLocations.size()) {
                    this.scoutBase = 0;
                    ++fullcycle;
                }
                if (!Tyr.game.isVisible(scoutLocations.get(this.scoutBase).getTilePosition())) break;
            }
            BaseLocation b = scoutLocations.get(this.scoutBase);
            if (!scout.unit.getType().isWorker()) {
                scout.unit.attack(b.getPosition());
            } else {
                scout.unit.move(b.getPosition());
            }
            if (!scout.unit.getType().isWorker() || !game.isVisible(b.getTilePosition()) || bot.suspectedEnemy == null || bot.suspectedEnemy.size() > 1 || scout.distanceSquared(b.getPosition()) > 16384) continue;
            scout.order(new KillWorkers(scout));
        }
        for (Agent scout : done) {
            this.rejects.add(scout);
            this.units.remove(scout);
        }
    }

    private void determineEnemyRace() {
        if (enemyRace == Race.Terran || enemyRace == Race.Protoss || enemyRace == Race.Zerg) {
            return;
        }
        DebugMessages.addMessage("Determining race.");
        if (!(Tyr.game.enemy().getRace() != Race.Terran && Tyr.game.enemy().getRace() != Race.Protoss && Tyr.game.enemy().getRace() != Race.Zerg || Settings.getDebug())) {
            enemyRace = Tyr.game.enemy().getRace();
        }
        for (Unit enemy : EnemyManager.getEnemyUnits()) {
            if (enemy.getType().getRace() != Race.Terran && enemy.getType().getRace() != Race.Protoss && enemy.getType().getRace() != Race.Zerg) continue;
            enemyRace = enemy.getType().getRace();
            break;
        }
    }

    public static String raceToString(Race race) {
        if (race == Race.Terran) {
            return "Terran";
        }
        if (race == Race.Protoss) {
            return "Protoss";
        }
        if (race == Race.Zerg) {
            return "Zerg";
        }
        if (race == Race.None) {
            return "None";
        }
        if (race == Race.Unknown) {
            return "Unknown";
        }
        if (race == Race.Random) {
            return "Random";
        }
        if (race == null) {
            return "null";
        }
        return "Undefined";
    }

    private void determineEnemyStrategy() {
        if (Tyr.game.enemy().getRace() == Race.Protoss) {
            if (this.opponentStrategy != tech && this.opponentStrategy != cannons) {
                int nexusCount = 0;
                for (EnemyPosition enemyPosition : EnemyManager.getManager().enemyBuildingMemory) {
                    if (enemyPosition.type != UnitType.Protoss_Nexus) continue;
                    ++nexusCount;
                }
                if (nexusCount >= 2) {
                    this.opponentStrategy = tech;
                }
                for (Unit unit : EnemyManager.getEnemyUnits()) {
                    if (unit.getType().gasPrice() <= 0 && unit.getType() != UnitType.Protoss_Assimilator && unit.getType() != UnitType.Protoss_Cybernetics_Core) continue;
                    this.opponentStrategy = tech;
                }
            }
            if (Tyr.game.getFrameCount() <= 5200 && this.opponentStrategy != tech && this.opponentStrategy != cannons) {
                int gatewayCount = 0;
                for (EnemyPosition enemyPosition : EnemyManager.getManager().enemyBuildingMemory) {
                    if (enemyPosition.type == UnitType.Protoss_Photon_Cannon || enemyPosition.type == UnitType.Protoss_Forge) {
                        this.opponentStrategy = cannons;
                    }
                    if (enemyPosition.type != UnitType.Protoss_Gateway) continue;
                    ++gatewayCount;
                }
                if (gatewayCount >= 2) {
                    this.opponentStrategy = zealotPush;
                }
            }
        }
        if (Tyr.game.enemy().getRace() == Race.Terran) {
            if (this.opponentStrategy != defensive) {
                for (EnemyPosition enemy : EnemyManager.getManager().enemyBuildingMemory) {
                    if (enemy.type != UnitType.Terran_Bunker) continue;
                    this.opponentStrategy = defensive;
                }
                int tankCount = 0;
                for (Unit unit : EnemyManager.getEnemyUnits()) {
                    if (unit.getType() != UnitType.Terran_Siege_Tank_Siege_Mode && unit.getType() != UnitType.Terran_Siege_Tank_Tank_Mode) continue;
                    ++tankCount;
                }
                if (tankCount >= 3) {
                    this.opponentStrategy = defensive;
                }
            }
            if (this.opponentStrategy == unknown) {
                int enemyInvadingWorkers = 0;
                for (Unit unit : EnemyManager.getEnemyUnits()) {
                    if (!unit.getType().isWorker() || unit.getDistance(Tyr.tileToPosition(Tyr.self.getStartLocation())) >= Settings.getLargeInvasionDist() || ++enemyInvadingWorkers <= 2) continue;
                    this.opponentStrategy = workerRush;
                    break;
                }
            }
        }
    }

    public void requestWorkerScout() {
        Agent scout = Tyr.bot.workForce.pop();
        if (scout != null) {
            this.units.add(scout);
            scout.unit.stop();
            this.scoutsSent = true;
        }
    }

    public void requestWorkerScoutOnce() {
        if (this.scoutsSent) {
            return;
        }
        Agent scout = Tyr.bot.workForce.pop();
        if (scout != null) {
            this.units.add(scout);
            scout.unit.stop();
            this.scoutsSent = true;
        }
    }

    public String getEnemyStrategy() {
        if (this.opponentStrategy == zealotPush) {
            return "Zealot push";
        }
        if (this.opponentStrategy == cannons) {
            return "Cannons";
        }
        return "Unknown";
    }

    public static boolean enemyRaceKnown() {
        return enemyRace == Race.Terran || enemyRace == Race.Protoss || enemyRace == Race.Zerg;
    }
}

