/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.unitgroups;

import bwapi.Color;
import bwapi.Game;
import bwapi.Order;
import bwapi.Player;
import bwapi.Position;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import com.tyr.EnemyManager;
import com.tyr.Tyr;
import com.tyr.agents.WorkerAgent;
import com.tyr.buildingplacement.BuildCommand;
import com.tyr.unitgroups.OutOfJob;
import com.tyr.unitgroups.UnitGroup;
import java.util.List;

public class BuilderGroup
extends UnitGroup {
    public BuilderGroup(OutOfJob rejects) {
        super(rejects);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        block0: for (BuildCommand buildCommand : bot.buildCommands) {
            if (buildCommand.removing) continue;
            if (((WorkerAgent)buildCommand.worker).isBlocked || buildCommand.worker.isDead() || buildCommand.worker.unit.getBuildUnit() != null || buildCommand.worker.unit.isMorphing()) {
                buildCommand.remove();
                continue;
            }
            if (buildCommand.building.isResourceDepot()) {
                int dist = 10000;
                if (buildCommand.worker.unit.isUnderAttack()) {
                    dist = 160000;
                }
                boolean underAttack = false;
                for (Unit enemy : EnemyManager.getEnemyUnits()) {
                    if (enemy.getType().isWorker() || enemy.getType() == UnitType.Zerg_Overlord || buildCommand.worker.distanceSquared(enemy) > dist) continue;
                    underAttack = true;
                    break;
                }
                if (underAttack) {
                    buildCommand.remove();
                    continue;
                }
            }
            for (Unit unit : self.getUnits()) {
                if (unit.getTilePosition().getX() != buildCommand.position.getX() || unit.getTilePosition().getY() != buildCommand.position.getY() || unit.getType() != buildCommand.building) continue;
                buildCommand.remove();
                continue block0;
            }
        }
        for (BuildCommand buildCommand : bot.buildCommands) {
            if (buildCommand.removing) continue;
            buildCommand.worker.drawCircle(Color.Blue);
            game.drawLineMap(buildCommand.getCenter().getX(), buildCommand.getCenter().getY(), buildCommand.worker.unit.getPosition().getX(), buildCommand.worker.unit.getPosition().getY(), Color.Blue);
            game.drawTextMap(buildCommand.worker.unit.getPosition().getX(), buildCommand.worker.unit.getPosition().getY(), buildCommand.worker.unit.getOrder().toString());
            game.drawBoxMap(buildCommand.position.getX() * 32, buildCommand.position.getY() * 32, buildCommand.position.getX() * 32 + 32 * buildCommand.building.tileWidth(), buildCommand.position.getY() * 32 + 32 * buildCommand.building.tileHeight(), Color.Orange);
            if (buildCommand.worker.unit.isConstructing() || !buildCommand.worker.unit.isGatheringMinerals() && (buildCommand.worker.unit.getOrder() == Order.PlaceBuilding || buildCommand.worker.unit.isMoving() && buildCommand.worker.unit.getOrder() != Order.PlayerGuard)) continue;
            if (game.canBuildHere(buildCommand.position, buildCommand.building, buildCommand.worker.unit, false)) {
                if (buildCommand.worker.unit.getTilePosition().getDistance(buildCommand.position) <= 60.0) {
                    buildCommand.worker.unit.build(buildCommand.building, buildCommand.position);
                    continue;
                }
                buildCommand.worker.unit.move(buildCommand.getCenter());
                continue;
            }
            TilePosition newpos = null;
            if (!buildCommand.fixed) {
                newpos = bot.spaceManager.getBuildTile(buildCommand.worker.unit, buildCommand.building, buildCommand.position);
            }
            if (newpos == null) {
                buildCommand.remove();
                game.printf("No suitable placement found.");
                continue;
            }
            buildCommand.position = newpos;
            if (buildCommand.worker.unit.getTilePosition().getDistance(newpos) <= 20.0) {
                buildCommand.worker.unit.build(buildCommand.building, newpos);
                continue;
            }
            if (!buildCommand.building.isResourceDepot() || buildCommand.worker.unit.getDistance(Tyr.tileToPosition(newpos)) <= 300) {
                buildCommand.worker.unit.move(buildCommand.getCenter());
                continue;
            }
            Unit mineral = this.getMineralInRange(Tyr.tileToPosition(newpos), 270, false);
            if (mineral != null) {
                buildCommand.worker.unit.gather(mineral);
                continue;
            }
            buildCommand.worker.unit.move(buildCommand.getCenter());
        }
        int i = 0;
        while (i < bot.buildCommands.size()) {
            BuildCommand com = bot.buildCommands.get(i);
            if (com.removing) {
                bot.buildCommands.set(i, bot.buildCommands.get(bot.buildCommands.size() - 1));
                bot.buildCommands.remove(bot.buildCommands.size() - 1);
                this.rejects.add(com.worker);
                this.remove(com.worker);
            }
            ++i;
        }
    }

    private Unit getMineralInRange(Position pos, int range, boolean blocking) {
        List<Unit> inRange = Tyr.game.getUnitsInRadius(pos, 270);
        for (Unit mineral : inRange) {
            if (!mineral.getType().isMineralField() || blocking && mineral.getResources() != 0) continue;
            return mineral;
        }
        return null;
    }
}

