/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.unitgroups;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.UnitType;
import com.tyr.BWTAProxy;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.Attack;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.unitgroups.IAttackGroup;

public class AttackNaturalGroup
extends IAttackGroup {
    public static int clearDistance = 400;
    public static int smallRetreatDistance = 500;
    public static int largeRetreatDistance = 650;
    boolean pullingBack = false;
    private Position enemyNatural = null;

    public AttackNaturalGroup(Position target) {
        super(target);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (BWTAProxy.initialized && Tyr.game.getFrameCount() > 100 && Tyr.bot.suspectedEnemy.size() == 1) {
            this.enemyNatural = SpaceManager.getEnemyNatural().getPosition();
        }
        boolean pulledBackPrev = this.pullingBack;
        boolean retreat = true;
        if (this.units.size() >= 30 || self.supplyUsed() >= 360) {
            retreat = false;
        }
        for (Agent agent : this.units) {
            if (agent.unit.getType() == UnitType.Protoss_Reaver && !agent.unit.isTraining() && agent.unit.getScarabCount() < 5) {
                agent.unit.train(UnitType.Protoss_Scarab);
            }
            if (retreat && this.enemyNatural != null) {
                double d = agent.distanceSquared(this.enemyNatural);
                int n = pulledBackPrev ? largeRetreatDistance : smallRetreatDistance;
                if (d <= Math.pow(n, 2.0)) {
                    this.pullingBack = true;
                    agent.unit.move(Tyr.tileToPosition(self.getStartLocation()));
                    continue;
                }
            }
            agent.order(new Attack(agent, this.target));
        }
    }
}

