/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.tasks.Task;
import com.tyr.tasks.VultureHarassSolution;

public class VultureHarassTask
extends Task {
    public static int desiredVultures = 4;
    public static int defendingUnitsNeeded = 10;
    private int startDir = 1;
    private boolean alternateDir = false;

    public VultureHarassTask() {
    }

    public VultureHarassTask(boolean alternateDir) {
        this.alternateDir = alternateDir;
    }

    public VultureHarassTask(int startDir) {
        this.startDir = startDir;
    }

    @Override
    public boolean isRequired(Game game, Player self, Tyr bot) {
        if (this.solution != null) {
            if (((VultureHarassSolution)this.solution).vultureCount() == 0) {
                this.solution = null;
            } else {
                return true;
            }
        }
        if (bot.homeGroup.units.size() < defendingUnitsNeeded) {
            return false;
        }
        if (EnemyManager.getManager().getOrderedExpands() == null) {
            return false;
        }
        int vultureCount = 0;
        for (Agent agent : bot.homeGroup.units) {
            if (agent.unit.getType() == UnitType.Terran_Vulture && ++vultureCount >= desiredVultures) break;
        }
        return vultureCount >= desiredVultures;
    }

    @Override
    public void solve(Game game, Player self, Tyr bot) {
        super.solve(game, self, bot);
    }

    @Override
    public void findSolution(Game game, Player self, Tyr bot) {
        this.solution = new VultureHarassSolution(this, this.startDir);
        if (this.alternateDir) {
            this.startDir = -this.startDir;
        }
        int vultureCount = 0;
        int i = bot.homeGroup.units.size() - 1;
        while (vultureCount < desiredVultures && i >= 0) {
            Agent agent = (Agent)bot.homeGroup.units.get(i);
            if (agent.unit.getType() == UnitType.Terran_Vulture) {
                ((VultureHarassSolution)this.solution).add(agent);
                bot.homeGroup.units.remove(i);
                ++vultureCount;
            }
            --i;
        }
    }

    public boolean isHarassing() {
        if (this.solution != null) {
            DebugMessages.addMessage("Harassing vultures: " + ((VultureHarassSolution)this.solution).vultureCount());
        }
        return this.solution != null && ((VultureHarassSolution)this.solution).vultureCount() > 0;
    }
}

