/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import bwta.Region;
import com.tyr.BWTAProxy;
import com.tyr.EnemyManager;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.tasks.Solution;
import com.tyr.tasks.Task;
import java.util.ArrayList;
import java.util.List;

public class SmeltingSolution
extends Solution {
    private List<Agent> gatekeepers = new ArrayList<Agent>();
    private List<Agent> dragoons = new ArrayList<Agent>();
    private List<Agent> others = new ArrayList<Agent>();
    private int mode = 0;
    private static final int CLOSED = 0;
    private static final int OPEN = 1;
    private Region defendedRegion;

    public SmeltingSolution(Task task) {
        super(task);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (game.getFrameCount() >= 120 && BWTAProxy.initialized && this.defendedRegion == null) {
            this.defendedRegion = BWTAProxy.getRegion(self.getStartLocation());
        }
        Agent.clean(this.gatekeepers);
        Agent.clean(this.dragoons);
        Agent.clean(this.others);
        ArrayList<Unit> enemies = new ArrayList<Unit>();
        for (Unit enemy : EnemyManager.getEnemyUnits()) {
            if (BWTAProxy.getRegion(enemy.getPosition()) != this.defendedRegion) continue;
            enemies.add(enemy);
        }
        if (enemies.isEmpty()) {
            for (Agent dragoon : this.dragoons) {
                dragoon.unit.move(Tyr.getStartLocation());
            }
        } else {
            int enemyPos = 0;
            for (Agent dragoon : this.dragoons) {
                Unit enemy = (Unit)enemies.get(enemyPos);
                dragoon.attack(enemy);
                enemyPos = (enemyPos + 1) % enemies.size();
            }
        }
        for (Agent other : this.others) {
            other.unit.move(Tyr.getStartLocation());
        }
        if (this.mode == 0) {
            this.closed(enemies.size());
        } else {
            this.open(enemies.size());
        }
    }

    private void closed(int enemyCount) {
        Position exit = SpaceManager.getMainExit();
        if (exit != null) {
            for (Agent gatekeeper : this.gatekeepers) {
                if (gatekeeper.distanceSquared(exit) >= 10000) {
                    gatekeeper.unit.move(exit);
                    gatekeeper.drawCircle(Color.Blue);
                    continue;
                }
                if (!gatekeeper.unit.isMoving()) continue;
                gatekeeper.unit.holdPosition();
                gatekeeper.drawCircle(Color.White);
            }
        }
        if (this.dragoons.size() >= 3 && enemyCount == 0) {
            this.mode = 1;
        }
    }

    public void open(int enemyCount) {
        for (Agent gatekeeper : this.gatekeepers) {
            gatekeeper.unit.move(Tyr.getStartLocation());
        }
        if (this.dragoons.size() < 3 || enemyCount >= 1) {
            this.mode = 0;
        }
    }

    public void add(Agent agent) {
        if (agent.unit.getType() != UnitType.Protoss_Dragoon) {
            this.others.add(agent);
        } else if (this.gatekeepers.size() >= 2) {
            this.dragoons.add(agent);
        } else {
            this.gatekeepers.add(agent);
        }
    }

    public int size() {
        return this.dragoons.size() + this.others.size() + this.gatekeepers.size();
    }

    public boolean done() {
        return this.size() == 0;
    }

    public void removeUnits() {
        for (Agent agent : this.gatekeepers) {
            Tyr.bot.homeGroup.add(agent);
        }
        for (Agent agent : this.dragoons) {
            Tyr.bot.homeGroup.add(agent);
        }
        for (Agent agent : this.others) {
            Tyr.bot.homeGroup.add(agent);
        }
        this.gatekeepers = new ArrayList<Agent>();
        this.dragoons = new ArrayList<Agent>();
        this.others = new ArrayList<Agent>();
    }
}

