/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.UnitType;
import com.tyr.BWTAProxy;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.tasks.SiegeNaturalSolution;
import com.tyr.tasks.Task;

public class SiegeNaturalTask
extends Task {
    private Position target;
    public int requiredTanks = 6;
    public int requiredReinforcements = 2;
    public static boolean done;

    @Override
    public boolean isRequired(Game game, Player self, Tyr bot) {
        if (done) {
            return false;
        }
        return bot.suspectedEnemy.size() == 1;
    }

    @Override
    public void solve(Game game, Player self, Tyr bot) {
        if (!BWTAProxy.initialized) {
            return;
        }
        boolean newTarget = this.acquireTarget(bot);
        if (newTarget) {
            ((SiegeNaturalSolution)this.solution).setTarget(this.target);
        }
        int tankCount = 0;
        for (Agent agent : bot.homeGroup.units) {
            if (agent.unit.getType() != UnitType.Terran_Siege_Tank_Tank_Mode && agent.unit.getType() != UnitType.Terran_Siege_Tank_Siege_Mode) continue;
            ++tankCount;
        }
        if (tankCount >= this.requiredReinforcements && UnitTracker.countTanks() >= this.requiredTanks) {
            int i = bot.homeGroup.units.size() - 1;
            while (i >= 0) {
                Agent agent = (Agent)bot.homeGroup.units.get(i);
                ((SiegeNaturalSolution)this.solution).add(agent);
                bot.homeGroup.units.remove(i);
                --i;
            }
        }
        super.solve(game, self, bot);
        if (((SiegeNaturalSolution)this.solution).done() && !done) {
            ((SiegeNaturalSolution)this.solution).done(bot.homeGroup);
            this.solution = null;
            done = true;
        }
    }

    @Override
    public void findSolution(Game game, Player self, Tyr bot) {
        if (BWTAProxy.initialized) {
            this.acquireTarget(bot);
        }
        this.solution = new SiegeNaturalSolution(this, this.target);
    }

    public boolean acquireTarget(Tyr bot) {
        if (this.target == null) {
            this.target = bot.suspectedEnemy.get(0).getPosition();
            return true;
        }
        return false;
    }
}

