/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import com.tyr.Force;
import com.tyr.ForceTracker;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.None;
import com.tyr.agents.VesselSupport;
import com.tyr.tasks.Solution;
import com.tyr.tasks.Task;
import java.util.ArrayList;
import java.util.List;

public class ScienceHurtsSolution
extends Solution {
    private ArrayList<Agent> scienceVessels = new ArrayList();
    Agent defendingVessel = null;

    public ScienceHurtsSolution(Task task) {
        super(task);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (this.defendingVessel != null && this.defendingVessel.isDead()) {
            this.defendingVessel = null;
        }
        int i = this.scienceVessels.size() - 1;
        while (i >= 0) {
            if (this.scienceVessels.get(i).isDead()) {
                this.scienceVessels.remove(i);
            }
            --i;
        }
        List<Force> forces = ForceTracker.forces;
        for (Agent vessel : this.scienceVessels) {
            if (vessel.getCommand() != null && vessel.getCommand() instanceof VesselSupport && ((VesselSupport)vessel.getCommand()).supportedForce != null) {
                vessel.drawCircle(Color.Purple, 16);
                continue;
            }
            if (vessel == this.defendingVessel) continue;
            if (this.defendingVessel == null && this.scienceVessels.size() > 1) {
                this.defendingVessel = vessel;
                continue;
            }
            Force closest = null;
            int distSq = Integer.MAX_VALUE;
            int fs = 0;
            for (Force f : forces) {
                if (f.done() || f.disabled()) continue;
                int newDistSq = vessel.distanceSquared(f.getCenter());
                if (newDistSq < distSq) {
                    newDistSq = distSq;
                    closest = f;
                }
                ++fs;
            }
            if (fs == 0) {
                vessel.drawCircle(Color.Yellow, 16);
            } else if (closest == null) {
                vessel.drawCircle(Color.Green, 16);
            } else {
                vessel.drawCircle(Color.Blue, 16);
            }
            vessel.order(new VesselSupport(vessel, closest));
        }
    }

    public void add(Agent agent) {
        agent.order(new None(agent));
        this.scienceVessels.add(agent);
    }
}

